/* $Id: multiSort.c,v 1.7 1995/09/04 14:09:00 lupus Exp lupus $ */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "xfinans.h"
#include "multiSort.h"

#define cDATE    'd'
#define cNUMBER  'n'
#define cTEXT    't'
#define cAMOUNT  'a'
#define cCOMMIT  'c'
#define cCATEGORY 'y'

#define num_compare(x,y) (((x)<(y)) ? -1 : ((x)>(y)))
#define sign_of(x) num_compare((x),0)

#define TRESHOLD 6

typedef struct postering * element_type;

void swap(element_type data[], int i1, int i2) {
  element_type t;
  t=data[i1];
  data[i1]=data[i2];
  data[i2]=t;
}

int order_of(int crite) {
  if( crite>='A' && crite<='Z' )
    return DECREASE;
  else
    return INCREASE;
}

int compare(element_type s1, element_type s2, int crite) {  
/* return -1 if s1<s2,  1 if s1>s2,  0 if s1==s2 */
  switch(crite) {
  case cDATE:
    return num_compare(s1->dato, s2->dato);
  case cNUMBER:
    return num_compare(s1->number, s2->number);
  case cTEXT:
    return sign_of(strcmp(s1->tekst, s2->tekst));
  case cAMOUNT:
    return num_compare(s1->bel, s2->bel);
  case cCOMMIT:
    return num_compare(s1->committed, s2->committed);
  case cCATEGORY:
    return num_compare(s1->category, s2->category);
  default:
    return( 1 );
  }
}

void bubblesort(element_type data[], int i1, int i2, int crite, int order) {
  int i,j;
  for(i=i1; i<i2; i++) {
    j=i+1;
    while(j>i1 && compare(data[j],data[j-1],crite)==order ) {
      swap(data, j, j-1);
      j--;
    }
  }
}

/* ------------  Quick Sort: -----------------  */

/* pivot-finder: Median_of_3 */

element_type median_of_3(element_type l[], int min_index, int max_index,
			 int crite, int order)
{
   element_type shots[3];
   int mid;
   shots[0]=l[min_index];
   shots[2]=l[max_index];
   mid=(min_index+max_index)/2;
   shots[1]=l[mid];

   bubblesort(shots,0,2,crite,order);

   return shots[1];
}

void quicksort(element_type l[], int i, int j, int crite, int order)
{
   element_type pivot;
   int ileft, iright, jleft, jright;

   if( j-i < TRESHOLD ) {
     bubblesort(l,i,j,crite,order);
     return;
   }
   if( i<j ) {
      pivot=median_of_3(l,i,j,crite,order);
      /* printf("qs: %d-%d  %d  %s\n", i,j,crite,pivot->tekst); */
      ileft=i;
      jright=j;
      i--;
      j++;
      do {
         do
            i++;
         while( compare(l[i],pivot,crite)==order );
         do
            j--;
         while( compare(pivot,l[j],crite)==order );
         if( i<j )
            swap(l,i,j);
      } while( i<j );

      if( i>j ) {
         iright=j;
         jleft=i;
      }
      else {
         iright=j-1;
         jleft=i+1;
      }

      quicksort(l,ileft,iright,crite,order);
      quicksort(l,jleft,jright,crite,order);
    }
}

/* ---------------------------------------------- */

void multiSort(element_type data[], int i1, int i2, 
	       int order, int iter, int maxIter, char crite[]) 
{
  int i,j;
  if(iter>maxIter)
    return;

  /* bubblesort(data, i1, i2, tolower(crite[iter]), order); */
  quicksort(data, i1, i2, tolower(crite[iter]), order);

  if(iter==maxIter)
    return;

  for(i=i1; i<i2; i++ ) {
    j=i;
    while( i<i2 && !compare(data[i],data[i+1],tolower(crite[iter])) )
      i++;
    if(i>j) {
      multiSort(data, j, i, order_of(crite[iter+1]), iter+1, maxIter, crite);
    }
  }
}
  
