/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: mach_syscalls.h,v $
 * Revision 1.1.27.1  1996/04/12  06:12:14  paire
 * 	Removed <kern/clock.h>
 * 	Fixed syscall_task_create() prototype
 * 	[96/03/15            paire]
 *
 * Revision 1.1.17.6  1996/01/09  19:21:48  devrcs
 * 	Correct function prototype for syscall_task_info().
 * 	Update prototypes with io_buf_len_t or mach_msg_type_number_t.
 * 	[1995/12/01  19:49:15  jfraser]
 * 
 * 	Merged '64-bit safe' changes from DEC alpha port.
 * 	[1995/11/21  18:08:53  jfraser]
 * 
 * Revision 1.1.17.5  1995/01/10  05:17:24  devrcs
 * 	mk6 CR668 - 1.3b26 merge
 * 	64bit cleanup, fix prototypes, ledgers, security.
 * 	fix syscall_thread_switch prototype
 * 	[1994/11/02  18:17:44  dwm]
 * 
 * 	Update mk6_shared (based on nmk18b4) to cnmk_shared.
 * 	[1994/10/04  19:06:32  bolinger]
 * 
 * Revision 1.1.17.4  1994/09/28  17:47:36  dswartz
 * 	Merged with changes from 1.1.17.3
 * 	[1994/09/28  17:46:11  dswartz]
 * 
 * 	mach_port_allocate* changes [CR 461]
 * 	[1994/09/28  17:38:55  dswartz]
 * 
 * Revision 1.1.17.3  1994/09/23  02:39:06  ezf
 * 	change marker to not FREE
 * 	[1994/09/22  21:41:08  ezf]
 * 
 * Revision 1.1.17.2  1994/08/18  23:13:45  widyono
 * 	o syscall_mach_port_allocate_rt(), new
 * 	o syscall_task_set_port_space(), new
 * 	[1994/07/28  22:35:03  widyono]
 * 
 * Revision 1.1.17.1  1994/08/07  20:49:30  bolinger
 * 	Import colo_shared revision into NMK18.
 * 	[1994/08/02  16:41:37  bolinger]
 * 
 * Revision 1.1.10.8  1994/07/08  20:08:48  dwm
 * 	mk6 CR227 - Add vm_remap.
 * 	[1994/07/08  20:02:06  dwm]
 * 
 * Revision 1.1.10.7  1994/05/20  00:28:10  dwm
 * 	mk6 CR 65.  Trapify mach_port_move_member
 * 	[1994/05/20  00:26:53  dwm]
 * 
 * Revision 1.1.10.6  1994/05/03  22:42:10  dwm
 * 	Add trap-based mach_port_allocate_subsystem.
 * 	[1994/05/03  19:55:56  dwm]
 * 
 * Revision 1.1.10.5  1994/03/16  14:54:14  rod
 * 	I/O completion queue support:
 * 	  New traps - device_read_async, device_read_overwrite_async,
 * 	  device_write_async, device_write_async_inband,
 * 	  device_read_async_inband, io_done_queue_wait.
 * 	[1994/03/11  14:55:22  rod]
 * 
 * Revision 1.1.10.4  1994/03/02  21:49:51  bolinger
 * 	Add prototype for syscall_thread_switch().
 * 	[1994/03/02  20:57:37  bolinger]
 * 
 * Revision 1.1.10.3  1994/03/02  00:50:00  dwm
 * 	Newly trap-based services: task_set_exception_ports, mach_port_rename,
 * 	vm_protect, vm_region, task_info
 * 	[1994/03/02  00:44:42  dwm]
 * 
 * Revision 1.1.10.2  1994/02/26  18:07:30  dwm
 * 	Newly trap-based services: vm_msync, mach_port_destroy,
 * 	thread_set_exception_ports.
 * 	[1994/02/26  18:06:03  dwm]
 * 
 * Revision 1.1.10.1  1994/01/05  19:45:52  bolinger
 * 	Add prototype for syscall_kernel_task_create().
 * 	[1994/01/05  17:59:31  bolinger]
 * 
 * Revision 1.1.2.5  1993/10/21  18:25:21  jeffc
 * 	CR9784 - Add vm_behavior_set support
 * 	[1993/10/20  18:24:14  jeffc]
 * 
 * Revision 1.1.2.4  1993/08/03  22:23:39  bernard
 * 	CR#9523 - ANSI prototype fixes.
 * 	[1993/08/03  15:37:02  bernard]
 * 
 * Revision 1.1.2.3  1993/07/27  18:09:11  rod
 * 	Add more MACH syscall trap prototypes.  CR #9523.
 * 	[1993/07/27  10:43:49  rod]
 * 
 * Revision 1.1.2.2  1993/07/20  16:11:49  jeffc
 * 	CR9523 - Add prototypes to mach kernel.
 * 	[1993/07/20  15:33:51  jeffc]
 * 
 * $EndLog$
 */

#ifndef _MACH_MACH_MIGCALLS_H_
#define	_MACH_MACH_MIGCALLS_H_

#include <mach/kern_return.h>
#include <mach/boolean.h>
#include <mach/port.h>
#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <mach/exception.h>
#include <device/device_types.h>

extern kern_return_t mig_task_create(
				mach_port_t		parent_task,
				ledger_port_array_t	ledgers,
				mach_msg_type_number_t	num_ledgers,
				boolean_t		inherit_memory,
				mach_port_t		*child_task);

extern kern_return_t mig_kernel_task_create(
				mach_port_t	parent_task,
				vm_offset_t	map_base,
				vm_size_t	map_size,
				mach_port_t	*child_task);

extern kern_return_t mig_task_terminate(
				mach_port_t	task);

extern kern_return_t mig_vm_allocate(
				mach_port_t	target_map,
				vm_offset_t	*address,
				vm_size_t	size,
				boolean_t	anywhere);

extern kern_return_t mig_vm_deallocate(
				mach_port_t	target_map,
				vm_offset_t	start,
				vm_size_t	size);

extern kern_return_t mig_vm_behavior_set(
				mach_port_t	target_map,
				vm_offset_t	address,
				vm_size_t	size,
				vm_behavior_t	new_behavior);

extern kern_return_t mig_vm_write(
				mach_port_t		target_map,
				vm_address_t		address,
				vm_offset_t		data,
				mach_msg_type_number_t	size);

extern kern_return_t mig_task_suspend(
				mach_port_t	task);

extern kern_return_t mig_task_set_special_port(
				mach_port_t	task,
				int		which_port,
				mach_port_t	port_name);

extern kern_return_t mig_vm_map(
				mach_port_t	target_map,
				vm_offset_t	*address,
				vm_size_t	size,
				vm_offset_t	mask,
				boolean_t	anywhere,
				mach_port_t	memory_object,
				vm_offset_t	offset,
				boolean_t	copy,
				vm_prot_t	cur_protection,
				vm_prot_t	max_protection,
				vm_inherit_t	inheritance);

extern kern_return_t mig_vm_remap(
				mach_port_t	target_map,
				vm_offset_t	*address,
				vm_size_t	size,
				vm_offset_t	mask,
				boolean_t	anywhere,
				mach_port_t	src_map,
				vm_offset_t	memory_address,
				boolean_t	copy,
				vm_prot_t	*cur_protection,
				vm_prot_t	*max_protection,
				vm_inherit_t	inheritance);

extern kern_return_t mig_vm_region(
				mach_port_t		target_map,
				vm_offset_t		*address,
				vm_size_t		*size,
				vm_region_flavor_t	flavor,
				vm_region_info_t	info,
				mach_msg_type_number_t	*count,
				mach_port_t		*object_name);


extern kern_return_t mig_thread_create_running(
				mach_port_t	parent_task,
				int		flavor,
				thread_state_t	new_state,
				natural_t	new_state_count,
				mach_port_t	*child_thread);

extern kern_return_t mig_vm_read_overwrite(
				mach_port_t	target_map,
				vm_address_t	address,
				vm_size_t	size,
				vm_address_t	data,
				vm_size_t	*data_size);

extern kern_return_t mig_mach_port_allocate(
				mach_port_t		task,
				mach_port_right_t	right,
				mach_port_t		*namep);

extern kern_return_t mig_mach_port_allocate_name(
				mach_port_t		task,
				mach_port_right_t	right,
				mach_port_t		name);

extern kern_return_t mig_mach_port_deallocate(
				mach_port_t	task,
				mach_port_t	name);

extern kern_return_t mig_mach_port_destroy(
				mach_port_t	task,
				mach_port_t	name);

extern kern_return_t mig_mach_port_insert_right(
				mach_port_t		task,
				mach_port_t		name,
				mach_port_t		right,
				mach_msg_type_name_t	rightType);

extern kern_return_t mig_mach_port_move_member(
				mach_port_t		task,
				mach_port_t		name,
				mach_port_t		after);

extern kern_return_t mig_thread_depress_abort(
				mach_port_t	thread);

extern kern_return_t	mig_clock_get_time(
				mach_port_t	clock_name,
				tvalspec_t	*cur_time);	/* OUT */

extern kern_return_t	clock_sleep_trap(
				mach_port_t	clock_name,
				sleep_type_t	sleep_type,
				int		sleep_sec,
				int		sleep_nsec,
				tvalspec_t	*wakeup_time);

extern kern_return_t mig_device_read(
				mach_port_t		device,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted,
				io_buf_ptr_t		*data_ptr,
				mach_msg_type_number_t	*data_count_ptr);

extern kern_return_t mig_device_read_overwrite(
				mach_port_t		device,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted,
				vm_address_t		buffer,
				mach_msg_type_number_t	*data_count_ptr);

extern kern_return_t mig_device_read_request(
				mach_port_t		device,
				mach_port_t		reply_port,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted);

extern kern_return_t mig_device_read_overwrite_request(
				mach_port_t		device,
				mach_port_t		reply_port,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted,
				vm_address_t		buffer);

extern kern_return_t device_read_async(
				mach_port_t		device,
				mach_port_t		queue,
				mach_port_t		request_id,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted);

extern kern_return_t device_read_async_inband(
				mach_port_t		device,
				mach_port_t		queue,
				mach_port_t		request_id,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted);

extern kern_return_t device_read_overwrite_async(
				mach_port_t		device,
				mach_port_t		queue,
				mach_port_t		request_id,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_len_t		bytes_wanted,
				vm_address_t		buffer);

extern kern_return_t mig_device_write(
				mach_port_t		device,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_ptr_t		data,
				mach_msg_type_number_t	data_count,
				io_buf_len_t		*bytes_written_ptr);

extern kern_return_t mig_device_write_request(
				mach_port_t		device,
				mach_port_t		reply_port,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_ptr_t		data,
				mach_msg_type_number_t	data_count);

extern kern_return_t device_write_async(
				mach_port_t		device,
				mach_port_t		queue,
				mach_port_t		request_id,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_ptr_t		data,
				mach_msg_type_number_t	data_count);

extern kern_return_t device_write_async_inband(
				mach_port_t		device,
				mach_port_t		queue,
				mach_port_t		request_id,
				dev_mode_t		mode,
				recnum_t		recnum,
				io_buf_ptr_t		data,
				mach_msg_type_number_t	data_count);

extern kern_return_t io_done_queue_wait(
				mach_port_t		queue,
				io_done_result_t	*result);

extern	kern_return_t	evc_wait(
				unsigned	ev_id);

extern	kern_return_t	mig_vm_msync(
				mach_port_t             target_map,
				vm_address_t            address,
				vm_size_t               size,
				vm_sync_t               sync_flags);

extern	kern_return_t	mig_thread_set_exception_ports(
				mach_port_t		thread,
				exception_mask_t	new_mask,
				mach_port_t		new_port,
				exception_behavior_t	new_behavior,
				thread_state_flavor_t	new_flavor);

extern	kern_return_t	mig_mach_port_destroy(
				mach_port_t		task,
				mach_port_t		name);

extern	kern_return_t	mig_task_set_exception_ports(
				mach_port_t		task,
				exception_mask_t	new_mask,
				mach_port_t		new_port,
				exception_behavior_t	new_behavior,
				thread_state_flavor_t	new_flavor);

extern	kern_return_t	mig_mach_port_rename(
				mach_port_t		task,
				mach_port_t		old_name,
				mach_port_t		new_name);

extern kern_return_t mig_vm_protect(
				mach_port_t	target_map,
				vm_offset_t	address,
				vm_size_t	size,
				boolean_t	set_maximum,
				vm_prot_t	new_protection);

extern kern_return_t mig_vm_remap(
				mach_port_t	target_map,
				vm_offset_t	*address,
				vm_size_t	size,
				vm_offset_t	mask,
				boolean_t	anywhere,
				mach_port_t	src_map,
				vm_offset_t	memory_address,
				boolean_t	copy,
				vm_prot_t	*cur_protection,
				vm_prot_t	*max_protection,
				vm_inherit_t	inheritance);

extern kern_return_t mig_vm_region(
				mach_port_t		target_map,
				vm_address_t		*address,
				vm_size_t		*size,
				vm_region_flavor_t	flavor,
				vm_region_info_t	info,
				mach_msg_type_number_t	*count,
				mach_port_t		*object_name);

extern kern_return_t mig_task_info(
				mach_port_t		task,
				task_flavor_t		flavor,
				task_info_t		info_out,
				mach_msg_type_number_t	*info_cnt);

extern	kern_return_t	mig_mach_port_allocate_subsystem(
				mach_port_t		task,
				mach_port_t		subsystem_name,
				mach_port_t		*namep);

extern kern_return_t mig_mach_port_allocate_qos(
				mach_port_t		task,
				mach_port_right_t	right,
				mach_port_qos_t		*qosp,
				mach_port_t		*namep);

extern kern_return_t mig_mach_port_allocate_full(
				mach_port_t		task,
				mach_port_right_t	right,
				mach_port_t		subsystem_name,
				mach_port_qos_t		*qos,
				mach_port_t		*namep);

extern kern_return_t mig_task_set_port_space(
				mach_port_t	task,
				int		table_entries);

/*
 * NB: definition of below function is still in kern/syscall_subr.c --
 * it's very messy to move it elsewhere.
 */
extern kern_return_t mig_thread_switch(
				mach_port_t		thread_name,
				int			option,
				mach_msg_timeout_t	option_time);

#endif	/* _MACH_MACH_MIGCALLS_H_ */
