/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: machine.h,v $
 * Revision 1.2.26.2  1996/04/12  16:27:55  emcmanus
 * 	Checked in prior to merge.
 * 	[1996/04/12  08:49:59  emcmanus]
 *
 * Revision 1.2.26.1  1996/04/11  11:19:34  emcmanus
 * 	Pointless merge required by ODE.
 * 	[1996/04/11  11:13:47  emcmanus]
 * 
 * 	Merged with mainline.ppc.
 * 	[1996/04/10  16:56:26  emcmanus]
 * 
 * Revision 1.2.21.1  1996/01/15  13:53:52  stephen
 * 	Added CPU_TYPE_POWERPC, and subtypes for PowerPC range (using PVR values)
 * 	[1996/01/15  13:50:40  stephen]
 * 
 * Revision 1.2.27.1  1996/04/12  06:12:23  paire
 * 	Added new CPU_SUBTYPE_MBUS, CPU_SUBTYPE_MPS and CPU_SUBTYPE_HPPA_7*
 * 	cpu subtypes, and new CPU_TYPE_I486, CPU_TYPE_PENTIUM and
 * 	CPU_TYPE_PENTIUMPRO cpu types
 * 	[95/11/24            paire]
 * 
 * Revision 1.2.12.3  1996/01/09  19:22:00  devrcs
 * 	Added Alpha subtypes.
 * 	[1995/12/01  19:49:18  jfraser]
 * 
 * 	Merged '64-bit safe' changes from DEC alpha port.
 * 	[1995/11/21  18:09:10  jfraser]
 * 
 * Revision 1.2.12.2  1995/01/06  19:51:13  devrcs
 * 	mk6 CR668 - 1.3b26 merge
 * 	64bit cleanup
 * 	[1994/10/14  03:42:54  dwm]
 * 
 * Revision 1.2.12.1  1994/09/23  02:39:40  ezf
 * 	change marker to not FREE
 * 	[1994/09/22  21:41:26  ezf]
 * 
 * Revision 1.2.4.3  1993/08/03  18:29:33  gm
 * 	CR9596: Change KERNEL to MACH_KERNEL.
 * 	[1993/08/02  18:16:24  gm]
 * 
 * Revision 1.2.4.2  1993/06/09  02:41:54  gm
 * 	Added to OSF/1 R1.3 from NMK15.0.
 * 	[1993/06/02  21:17:13  jeffc]
 * 
 * Revision 1.2  1993/04/19  16:35:45  devrcs
 * 	Added CPU_SUBTYPE_SQT86	for OSF/1 IK compatibility
 * 	[93/02/12            bernadat]
 * 
 * 	ansi C conformance changes
 * 	[1993/02/02  18:53:29  david]
 * 
 * Revision 1.1  1992/09/30  02:31:22  robert
 * 	Initial revision
 * 
 * $EndLog$
 */
/* CMU_HIST */
/*
 * Revision 2.13.5.4  92/09/15  17:23:42  jeffreyh
 * 	New 860 names from Intel
 * 	[92/09/10            jeffreyh]
 * 
 * Revision 2.13.5.3  92/05/27  00:46:46  jeffreyh
 * 	Initial Paragon support.
 * 	[andyp@ssd.intel.com]
 * 
 * Revision 2.13.5.2  92/03/28  10:11:11  jeffreyh
 * 	Pick up changes from MK71
 * 	[92/03/20  13:21:20  jeffreyh]
 * 
 * Revision 2.14  92/02/19  15:08:38  elf
 * 	Added more Sparc subtypes.
 * 	[92/02/19            rpd]
 * 
 * Revision 2.13.5.1  92/02/18  19:13:35  jeffreyh
 * 	Added sub cpu type for Corollary MP
 * 	[91/06/25            bernadat]
 *
 * Revision 2.13  91/12/10  16:32:50  jsb
 * 	Fixes from Intel
 * 	[91/12/10  15:51:57  jsb]
 * 
 * Revision 2.12  91/07/31  17:53:56  dbg
 * 	Remove declaration of interrupt_stack - it is machine-dependent.
 * 	Changed CPU_SUBTYPE_LUNA88K - there's already a (potential)
 * 	mc88000 port.
 * 	[91/07/26            dbg]
 * 
 * Revision 2.11  91/07/09  23:22:06  danner
 * 	   Added CPU_SUBTYPE_LUNA88K
 * 	[91/05/06            danner]
 * 
 * Revision 2.10  91/05/14  16:55:24  mrt
 * 	Correcting copyright
 * 
 * Revision 2.9  91/05/08  12:49:54  dbg
 * 	Add CPU_SUBTYPE_SYMMETRY.
 * 	[91/04/26  14:44:44  dbg]
 * 
 * Revision 2.8  91/02/05  17:33:48  mrt
 * 	Changed to new Mach copyright
 * 	[91/02/01  17:18:51  mrt]
 * 
 * Revision 2.7  90/12/04  14:51:27  jsb
 * 	Renamed CPU_SUBTYPE_iPSC2 as CPU_SUBTYPE_iPSC386.
 * 	[90/12/03  22:22:25  jsb]
 * 
 * Revision 2.6  90/11/25  17:48:28  jsb
 * 	Added CPU_TYPE_I860 and CPU_SUBTYPE_iPSC860.
 * 	[90/11/25  16:51:44  jsb]
 * 
 * Revision 2.5  90/09/23  17:45:42  jsb
 * 	Added CPU_SUBTYPE_iPSC2.
 * 	[90/09/21  16:43:01  jsb]
 * 
 * Revision 2.4  90/08/07  22:23:05  rpd
 * 	Added new MIPS subtypes for R3000, fix old defs.
 * 	[90/08/07  15:54:40  af]
 * 
 * Revision 2.3  90/06/02  14:58:47  rpd
 * 	Picked up new cpu types.
 * 	[90/03/26  22:34:38  rpd]
 * 
 * Revision 2.2  89/11/29  14:09:32  af
 * 	Changes for MACH_KERNEL:
 * 	. Removed should_exit.
 * 
 * 	17-May-1989 Randall W. Dean (rwd)
 * 	changed machine/vm_types.h to mach/vm_param.h
 * 	[89/05/23            dbg]
 * 
 * Revision 2.1  89/08/03  16:02:33  rwd
 * Created.
 * 
 * Revision 2.11  89/04/18  16:43:32  mwyoung
 * 	Use <machine/vm_types.h> rather than <vm/vm_param.h> to get
 * 	VM types.  Remove old history... none of it was insightful.
 * 
 * 	The variable declarations should be moved elsewhere.
 * 	[89/01/24            mwyoung]
 * 
 * Revision 2.2.4.1  90/06/11  10:59:52  af
 * 	Added new MIPS subtypes for R3000, fix old defs.
 * 
 */
/* CMU_ENDHIST */
/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989,1988,1987 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 */
/*	File:	machine.h
 *	Author:	Avadis Tevanian, Jr.
 *	Date:	1986
 *
 *	Machine independent machine abstraction.
 */

#ifndef	_MACH_MACHINE_H_
#define _MACH_MACHINE_H_

#ifdef	MACH_KERNEL
#include <cpus.h>
#endif	/* MACH_KERNEL */

#include <mach/machine/vm_types.h>
#include <mach/boolean.h>

/*
 *	For each host, there is a maximum possible number of
 *	cpus that may be available in the system.  This is the
 *	compile-time constant NCPUS, which is defined in cpus.h.
 *
 *	In addition, there is a machine_slot specifier for each
 *	possible cpu in the system.
 */

struct machine_info {
	integer_t	major_version;	/* kernel major version id */
	integer_t	minor_version;	/* kernel minor version id */
	int		max_cpus;	/* max number of cpus compiled */
	int		avail_cpus;	/* number actually available */
	vm_size_t	memory_size;	/* size of memory in bytes */
};

typedef struct machine_info	*machine_info_t;
typedef struct machine_info	machine_info_data_t;	/* bogus */

typedef integer_t	cpu_type_t;
typedef integer_t	cpu_subtype_t;

#define CPU_STATE_MAX		3

#define CPU_STATE_USER		0
#define CPU_STATE_SYSTEM	1
#define CPU_STATE_IDLE		2

struct machine_slot {
	boolean_t	is_cpu;		/* is there a cpu in this slot? */
	cpu_type_t	cpu_type;	/* type of cpu */
	cpu_subtype_t	cpu_subtype;	/* subtype of cpu */
	integer_t	running;	/* is cpu running */
	integer_t	cpu_ticks[CPU_STATE_MAX];
	integer_t	clock_freq;	/* clock interrupt frequency */
};

typedef struct machine_slot	*machine_slot_t;
typedef struct machine_slot	machine_slot_data_t;	/* bogus */

#ifdef	MACH_KERNEL
extern struct machine_info	machine_info;
extern struct machine_slot	machine_slot[NCPUS];
#endif	/* MACH_KERNEL */

/*
 *	Machine types known by all.
 *
 *	When adding new types & subtypes, please also update slot_name.c
 *	in the libmach sources.
 */

#define CPU_TYPE_VAX		((cpu_type_t) 1)
#define CPU_TYPE_ROMP		((cpu_type_t) 2)
#define CPU_TYPE_MC68020	((cpu_type_t) 3)
#define CPU_TYPE_NS32032	((cpu_type_t) 4)
#define CPU_TYPE_NS32332        ((cpu_type_t) 5)
#define CPU_TYPE_NS32532        ((cpu_type_t) 6)
#define CPU_TYPE_I386		((cpu_type_t) 7)
#define CPU_TYPE_MIPS		((cpu_type_t) 8)
#define	CPU_TYPE_MC68030	((cpu_type_t) 9)
#define CPU_TYPE_MC68040	((cpu_type_t) 10)
#define CPU_TYPE_HPPA           ((cpu_type_t) 11)
#define CPU_TYPE_ARM		((cpu_type_t) 12)
#define CPU_TYPE_MC88000	((cpu_type_t) 13)
#define CPU_TYPE_SPARC		((cpu_type_t) 14)
#define CPU_TYPE_I860		((cpu_type_t) 15)
#define CPU_TYPE_ALPHA		((cpu_type_t) 16)
#define	CPU_TYPE_I486		((cpu_type_t) 17)
#define	CPU_TYPE_PENTIUM	((cpu_type_t) 18)
#define	CPU_TYPE_PENTIUMPRO	((cpu_type_t) 19)
#define CPU_TYPE_POWERPC	((cpu_type_t) 20)

/*
 *	Machine subtypes (these are defined here, instead of in a machine
 *	dependent directory, so that any program can get all definitions
 *	regardless of where is it compiled).
 */

/*
 *	VAX subtypes (these do *not* necessarily conform to the actual cpu
 *	ID assigned by DEC available via the SID register).
 */

#define CPU_SUBTYPE_VAX780	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_VAX785	((cpu_subtype_t) 2)
#define CPU_SUBTYPE_VAX750	((cpu_subtype_t) 3)
#define CPU_SUBTYPE_VAX730	((cpu_subtype_t) 4)
#define CPU_SUBTYPE_UVAXI	((cpu_subtype_t) 5)
#define CPU_SUBTYPE_UVAXII	((cpu_subtype_t) 6)
#define CPU_SUBTYPE_VAX8200	((cpu_subtype_t) 7)
#define CPU_SUBTYPE_VAX8500	((cpu_subtype_t) 8)
#define CPU_SUBTYPE_VAX8600	((cpu_subtype_t) 9)
#define CPU_SUBTYPE_VAX8650	((cpu_subtype_t) 10)
#define CPU_SUBTYPE_VAX8800	((cpu_subtype_t) 11)
#define CPU_SUBTYPE_UVAXIII	((cpu_subtype_t) 12)

/*
 *	Alpha subtypes (these do *not* necessary conform to the actual cpu
 *	ID assigned by DEC available via the SID register).
 */

#define CPU_SUBTYPE_ALPHA_ADU		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_DEC_4000		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_DEC_7000		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_DEC_3000_500	((cpu_subtype_t) 4)
#define CPU_SUBTYPE_DEC_3000_400	((cpu_subtype_t) 5)
#define CPU_SUBTYPE_DEC_10000		((cpu_subtype_t) 6)
#define CPU_SUBTYPE_DEC_3000_300        ((cpu_subtype_t) 7)
#define CPU_SUBTYPE_DEC_2000_300        ((cpu_subtype_t) 8)
#define CPU_SUBTYPE_DEC_2100_A500	((cpu_subtype_t) 9)
#define CPU_SUBTYPE_DEC_MORGAN		((cpu_subtype_t) 11)
#define CPU_SUBTYPE_DEC_AVANTI          ((cpu_subtype_t) 13)
#define CPU_SUBTYPE_DEC_MUSTANG         ((cpu_subtype_t) 14)

/*
 *	ROMP subtypes.
 */

#define CPU_SUBTYPE_RT_PC	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_RT_APC	((cpu_subtype_t) 2)
#define CPU_SUBTYPE_RT_135	((cpu_subtype_t) 3)

/*
 *	68020 subtypes.
 */

#define CPU_SUBTYPE_SUN3_50	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_SUN3_160	((cpu_subtype_t) 2)
#define CPU_SUBTYPE_SUN3_260	((cpu_subtype_t) 3)
#define CPU_SUBTYPE_SUN3_110	((cpu_subtype_t) 4)
#define CPU_SUBTYPE_SUN3_60	((cpu_subtype_t) 5)

#define CPU_SUBTYPE_HP_320	((cpu_subtype_t) 6)
	/* 16.67 Mhz HP 300 series, custom MMU [HP 320] */
#define CPU_SUBTYPE_HP_330	((cpu_subtype_t) 7)
	/* 16.67 Mhz HP 300 series, MC68851 MMU [HP 318,319,330,349] */
#define CPU_SUBTYPE_HP_350	((cpu_subtype_t) 8)
	/* 25.00 Mhz HP 300 series, custom MMU [HP 350] */

/*
 *	32032/32332/32532 subtypes.
 */

#define CPU_SUBTYPE_MMAX_DPC	    ((cpu_subtype_t) 1)	/* 032 CPU */
#define CPU_SUBTYPE_SQT		    ((cpu_subtype_t) 2) /* Symmetry */
#define CPU_SUBTYPE_MMAX_APC_FPU    ((cpu_subtype_t) 3)	/* 32081 FPU */
#define CPU_SUBTYPE_MMAX_APC_FPA    ((cpu_subtype_t) 4)	/* Weitek FPA */
#define CPU_SUBTYPE_MMAX_XPC	    ((cpu_subtype_t) 5)	/* 532 CPU */
#define CPU_SUBTYPE_SQT86	    ((cpu_subtype_t) 6) /* ?? */

/*
 *	80386/80486/Pentium subtypes.
 */

#define CPU_SUBTYPE_AT386	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_EXL		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_iPSC386	((cpu_subtype_t) 3)
#define	CPU_SUBTYPE_SYMMETRY	((cpu_subtype_t) 4)	/* Sequent */
#define	CPU_SUBTYPE_CBUS	((cpu_subtype_t) 5)	/* Cbus (Compaq) */
#define	CPU_SUBTYPE_MBUS	((cpu_subtype_t) 6)	/* Mbus (Corollary) */
#define	CPU_SUBTYPE_MPS		((cpu_subtype_t) 7)	/* Intel MP Spec. */

/*
 *	Mips subtypes.
 */

#define CPU_SUBTYPE_MIPS_R2300	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_MIPS_R2600	((cpu_subtype_t) 2)
#define CPU_SUBTYPE_MIPS_R2800	((cpu_subtype_t) 3)
#define CPU_SUBTYPE_MIPS_R2000a	((cpu_subtype_t) 4)	/* pmax */
#define CPU_SUBTYPE_MIPS_R2000	((cpu_subtype_t) 5)
#define CPU_SUBTYPE_MIPS_R3000a	((cpu_subtype_t) 6)	/* 3max */
#define CPU_SUBTYPE_MIPS_R3000	((cpu_subtype_t) 7)

/*
 * 	MC68030 subtypes.
 */

#define CPU_SUBTYPE_NeXT	((cpu_subtype_t) 1) 
	/* NeXt thinks MC68030 is 6 rather than 9 */
#define CPU_SUBTYPE_HP_340	((cpu_subtype_t) 2) 
	/* 16.67 Mhz HP 300 series [HP 332,340] */
#define CPU_SUBTYPE_HP_360	((cpu_subtype_t) 3) 
	/* 25.00 Mhz HP 300 series [HP 360] */
#define CPU_SUBTYPE_HP_370	((cpu_subtype_t) 4) 
	/* 33.33 Mhz HP 300 series [HP 370] */

/*
 *	HPPA subtypes.
 */

#define CPU_SUBTYPE_HPPA_825		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_HPPA_835		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_HPPA_840		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_HPPA_850		((cpu_subtype_t) 4)
#define CPU_SUBTYPE_HPPA_855		((cpu_subtype_t) 5)
#define	CPU_SUBTYPE_HPPA_705		((cpu_subtype_t) 6)
#define	CPU_SUBTYPE_HPPA_710		((cpu_subtype_t) 7)
#define	CPU_SUBTYPE_HPPA_720		((cpu_subtype_t) 8)
#define	CPU_SUBTYPE_HPPA_725		((cpu_subtype_t) 9)
#define	CPU_SUBTYPE_HPPA_730       	((cpu_subtype_t)10)
#define	CPU_SUBTYPE_HPPA_750		((cpu_subtype_t)11)
#define	CPU_SUBTYPE_HPPA_770		((cpu_subtype_t)12)
#define	CPU_SUBTYPE_HPPA_777		((cpu_subtype_t)13)

/*
 * 	ARM subtypes.
 */

#define CPU_SUBTYPE_ARM_A500_ARCH	((cpu_subtype_t) 1)
#define CPU_SUBTYPE_ARM_A500		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_ARM_A440		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_ARM_M4		((cpu_subtype_t) 4)
#define CPU_SUBTYPE_ARM_A680		((cpu_subtype_t) 5)

/*
 *	MC88000 subtypes.
 */

#define CPU_SUBTYPE_MMAX_JPC		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_LUNA88K             ((cpu_subtype_t) 2)

/*
 *	Sparc subtypes.
 */

#define CPU_SUBTYPE_SUN4_260		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_SUN4_110		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_SUN4_330		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_SUN4C_60		((cpu_subtype_t) 4)
#define CPU_SUBTYPE_SUN4C_65		((cpu_subtype_t) 5)
#define CPU_SUBTYPE_SUN4C_20		((cpu_subtype_t) 6)
#define CPU_SUBTYPE_SUN4C_30		((cpu_subtype_t) 7)
#define CPU_SUBTYPE_SUN4C_40		((cpu_subtype_t) 8)
#define CPU_SUBTYPE_SUN4C_50		((cpu_subtype_t) 9)
#define CPU_SUBTYPE_SUN4C_75		((cpu_subtype_t) 10)

/*
 *	i860 subtypes.
 */

#define CPU_SUBTYPE_iPSC860		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_PARAGON860		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_PARAGON860_MP	((cpu_subtype_t) 3)
#define CPU_SUBTYPE_OKI860		((cpu_subtype_t) 4)

/*
 *	Alpha subtypes.
 */

#define CPU_SUBTYPE_ALPHA_EV3		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_ALPHA_EV4		((cpu_subtype_t) 2)
#define CPU_SUBTYPE_ALPHA_ISP		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_ALPHA_21064		((cpu_subtype_t) 4)

/*
 *	PowerPc subtypes. These are defined as the values in the upper
 *	16 bits of the PVR register of the CPU in question.
 */

#define CPU_SUBTYPE_PPC601		((cpu_subtype_t) 1)
#define CPU_SUBTYPE_PPC603		((cpu_subtype_t) 3)
#define CPU_SUBTYPE_PPC604		((cpu_subtype_t) 4)
#define CPU_SUBTYPE_PPC602		((cpu_subtype_t) 5)
#define CPU_SUBTYPE_PPC603e		((cpu_subtype_t) 6)
#define CPU_SUBTYPE_PPC603ev		((cpu_subtype_t) 7)
#define CPU_SUBTYPE_PPC604e		((cpu_subtype_t) 9)
#define CPU_SUBTYPE_PPC620		((cpu_subtype_t) 20)

#endif	/* _MACH_MACHINE_H_ */
