/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: limits.h,v $
 * Revision 1.1.4.1  1996/04/11  14:36:52  emcmanus
 * 	Copied from mainline.ppc.
 * 	[1996/04/11  14:36:06  emcmanus]
 *
 * Revision 1.1.2.1  1995/12/28  16:37:13  barbou
 * 	Self-Contained Mach Distribution:
 * 	created.
 * 	[95/12/28            barbou]
 * 
 * $EndLog$
 */
/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	@(#)machlimits.h	7.1 (Berkeley) 2/15/89
 */
#ifndef _MACHINE_LIMITS_H_
#define _MACHINE_LIMITS_H_

#define	CHAR_BIT	8		/* number of bits in a char */

#define	SCHAR_MAX	127		/* max value for a signed char */
#define	SCHAR_MIN	(-128)		/* min value for a signed char */

#define	UCHAR_MAX	255U		/* max value for an unsigned char */
#define	CHAR_MAX	127		/* max value for a char */
#define	CHAR_MIN	(-128)		/* min value for a char */

#define	USHRT_MAX	65535U		/* max value for an unsigned short */
#define	SHRT_MAX	32767		/* max value for a short */
#define	SHRT_MIN	(-32768)	/* min value for a short */

#define	UINT_MAX	0xFFFFFFFFU	/* max value for an unsigned int */
#define	INT_MAX		2147483647	/* max value for an int */
#define	INT_MIN		(-2147483647-1)	/* min value for an int */

#define	ULONG_MAX	UINT_MAX	/* max value for an unsigned long */
#define	LONG_MAX	INT_MAX		/* max value for a long */
#define	LONG_MIN	INT_MIN		/* min value for a long */

/* Must be at least two, for internationalization (NLS/KJI) */
#define MB_LEN_MAX	4		/* multibyte characters */

#endif /* _MACHINE_LIMITS_H_ */
