/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: vm_param.h,v $
 * Revision 1.1.8.2  1996/08/07  14:20:41  stephen
 * 	removed KERN_VIDEO_MAP definition
 * 	[1996/08/07  14:18:45  stephen]
 *
 * Revision 1.1.8.1  1996/06/07  16:03:58  stephen
 * 	added KERNEL_SR1
 * 	pushed USER_STACK_END up to top of VM
 * 	[1996/06/07  15:43:34  stephen]
 * 
 * Revision 1.1.6.1  1996/04/11  11:20:22  emcmanus
 * 	Copied from mainline.ppc.
 * 	[1996/04/10  16:57:11  emcmanus]
 * 
 * Revision 1.1.4.2  1995/12/18  16:19:11  stephen
 * 	Added VM_MAX_KERNEL_LOADED_ADDRESS
 * 	[1995/12/18  14:45:58  stephen]
 * 
 * Revision 1.1.4.1  1995/11/23  17:37:09  stephen
 * 	first powerpc checkin to mainline.ppc
 * 	[1995/11/23  16:45:44  stephen]
 * 
 * Revision 1.1.2.2  1995/10/10  15:07:19  stephen
 * 	return from apple
 * 	[1995/10/10  14:34:43  stephen]
 * 
 * 	moved some stuff around
 * 
 * Revision 1.1.2.1  1995/08/25  06:50:00  stephen
 * 	Initial checkin of files for PowerPC port
 * 	[1995/08/23  15:05:00  stephen]
 * 
 * $EndLog$
 */
#ifndef	_MACH_PPC_VM_PARAM_H_
#define _MACH_PPC_VM_PARAM_H_

#define BYTE_SIZE	8	/* byte size in bits */

#define PPC_PGBYTES	4096	/* bytes per ppc page */
#define PPC_PGSHIFT	12	/* number of bits to shift for pages */

#define VM_MIN_ADDRESS	((vm_offset_t) 0)
#define VM_MAX_ADDRESS	((vm_offset_t) 0xfffff000U)

#define KERNELBASE_TEXT   0x800000	        /* Virt addr of kernel text */
#define KERNELBASE_TEXT_OFFSET   0x800000	/* diff to physical addr*/
#define KERNELBASE_DATA   0x200000		/* Virt addr of kernel data */
#define KERNELBASE_DATA_OFFSET 0

#define VM_MIN_KERNEL_ADDRESS	((vm_offset_t) 0x00001000)

/* We map the kernel using only SR0 and SR1, leaving segments alone */
#define VM_MAX_KERNEL_ADDRESS	((vm_offset_t) 0x1fffffff)

#define USER_STACK_END  ((vm_offset_t) 0xffff0000U)

#define ppc_round_page(x)	((((unsigned)(x)) + PPC_PGBYTES - 1) & \
					~(PPC_PGBYTES-1))
#define ppc_trunc_page(x)	(((unsigned)(x)) & ~(PPC_PGBYTES-1))

/*
 * Physical memory is mapped 1-1 with virtual memory starting at address
 * VM_MIN_KERNEL_ADDRESS
 */
#define phystokv(a)	((vm_offset_t)(a) + VM_MIN_KERNEL_ADDRESS) 

#if	MACH_KERNEL
#define KERNEL_STACK_SIZE	(PPC_PGBYTES)
#define INTSTACK_SIZE		(5 * PPC_PGBYTES)
#endif	/* MACH_KERNEL */

#ifndef ASSEMBLER

#define VM_MIN_KERNEL_LOADED_ADDRESS	((vm_offset_t)  0x10000000U)
#define VM_MAX_KERNEL_LOADED_ADDRESS	((vm_offset_t)  0x1FFFFFFFU)

#else /* ASSEMBLER */

#define VM_MIN_KERNEL_LOADED_ADDRESS	0x10000000
#define VM_MAX_KERNEL_LOADED_ADDRESS	0x1FFFFFFF

#endif /* ASSEMBLER */

#endif	/* _PPC_VM_PARAM_H_ */
