/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: exception.h,v $
 * Revision 1.1.10.1  1996/08/09  17:22:54  stephen
 * 	Added EXC_PPC_TRACE and some cleanup
 * 	[1996/08/09  17:21:48  stephen]
 *
 * 	hppa merge
 * 	[1995/03/15  09:45:42  bruel]
 *
 * Revision 1.1.6.1  1996/04/11  11:19:49  emcmanus
 * 	Copied from mainline.ppc.
 * 	[1996/04/10  16:56:41  emcmanus]
 * 
 * Revision 1.1.4.2  1996/01/12  15:49:08  stephen
 * 	Removed dummy definition
 * 	[1996/01/12  14:35:29  stephen]
 * 
 * Revision 1.1.4.1  1995/11/23  17:36:46  stephen
 * 	first powerpc checkin to mainline.ppc
 * 	[1995/11/23  16:44:44  stephen]
 * 
 * Revision 1.1.2.1  1995/08/25  06:49:36  stephen
 * 	Initial checkin of files for PowerPC port
 * 	[1995/08/23  16:28:04  stephen]
 * 
 * 	Initial checkin of files for PowerPC port
 * 	[1995/08/23  15:03:51  stephen]
 * 
 * Revision 1.1.2.2  1994/03/16  14:33:40  bruel
 * 	made EXC_TYPES_COUNT machine dependant.
 * 	[94/03/11            bruel]
 * 
 * 	hp800 -> hp700.
 * 	[94/02/22            bruel]
 * 
 * Revision 1.1.2.1  1994/02/11  13:28:15  bruel
 * 	Added new exceptions flags.
 * 	[93/11/22            bruel]
 * 
 * 	Created from Utah.
 * 	[93/11/22            bruel]
 * 
 * $EndLog$
 */
/* 
 * Copyright (c) 1990, 1991, 1992, The University of Utah and
 * the Center for Software Science at the University of Utah (CSS).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 * 	Utah $Hdr: $
 */

#ifndef	_MACH_PPC_EXCEPTION_H_
#define _MACH_PPC_EXCEPTION_H_


/* STATUS - TODO - this is just transcribed from hp stuff */

#define	EXC_TYPES_COUNT	10	/* incl. illegal exception 0 */

#define EXCEPTION_CODE_MAX 2    /* elements in vector (code+subcode) */
/*
 *	EXC_BAD_INSTRUCTION
 */

#define EXC_PPC_INVALID_SYSCALL	1    /* invalid syscall number */
#define EXC_PPC_UNIPL_INST	2    /* unimplemented instruction */
#define EXC_PPC_PRIVINST	3    /* priviledged instruction */
#define EXC_PPC_PRIVREG		4    /* priviledged register */
#define EXC_PPC_TRACE		5    /* trace/single-step */

/*
 *	EXC_BAD_ACCESS
 *	Note: do not conflict with kern_return_t values returned by vm_fault
 */

#define EXC_PPC_VM_PROT_READ		0x101 /* error reading syscall args */
#define EXC_PPC_BADSPACE		0x102 /* bad space referenced */
#define EXC_PPC_UNALIGNED		0x103 /* unaligned data reference */

/*
 *	EXC_ARITHMETIC
 */

#define EXC_PPC_OVERFLOW		1    /* integer overflow */
#define EXC_PPC_ZERO_DIVIDE		2    /* integer divide by zero */
#define EXC_PPC_FLT_INEXACT		3    /* IEEE inexact exception */
#define EXC_PPC_FLT_ZERO_DIVIDE		4    /* IEEE zero divide */
#define EXC_PPC_FLT_UNDERFLOW		5    /* IEEE floating underflow */
#define EXC_PPC_FLT_OVERFLOW		6    /* IEEE floating overflow */
#define EXC_PPC_FLT_NOT_A_NUMBER	7    /* IEEE not a number */

/*
 * EXC_PPC_NOEMULATION should go away when we add software emulation
 * for floating point. Right now we don't support this.
 */

#define EXC_PPC_NOEMULATION		8    /* no floating point emulation */


/*
 *	EXC_SOFTWARE
 */
#define EXC_PPC_MIGRATE		0x10100		/* Time to bolt */


/*
 *	EXC_BREAKPOINT
 */

#define EXC_PPC_BREAKPOINT		1    /* breakpoint trap */

/*
 *	machine dependent exception masks
 */
#define	EXC_MASK_MACHINE	0

#endif	/* _MACH_PPC_EXCEPTION_H_ */
