/* Debugging software assembler code	*/ 
# SPEC_FILE = mcu.sp; /* This statement is required at the
			   beginning of the ASSEM_FILE. It tells
			   where the SPEC_FILE can be found. */

# LIST_FILE = mcu.lst; /* This statement specifies the name for
                           the assembler listing file.  If not
                           included, no listing will be created */

# MASK_COUNT = 8; /* This statement is required to mask out 8
                           bits of the 16 bit op-code to produce 2 PROM
                           files. Use with the 'assem16to8' command. */

# SET_ADDRESS = 0; /* This statement tells the program at what
			   address to start assembling. The address
                           given is a hexadecimal number. */

# LOAD_ADDRESS = 100; /* this tells the compiler where in the PROM the
				actual instruction goes, since for MCU
				testing, this was set to 100 (A8=1),
				I decided not to bother changing it and
				allowing for another bug to creep up  */


START:	ASSERT UART_RDAV;	/* clean anything in the UART */
	CALL RESET_CLOCK;	/* Reset the H in the clock to zero */
GET_Block:
	CALL WAITDAV;		/* wait for the UART to have some data ready */
	CJMP UART_bstart FIND_SWITCH;	/* if it is not a start block marker, try again */
	JMP Get_Block;		/* else, process the block */
FIND_SWITCH:
	ASSERT UART_RDAV;	/* clear and wait for more data from the UART */
	CALL WAITDAV;
	CJMP UART_match READ_H;  /* if the first four bits are the same as the switches */
	JMP GET_Block;	         /* then read the H vlaues into RAM, else get the next block */
READ_H:
	ASSERT UART_RDAV; 	/* clear and wait for more UART data */
	CALL WAITDAV;
	ASSERT Mem_Hsel Mem_WR;		/* write the byte into the H */
	ASSERT Mem_Hcnt UART_RDAV;	/* count up in H, the next write will write to +1 */
	CJMP Mem_Hcar READ_H;		/* loop until Hcar (fifteen times) */
	ASSERT UART_RDAV;		/* again clear, and wait for the last H value */
	CALL WAITDAV;
	ASSERT Mem_Hsel Mem_WR;		/* write it in */
	ASSERT Mem_Hcnt UART_RDAV;	/* count once more and clear the UART (Hclk:=0) */

MAIN_LOOP:   /* this part does the Finite Impulse Response */
	ASSERT A2D_W A2D_CE ALU_Clear;	/* sample analogue signal and clear the accumulator */
	CALL WAIT_STATUS;
A2D_Sram:
	ASSERT A2D_CE Mem_WR;		/* put the signal into SRAM */
MUL_ADD_LOOP:				/* here, x (h counter) is 0, y is last left value */
	ASSERT Mem_OE Mem_Hsel;		/* multiply H[x] * S[y], add to accumulator */
	ASSERT Mem_OE ALU_add;
	ASSERT Mem_Scnt Mem_Hcnt;	/* x++, y++ */
	CJMP Mem_Hcar MUL_ADD_LOOP;	/* repeat fifteen times */
FINISH:
	ASSERT Mem_OE Mem_Hsel;		/* again multiply and accumulat H[x] * S[y] */
	ASSERT Mem_OE ALU_add;
	ASSERT Mem_Hcnt;		/* only increment Hcounter (x), so Scounter is */
					/* functionally moved back one from value held when */
					/* entering the loop, this will later overwrite the */
					/* oldest signal in memory (due to looparound)      */
	ASSERT D2A_CE;			/* output the accumulated value. */
	
	JMP MAIN_LOOP;			/* Repeat forever (or until reset is pushed  */


/* ================================================== */
/* Useful functions called from several places in the code */

WAIT_STATUS:		/* this part induces a small delay and waits
				for status to go low again */
	CJMP A2D_status WAIT_STATUS;
	RETURN;

WAITDAV:			/* wait for DAV assertion from UART */
	CJMP UART_DAV EXWTDAV;
	JMP WAITDAV;
EXWTDAV:  
	ASSERT UART_RDE;
	RETURN;

RESET_CLOCK:			/* initialize H to zero */
	ASSERT Mem_Hcnt;
	CJMP Mem_Hcar RESET_CLOCK;
	ASSERT Mem_Hcnt; 	/* Wrap it around */
	RETURN;
/* ================================================== */


