/* mcu.sp for the MCU debugging */
/* Last revised 3-9-92         */

/****************************************************************/
/* Instruction Word Organization:				*/
/*   conditional statements		iiiiuccc aaaaaaaa	*/
/*   immediate data statement		iiiissss vvvvvvvv	*/
/*   assertion statements		iiiissss ssssssss	*/
/*    where i = opcode selection				*/
/*          u = unconditional bit				*/
/*          c = status selection				*/
/*          a = alternative address, i.e. jump address		*/
/*	    v = immediate values, i.e. binary data		*/
/*          s = assertion signals				*/
/****************************************************************/

op <15:0>;			/* Indicates the available bits		     */

address op <7:0>;		/* Indicates bit locations for addresses     */

value op <7:0>;			/* Indicates bit locations for immediate val */

/*
 * There is nothing magic about upper case.
 * You may change things to lower case as you wish.
 * Remember, the assembler maps all characters to lower case anyway!
 */

/*
 * Instruction Set of AM29C10A
 * All of the instructions available are defined.
 * In all likelihood, you will only use a subset.
 */

RESET	op<15:12>=%b0000;	/* Jump Zero (RESET)			     */
CCALL	op<15:12>=%b0001;	/* Cond CALL subroutine			     */
CJMP	op<15:12>=%b0011;	/* Cond JuMP				     */
PUSH	op<15:12>=%b0100;	/* PUSH stack down / cond load counter	     */
CJSRP	op<15:12>=%b0101;	/* Cond Jump to Subroutine via Register Pipe */
CJRP	op<15:12>=%b0111;	/* Cond Jump via Register Pipeline	     */
RFCT	op<15:12>=%b1000;	/* Repeat loop with File when CounTer != 0   */
RPCT	op<15:12>=%b1001;	/* Repeat loop with Pipeline when CounTer!=0 */
CRTN	op<15:12>=%b1010;	/* Cond ReTurN				     */
CJPP	op<15:12>=%b1011;	/* Cond Jump Pipeline and Pop		     */
LDCT	op<15:12>=%b1100;	/* LoaD CounTer				     */
LOOP	op<15:12>=%b1101;	/* test end-of-LOOP			     */
ASSERT	op<15:12>=%b1110;	/* continue, perform the ASSERTions          */
TWB	op<15:12>=%b1111;	/* Three-Way-Branch			     */

 /* Unconditional branch statements */

CALL	op<15:11>=%b00011;	/* CALL subroutine			     */
JMP	op<15:11>=%b00111;	/* JuMP					     */
JSRP	op<15:11>=%b01011;	/* Jump to Subroutine via Register Pipeline  */
JRP	op<15:11>=%b01111;	/* Jump via Register Pipeline		     */
RETURN	op<15:11>=%b10101;	/* RETURN				     */
JPP	op<15:11>=%b10111;	/* Jump Pipeline and Pop		     */

/* These are defined so that you may use them to make your code more
 * readable.  Their use is not required. */

IF	nop;
THEN	nop;
TRUE	op<11>=1;		/* This makes sure /CCEN is deasserted	     */

/* Assertions */
UART_RDAV	op<0> = 1;
UART_RDE	op<1> = 1;

ALU_clear	op<2> = 1;
ALU_add		op<3> = 1;

A2D_W		op<4> = 1;
A2D_CE		op<5> = 1;

D2A_CE		op<6> = 1;

Mem_Hsel	op<7> = 1;
Mem_Hcnt	op<8> = 1;
Mem_Scnt	op<9> = 1;
Mem_WR		op<10> = 1;
Mem_OE		op<11> = 1;

/*
 * Status signals:
 * Make sure that all status signals that change during mcu operation
 * are synchronized to the system /CLK
 */

UART_dav	op<10:8>=1;
UART_bstart	op<10:8>=2;
UART_match	op<10:8>=3;
Mem_Hcar	op<10:8>=4;
A2D_status	op<10:8>=5;
A2D_clock	op<10:8>=6;
