#ifndef _RABIN_H
#define _RABIN_H

#include "common.h"
#include "utils.h"

#define TEMP_PRIME_SIZE 15  // number of bits for modified rabin prime
#define NUMBER_TRIES    5  // number of passes to use by default.

typedef struct {
  Integer p, q, n;
} rabin_private_key;

typedef struct {
  Integer n;
} rabin_public_key;

extern void       gen_rabin_key    (rabin_private_key *);
extern void       rabin_sign       (rabin_private_key, signed_message *);
extern int        rabin_check      (rabin_public_key, signed_message);
extern void       mod_rabin_sign   (rabin_private_key, signed_message *);
extern int        mod_rabin_check  (rabin_public_key, signed_message, int);

#endif	
