#include <iostream.h>
extern "C" {
  #include <sys/time.h>
}
#include "utils.h"
#include "rabin.h"
#include "rsa.h"
#include "quick_mod.h"

#define REPEAT 5

int main(), valid();
void test();

int main(){

  init();
  test();
}

int valid()
{
return 1;
}

void test()
/* Yep.. this tests the routines to see if they do the right thing */
{
  Integer            temp;
  signed_message     m;
  rabin_public_key   rabin_p;
  rabin_private_key  rabin_s;
  rsa_public_key     rsa_p;
  rsa_private_key    rsa_s;
  struct timeval     thing, thing2;
  long               secs, usecs, total_usecs;
  int                repetitions;

  cout << "Inverse      --\n";
  ((inverse(5, 11) == 9) || (inverse(5, 11) == 9) || 
   (inverse(5, 11) == 9) || (inverse(5, 11) == 9)) ? cout << "\t\tokay\n" : cout << "\t\tERROR\n";

  cout << "crt          --\n";
  (crt2(2, 5, 3, 13) == 42 ) ? cout << "\t\tokay\n" : cout << "\t\tERROR\n";

  cout << "square root  --\n";
  ((sqrt2(4, 7, 11) == 9) ||
   (sqrt2(4, 7, 11) == 2) ||
   (sqrt2(4, 7, 11) == 75) ||
   (sqrt2(4, 7, 11) == 68)) ? cout << "\t\tokay\n" : cout << "\t\tERROR\n";

  cout << "legendre     --\n";
  (legendre(4, 23) == 1) ? cout << "\t\tokay\n" : cout << "\t\tERROR\n";
  (legendre(5, 7) == -1) ? cout << "\t\tokay\n" : cout << "\t\tERROR\n";

  cout << "Rabin sign   --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){
    gen_rabin_key(&rabin_s);
    rabin_p.n = rabin_s.n;
    do {
      temp = generate_random((SIZE_OF_KEYS-1)*2);
    } while (!((legendre(temp, rabin_s.p) == 1) && (legendre(temp, rabin_s.q) == 1)));
    m.msg = temp;
    rabin_sign(rabin_s, &m);
    gettimeofday(&thing, NULL);
    (rabin_check(rabin_p, m)) ? cout << "." : cout << "X";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  secs=0; usecs=0;
  total_usecs /= REPEAT;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";



  cout << "Mod-Rabin -- valid signatures  --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){
    gen_rabin_key(&rabin_s);
    rabin_p.n = rabin_s.n;
    do {
      temp = generate_random((SIZE_OF_KEYS-1)*2);
    } while (!((legendre(temp, rabin_s.p) == 1) && (legendre(temp, rabin_s.q) == 1)));
    m.msg = temp;
    mod_rabin_sign(rabin_s, &m);
    gettimeofday(&thing, NULL);
    (mod_rabin_check(rabin_p, m, NUMBER_TRIES)) ? cout << "." : cout << "X";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  total_usecs /= REPEAT;
  secs=0; usecs=0;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";

  cout << "Mod-Rabin, quick -- valid signatures  --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){
    gen_rabin_key(&rabin_s);
    rabin_p.n = rabin_s.n;
    do {
      temp = generate_random((SIZE_OF_KEYS-1)*2);
    } while (!((legendre(temp, rabin_s.p) == 1) && (legendre(temp, rabin_s.q) == 1)));
    m.msg = temp;
    mod_rabin_sign(rabin_s, &m);
    init_quick_sig(NUMBER_TRIES);
    (check_sig_quick(rabin_p, m, &thing)) ? cout << "." : cout << "X";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  total_usecs /= REPEAT;
  secs=0; usecs=0;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";

  cout << "Mod-Rabin -- bogus signatures  --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){  
    gen_rabin_key(&rabin_s);
    rabin_p.n = rabin_s.n;
    do {
      temp = generate_random((SIZE_OF_KEYS-1)*2);
    } while (!((legendre(temp, rabin_s.p) == 1) && (legendre(temp, rabin_s.q) == 1)));
    m.msg = temp;
    m.sig = generate_random(SIZE_OF_KEYS-1);
    gettimeofday(&thing, NULL);
    (mod_rabin_check(rabin_p, m, NUMBER_TRIES)) ? cout << "X" : cout << ".";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  total_usecs /= REPEAT;
  secs=0; usecs=0;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";

  cout << "Mod-Rabin, quick -- bogus signatures  --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){  
    gen_rabin_key(&rabin_s);
    rabin_p.n = rabin_s.n;
    do {
      temp = generate_random((SIZE_OF_KEYS-1)*2);
    } while (!((legendre(temp, rabin_s.p) == 1) && (legendre(temp, rabin_s.q) == 1)));
    m.msg = temp;
    m.sig = generate_random(SIZE_OF_KEYS-1);
    init_quick_sig(NUMBER_TRIES);
    (check_sig_quick(rabin_p, m, &thing)) ? cout << "X" : cout << ".";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  total_usecs /= REPEAT;
  secs=0; usecs=0;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";



  cout << "RSA sign     --\n";
  total_usecs = 0;
  for (repetitions=1; repetitions <=REPEAT; repetitions++){  
    gen_rsa_key(&rsa_s);
    rsa_p.n = rsa_s.n;
    rsa_p.e = rsa_s.e;
    m.msg = generate_random(SIZE_OF_KEYS - 1);
    rsa_sign(rsa_s, &m);
    gettimeofday(&thing, NULL);
    (rsa_check(rsa_p, m)) ? cout << "." : cout << "X";
    gettimeofday(&thing2, NULL);
    secs = thing2.tv_sec - thing.tv_sec;
    usecs = thing2.tv_usec - thing.tv_usec;
    if (usecs < 0) {
      usecs += 1000000;
      secs -= 1;
    }
    total_usecs = total_usecs + secs*1000000 + usecs;
  }
  total_usecs /= REPEAT;
  secs=0; usecs=0;
  while (total_usecs > 1000000) {
    secs += 1;
    total_usecs -= 1000000;
  }
  usecs = total_usecs;
  cout << "  average time =  " << secs << " secs : " << usecs << " usecs\n";
}
