#include <Integer.h>

#define PRIMES_IN_FILE 50 // number of primes in a pregenerated file
#define LARGEST_PRIME_DIGITS 1024 // largest size expecting to find
                                  // in prime_file.xk
#define TIMES_TO_REPEAT 5 // times to repeat Miller-Rabin

// prototypes of stuff in utils.C 
extern void          init            ();
extern Integer       exp_mod         (Integer, Integer, Integer);
extern long          exp_mod         (long, long, long);
extern Integer       generate_prime  (int);
extern Integer       generate_random (int);
extern Integer       crt             (Integer [], Integer [], Integer);
extern Integer       crt2            (Integer, Integer, Integer, Integer);
extern Integer       sqrt            (Integer, Integer[], int);
extern Integer       sqrt2           (Integer, Integer, Integer);
extern Integer       inverse         (Integer, Integer);
extern int           legendre        (Integer, Integer);
extern int           legendre        (long, long);
