;;; lj-bbdb.el --- BBDB support for ljupdate

;; Copyright (C) 2001, 2002 Edward O'Connor <ted@oconnor.cx>

;; Maintainer: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; If you use the BBDB, you can add "livejournal" fields to
;; associate LJ user names with people. Hitting `j' in the BBDB
;; window will pull up that person's LJ in your browser of choice
;; by abuse of the `browse-url' package.

;;; Code:

(require 'bbdb)

(require 'lj-url)

;;; Error definitions.

(lj--deferror lj-bbdb-error (lj-error)
  "An unspecified BBDB error has occured")

(lj--deferror lj-bbdb-no-record-error (lj-bbdb-error lj-error)
  "Record unexists")

(lj--deferror lj-bbdb-no-journal-error (lj-bbdb-error lj-error)
  "Current record unhas a livejournal")

(defun lj-bbdb-browse-journal (bbdb-record)
  "Open the LiveJournal of the person indicated by BBDB-RECORD."
  (interactive (list (bbdb-current-record)))
  (let ((livejournal-bbdb-record-cons
         (assoc 'livejournal (bbdb-record-raw-notes bbdb-record))))
    (cond ((null bbdb-record) (signal 'lj-bbdb-no-record-error nil))
          ((null livejournal-bbdb-record-cons)
           (signal 'lj-bbdb-no-journal-error nil))
          ;; OK, the record exists and has a livejournal entry, so
          ;; let's load up the journal.
          (t (browse-url
              (lj-url-system-username-entries
               'livejournal (cdr livejournal-bbdb-record-cons)))))))

(define-key bbdb-mode-map "j" 'lj-bbdb-browse-journal)

(provide 'lj-bbdb)
;;; lj-bbdb.el ends here
