;;; lj-bug.el --- ljupdate bug reporting

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; 

;;; Code:

(require 'ljcompat)

(defconst lj-bug-report-email-address
  "ljupdate-bug@mail.freesoftware.fsf.org"
  "Address to which to send ljupdate bugs.")

;;;###autoload
(defun lj-report-bug (subject)
  "Report a bug in ljupdate, with SUBJECT."
  (interactive "sBug report subject: ")
  (compose-mail lj-bug-report-email-address subject)
  (goto-char (ljc-mail-header-end))
  (forward-line 1)
  (insert
   "Please write in English.\n"
   "\n"
   "Your bug report will be posted to the ljupdate-bug mailing list:\n"
   "\t" lj-bug-report-email-address "\n"
   "\n"
   "In " (emacs-version) "\n"
   "ljupdate: " lj--client-version "\n"
   "\n"
   "Please describe exactly what actions triggered the bug\n"
   "and the precise symptoms of the bug:\n\n")
  ;; This is so the user has to type something in order to send
  ;; easily.
  (let ((map (make-sparse-keymap)))
    (set-keymap-parent map (current-local-map))
    (use-local-map map))
  nil)

(provide 'lj-bug)
;;; lj-bug.el ends here
