;;; lj-menu.el --- menu bar coolness for ljupdate

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; 

;;; Code:

(require 'easymenu)

(require 'lj-write)

(defcustom lj-use-menu-bar-flag t
  "*When non-nil, ljupdate will create a k-rad menu in your menu bar."
  :type 'boolean
  :group 'ljupdate)

(defvar lj-menu-definition
  '("LiveJournal"
    ["Login..." lj-profile-login t]
    ["Compose an update..." lj-compose t]
    "-"
    ["Insert LJ User..." lj-insert-lj-user lj-composition]
    "-"
    ["Post this update" lj-post lj-composition]
    ["Post this update and exit" lj-post-and-exit lj-composition])
  "LiveJournal menu definition.")

(easy-menu-define lj-menu lj-update-mode-map "LiveJournal" lj-menu-definition)
(easy-menu-add lj-menu lj-update-mode-map)

(provide 'lj-menu)
;;; lj-menu.el ends here
