;;; lj-music.el --- now playing support for ljupdate

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; 

;;; Code:

(defcustom lj-music-function 'lj-get-music-from-external-program
  "*A function which returns a string describing your current music."
  :type '(choice (const :tag "Use `lj-music-external-program'" 'lj-get-music-from-external-program)
                 function)
  :group 'ljupdate)

(defcustom lj-music-external-program
  (if (eq system-type 'windows-nt)
      "askwinamp.exe"
    "xmmscurrent.sh")
  "*External program that should be used to get your current music.
This will only be used when `lj-music-function' hasn't been
changed from its default setting."
  :type 'string
  :group 'ljupdate)

(defun lj-get-music-from-external-program ()
  "Try to figure out what your current music is.

In order for this to work, you need to download either
askwinamp.exe (for Win32) or xmmscurrent.sh (for Unix), and put it
in your PATH somewhere."
  (condition-case nil
      (let ((track
             (shell-command-to-string lj-music-external-program)))
        (if (string-match "not.\\(found\\|recognized\\)" track)
            nil
          (substring track 0 (1- (length track)))))
    (error nil)))

;;;###autoload
(defun lj--get-music ()
  "Use `lj-music-function' to return the user's current music."
  (or (funcall lj-music-function)
      ""))

(provide 'lj-music)
;;; lj-music.el ends here
