;;; lj-shell.el --- eshell coolness for ljupdate

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; 

;;; Code:

(require 'esh-opt)

(require 'lj-url)

;;;###autoload
(defun eshell/lj (&rest args)
  "Eshell command interface to ljupdate."
  (eshell-eval-using-options
   "lj" args
   '(
     (?c "compose" nil compose "compose update")
     (?f "friends" nil friends "read friends list")
     (?h "help" nil nil "show this usage information")
     (?i "info" nil info "read your user info")
     (?j "journal" nil journal "read your journal")
     (?l "login" nil login "log in")
     (?p "profile" t profile "perform action using this profile")
     :usage "[-p PROFILE] ACTION
  Perform some ACTION using ljupdate profile PROFILE."
     :show-usage)
   (eshell-do-eval
    (let* ((profile (or (intern-soft profile)
                        lj--current-profile
                        lj-default-profile))
           (system (lj-profile-system profile)))

      (eshell-parse-command
       (cond
        (compose ;; These uses of `quote' are ugly.
         (format "lj-compose (quote %s)" profile))
        (login
         (format "lj-profile-login (quote %s)" profile))
        (friends
         (format "browse-url %s" (lj-url-profile-friends profile)))
        (info
         (format "browse-url %s" (lj-url-profile-userinfo profile)))
        (journal
         (format "browse-url %s" (lj-url-profile-entries profile))))))
    t)))

(provide 'lj-shell)
;;; lj-shell.el ends here
