;;; lj-utils.el --- general purpose utilities used in ljupdate

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; 

;;; Code:

(require 'ljcompat)

(defcustom lj-message-level 4
  "Verbosity level for ljupdate.

This should be a number from 0 to 9 inclusive. Larger numbers mean
more verbosity. Generally speaking, errors will be reported at
level 1. Normal user messages are level 2, while debugging
messages are level 6. Very large debugging messages are level 9.

So if you never want to hear anything at all (this is not a good
idea), set this to 0. The default of 4 is the recommended value."
  :type 'integer
  :group 'ljupdate)

;;;###autoload
(defun lj--message (level &rest args)
  "Inspired by `gnus-message', which see."
  (when (<= level lj-message-level)
    (message "LJ[%s]: %s" level (apply 'format args))))

;;;###autoload
(defmacro lj--deferror (name parents message)
  "Define an error named NAME with parents PARENTS and message MESSAGE."
  `(progn
     (put ',name 'error-conditions '(,name ,@parents error))
     (put ',name 'error-message ,message)
     ',name))

(put 'lj--deferror 'lisp-indent-function 2)

(lj--deferror lj-error ()
  "An unspecified ljupdate error has occured")

(provide 'lj-utils)
;;; lj-utils.el ends here
