;;; ljcompat.el --- Cross-Emacsen compatibility routines

;; Copyright (C) 2002  Edward O'Connor <ted@oconnor.cx>

;; Portions from GNU Emacs 21.2's subr.el, which is
;; Copyright (C) 1985, 86, 92, 94, 95, 99, 2000, 2001
;;   Free Software Foundation, Inc.

;; Portions from GNU Emacs 21.2's sendmail.el, which is
;; Copyright (C) 1985, 86, 92, 93, 94, 95, 96, 98, 2000, 2001
;;   Free Software Foundation, Inc.

;; Author: Edward O'Connor <ted@oconnor.cx>
;; Keywords: convenience

;; This file is part of ljupdate.

;; ljupdate is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; {at your option} any later version.

;; ljupdate is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public
;; License along with ljupdate, or with your Emacs. See the file
;; COPYING, or, if you're using GNU Emacs, try typing C-h C-c to
;; bring it up. If you're using XEmacs, C-h C-l does this. If you
;; do not have a copy, you can obtain one by writing to the Free
;; Software Foundation at this address:

;;                Free Software Foundation, Inc.
;;                59 Temple Place, Suite 330
;;                Boston, MA  02111-1307
;;                USA

;;; Commentary:

;; Note that not all compatibility issues can be resolved in this
;; file. Consider keymaps and stuff.

;;; Code:

;; Note how annoying these calls to `sit-for' are. This is
;; intentional.

(condition-case nil
    (require 'md5)
  ;; Note that we don't use lj--message because it hasn't been defined yet.
  (error (message "%s %s" "MD5 library not installed."
                  "This makes ljupdate very insecure!")
         (sit-for 3)
         (message "md5.el: http://www.gentei.org/~yuuji/software/md5.el")
         (sit-for 3)))

(defconst lj--use-md5-p (fboundp 'md5)
  "Whether or not to use md5.")

(defconst lj--password-argname
  (concat "&" (if lj--use-md5-p "h" "") "password="))

;;; Functions to replace by redefinition of the standard name.

(unless (fboundp 'identity)
  (defun identity (arg)
    "Return ARG."
    arg))

(unless (fboundp 'mapc)
  (defun mapc (function list)
    "Map FUNCTION over LIST, returning the orignial list."
    (mapcar function list)
    list))

(unless (fboundp 'read-passwd)
  (condition-case nil
      (require 'passwd)
    (error
     (message "Warning! Password reading will echo your password.")
     (defalias 'read-passwd 'read-string))))

;;; Functions to wrap around.

(if (fboundp 'md5)
    (defalias 'ljc-md5 'md5)
  (defalias 'ljc-md5 'identity))

(if (fboundp 'char-int)
    (defalias 'ljc-char-int 'char-int)
  (defalias 'ljc-char-int 'identity))

(if (fboundp 'char-to-int)
    (defalias 'ljc-char-to-int 'char-to-int)
  (defalias 'ljc-char-to-int 'identity))

(if (fboundp 'string-as-unibyte)
    (defalias 'ljc-string-as-unibyte 'string-as-unibyte)
  (defalias 'ljc-string-as-unibyte 'identity))

(if (fboundp 'rfc822-goto-eoh)
    (defalias 'ljc-rfc822-goto-eoh 'rfc822-goto-eoh)
  ;; From GNU Emacs 21.2's simple.el.
  (defun ljc-rfc822-goto-eoh ()
    ;; Go to header delimiter line in a mail message, following RFC822 rules
    (goto-char (point-min))
    (while (looking-at "^[^: \n]+:\\|^[ \t]")
      (forward-line 1))
    (point)))

(if (fboundp 'mail-header-end)
    (defalias 'ljc-mail-header-end 'mail-header-end)
  ;; From GNU Emacs 21.2's sendmail.el.
  (defun ljc-mail-header-end ()
    "Return the buffer location of the end of headers, as a number."
    (save-restriction
      (widen)
      (save-excursion
        (ljc-rfc822-goto-eoh)
        (point)))))

(if (fboundp 'mail-sendmail-undelimit-header)
    (defalias 'ljc-mail-sendmail-undelimit-header
      'mail-sendmail-undelimit-header)
  ;; From GNU Emacs 21.2's sendmail.el.
  (defun ljc-mail-sendmail-undelimit-header ()
    "Remove header separator to put the message in correct form for sendmail.
Leave point at the start of the delimiter line."
    (ljc-rfc822-goto-eoh)
    (delete-region (point) (progn (end-of-line) (point)))))

(provide 'ljcompat)
;;; ljcompat.el ends here
