/*
 * This file was generated automatically by xsubpp version 1.9505 from the 
 * contents of IO.xs. Do not edit this file, edit IO.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "IO.xs"
/*
  Copyright (c) 1995-1998 Nick Ing-Simmons. All rights reserved.
  This program is free software; you can redistribute it and/or
  modify it under the same terms as Perl itself.
*/

#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#include <fcntl.h>

#include "tkGlue.def"

#include "pTk/tkPort.h"
#include "pTk/tkInt.h"
#include "pTk/tkVMacro.h"
#include "tkGlue.h"
#include "tkGlue.m"

#define InputStream PerlIO *
#define OutputStream PerlIO *

DECLARE_VTABLES;

typedef struct
 {
  PerlIO *f;
  SV *buf;
  int len;
  int offset;
  int count;
  int error;
  int eof; 
 } nIO_read;

static void CallbackHandler _((ClientData clientData, int mask));

static void read_handler _((ClientData clientData, int mask));
static void
read_handler(clientData, mask)
ClientData clientData;
int mask;
{
 if (mask & TCL_READABLE)
  {
   nIO_read *info = (nIO_read *) clientData;
   SV *buf = info->buf;
   int count;
   SvGROW(buf,info->offset+info->len+1);
   count = read(PerlIO_fileno(info->f),SvPVX(buf)+info->offset,(size_t) info->len);
   if (count == 0)
    {
     info->eof = 1;
    }
   else if (count == -1)
    {
     perror("read_handler");
     if (errno == EAGAIN)
      {
       PerlIO_printf(PerlIO_stderr(),"%d would block\n",PerlIO_fileno(info->f));
      }
     else
      info->error = errno;
    }
   else
    {STRLEN len;
     SvCUR_set(buf,SvCUR(buf)+count);
     info->len    -= count;
     info->count  += count;
     info->offset += count;
    }
   SvPVX(buf)[SvCUR(buf)] = '\0';
  }
}

static void
CallbackHandler(clientData, mask)
ClientData clientData;
int mask;
{
 dSP;
 SV *handle = (SV *) clientData;
 PUSHMARK(sp);
 XPUSHs(sv_2mortal(newRV(handle)));
 XPUSHs(sv_2mortal(newSViv(mask)));   
 PUTBACK;
 perl_call_method("IOready", G_DISCARD);
}

static int restore_mode _((PerlIO *f,int mode));
static int make_nonblock _((PerlIO *f,int *mode,int *newmode));

#ifdef __WIN32__
static int
make_nonblock(f,mode,newmode)
PerlIO *f;
int *mode;
int *newmode;
{
 croak("Cannot make nonblocking on Win32 yet");
 return -1;
}

static int
restore_mode(f,mode)
PerlIO *f;
int mode;
{
 croak("Cannot make nonblocking on Win32 yet");
 return -1;
}
#else
static int 
make_nonblock(f,mode,newmode)
PerlIO *f;
int *mode;
int *newmode;
{
 int RETVAL = fcntl(PerlIO_fileno(f), F_GETFL, 0);
 if (RETVAL >= 0)
  {
   *newmode = *mode = RETVAL;
#ifdef O_NONBLOCK
   /* POSIX style */ 
#ifdef O_NDELAY
   /* Ooops has O_NDELAY too - make sure we don't 
    * get SysV behaviour by mistake
    */
   if ((*mode & O_NDELAY) || !(*mode & O_NONBLOCK))
    {
     *newmode = (*mode & ~O_NDELAY) | O_NONBLOCK;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#else
   /* Standard POSIX */ 
   if (!(*mode & O_NONBLOCK))
    {
     *newmode = *mode | O_NONBLOCK;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#endif 
#else
   /* Not POSIX - better have O_NDELAY or we can't cope.
    * for BSD-ish machines this is an acceptable alternative
    * for SysV we can't tell "would block" from EOF but that is 
    * the way SysV is...
    */
   if (!(*mode & O_NDELAY))
    {
     *newmode = *mode | O_NDELAY;
     RETVAL = fcntl(PerlIO_fileno(f),F_SETFL,*newmode);
    }
#endif
  }
 return RETVAL;
}

static int
restore_mode(f,mode)
PerlIO *f;
int mode;
{
 return fcntl(PerlIO_fileno(f), F_SETFL, mode);
}

#endif

static int has_nl _((SV *sv));

static int has_nl(sv)
SV *sv;
{
 STRLEN n = SvCUR(sv);
 char *p = SvPVX(sv);
 while (n-- > 0)
  {
   if (*p++ == '\n')
    return 1; 
  }
 return 0;
}

#define Const_READABLE() TCL_READABLE
#define Const_WRITABLE() TCL_WRITABLE
#define Const_EXCEPTION() TCL_EXCEPTION

XS(XS_Tk__IO_READABLE)
{
    dXSARGS;
    if (items != 0)
	croak("Usage: Tk::IO::READABLE()");
    {
	int	RETVAL;

	RETVAL = Const_READABLE();
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_WRITABLE)
{
    dXSARGS;
    if (items != 0)
	croak("Usage: Tk::IO::WRITABLE()");
    {
	int	RETVAL;

	RETVAL = Const_WRITABLE();
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_EXCEPTION)
{
    dXSARGS;
    if (items != 0)
	croak("Usage: Tk::IO::EXCEPTION()");
    {
	int	RETVAL;

	RETVAL = Const_EXCEPTION();
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_CreateFileHandler)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: Tk::IO::CreateFileHandler(fd,mode,obj)");
    {
	int	fd = (int)SvIV(ST(0));
	int	mode = (int)SvIV(ST(1));
	SV *	obj = ST(2);
#line 211 "IO.xs"
 {
  Tcl_CreateFileHandler(fd, mode, CallbackHandler , (ClientData) SvRV(obj));
 }
#line 255 "IO.c"
    }
    XSRETURN_EMPTY;
}

XS(XS_Tk__IO_DeleteFileHandler)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: Tk::IO::DeleteFileHandler(fd)");
    {
	int	fd = (int)SvIV(ST(0));

	Tcl_DeleteFileHandler(fd);
    }
    XSRETURN_EMPTY;
}

XS(XS_Tk__IO_make_nonblock)
{
    dXSARGS;
    if (items != 3)
	croak("Usage: Tk::IO::make_nonblock(f,mode,newmode)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	int	mode;
	int	newmode;
	int	RETVAL;

	RETVAL = make_nonblock(f, &mode, &newmode);
	sv_setiv(ST(1), (IV)mode);
	sv_setiv(ST(2), (IV)newmode);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_restore_mode)
{
    dXSARGS;
    if (items != 2)
	croak("Usage: Tk::IO::restore_mode(f,mode)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	int	mode = (int)SvIV(ST(1));
	int	RETVAL;

	RETVAL = restore_mode(f, mode);
	ST(0) = sv_newmortal();
	sv_setiv(ST(0), (IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_read)
{
    dXSARGS;
    if (items < 3 || items > 4)
	croak("Usage: Tk::IO::read(f,buf,len,offset = 0)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	SV *	buf = ST(1);
	int	len = (int)SvIV(ST(2));
	int	offset;
	SV *	RETVAL;

	if (items < 4)
	    offset = 0;
	else {
	    offset = (int)SvIV(ST(3));
	}
#line 244 "IO.xs"
  {
   int mode;
   int newmode;
   int count = make_nonblock(f,&mode,&newmode);
   /* Copy stuff out of PerlIO *  */
   ST(0) = &sv_undef;
   if (count == 0)
    {
     int fd = PerlIO_fileno(f);
     nIO_read info;   
     info.f   = f;    
     info.buf = buf;  
     info.len = len;  
     info.offset = offset;
     info.count  = 0; 
     info.error  = 0; 
     info.eof    = 0; 
     if (!SvUPGRADE(buf, SVt_PV))
      {
       RETVAL = &sv_undef;
       return;
      }
     SvPOK_only(buf);		/* validate pointer */
     Tcl_CreateFileHandler(fd, TCL_READABLE, read_handler, (ClientData) &info);
     do                                        
      {                                        
       Tcl_DoOneEvent(0);                       
      } while (!info.eof && !info.error && info.count == 0);
     Tcl_DeleteFileHandler(fd);
     if (mode != newmode)
      {
       count = restore_mode(f,mode);
       if (count != 0)
        croak("Cannot make blocking");
      }
     if (!info.eof && !info.error)
      {
       ST(0) = sv_2mortal(newSViv(info.count));
      }
    }
   else
    croak("Cannot make non-blocking");
  }
#line 371 "IO.c"
    }
    XSRETURN(1);
}

XS(XS_Tk__IO_readline)
{
    dXSARGS;
    if (items != 1)
	croak("Usage: Tk::IO::readline(f)");
    {
	InputStream	f = IoIFP(sv_2io(ST(0)));
	SV *	RETVAL;
#line 292 "IO.xs"
  {
   int mode;
   int newmode;
   int count = make_nonblock(f,&mode,&newmode);
   /* Copy stuff out of PerlIO *  */
   ST(0) = &sv_undef;
   if (count == 0)
    {
     SV *buf =  newSVpv("",0);
     int fd = PerlIO_fileno(f);
     nIO_read info;   
     info.f   = f;    
     info.buf = buf;  
     info.len = 1;  
     info.offset = 0;
     info.count  = 0; 
     info.error  = 0; 
     info.eof    = 0; 
     Tcl_CreateFileHandler(fd, TCL_READABLE, read_handler, (ClientData) &info);
     while (!info.eof && !info.error && !has_nl(buf))
      {                                        
       info.len = 1;
       info.count = 0;
       while (!info.eof && !info.error && !info.count)
        Tcl_DoOneEvent(0);                       
      } 
     Tcl_DeleteFileHandler(fd);
     if (mode != newmode)
      {
       count = restore_mode(f,mode);
       if (count != 0)
        croak("Cannot make blocking");
      }
     if (!info.eof && !info.error)
      {
       sv_setiv(buf,1);
       SvPOK_on(buf);
       ST(0) = sv_2mortal(buf);
      }
     else if (info.error)
      {
       warn("error=%d",info.error);
      }
    }
   else
    {
     croak("Cannot make non-blocking");
    }
  }
#line 434 "IO.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Tk__IO)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("Tk::IO::READABLE", XS_Tk__IO_READABLE, file);
        newXS("Tk::IO::WRITABLE", XS_Tk__IO_WRITABLE, file);
        newXS("Tk::IO::EXCEPTION", XS_Tk__IO_EXCEPTION, file);
        newXS("Tk::IO::CreateFileHandler", XS_Tk__IO_CreateFileHandler, file);
        newXS("Tk::IO::DeleteFileHandler", XS_Tk__IO_DeleteFileHandler, file);
        newXSproto("Tk::IO::make_nonblock", XS_Tk__IO_make_nonblock, file, "$$$");
        newXSproto("Tk::IO::restore_mode", XS_Tk__IO_restore_mode, file, "$$");
        newXSproto("Tk::IO::read", XS_Tk__IO_read, file, "$$$;$");
        newXSproto("Tk::IO::readline", XS_Tk__IO_readline, file, "$");

    /* Initialisation Section */

#line 345 "IO.xs"
 {
  IMPORT_VTABLES;
 }

#line 466 "IO.c"

    /* End of Initialisation Section */

    ST(0) = &sv_yes;
    XSRETURN(1);
}
