/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.analytics;

public class Transaction {
    private final String orderId;
    private final String storeName;
    private final double totalCost;
    private final double totalTax;
    private final double shippingCost;

    private Transaction(Builder builder) {
        this.orderId = builder.orderId;
        this.totalCost = builder.totalCost;
        this.storeName = builder.storeName;
        this.totalTax = builder.totalTax;
        this.shippingCost = builder.shippingCost;
    }

    String getOrderId() {
        return this.orderId;
    }

    String getStoreName() {
        return this.storeName;
    }

    double getTotalCost() {
        return this.totalCost;
    }

    double getTotalTax() {
        return this.totalTax;
    }

    double getShippingCost() {
        return this.shippingCost;
    }

    public static class Builder {
        private final String orderId;
        private String storeName = null;
        private final double totalCost;
        private double totalTax = 0.0;
        private double shippingCost = 0.0;

        public Builder(String string, double d) {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("orderId must not be empty or null");
            }
            this.orderId = string;
            this.totalCost = d;
        }

        public Builder setStoreName(String string) {
            this.storeName = string;
            return this;
        }

        public Builder setTotalTax(double d) {
            this.totalTax = d;
            return this;
        }

        public Builder setShippingCost(double d) {
            this.shippingCost = d;
            return this;
        }

        public Transaction build() {
            return new Transaction(this);
        }
    }
}

