/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.Context;
import com.google.analytics.tracking.android.AdHitIdGenerator;
import com.google.analytics.tracking.android.AnalyticsThread;
import com.google.analytics.tracking.android.GAThread;
import com.google.analytics.tracking.android.GAUsage;
import com.google.analytics.tracking.android.Log;
import com.google.analytics.tracking.android.Tracker;
import com.google.analytics.tracking.android.TrackerHandler;
import com.google.analytics.tracking.android.Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GoogleAnalytics
implements TrackerHandler {
    private boolean mDebug;
    private AnalyticsThread mThread;
    private Context mContext;
    private Tracker mDefaultTracker;
    private AdHitIdGenerator mAdHitIdGenerator;
    private volatile String mClientId;
    private volatile Boolean mAppOptOut;
    private final Map<String, Tracker> mTrackers = new HashMap<String, Tracker>();
    private String mLastTrackingId;
    private static GoogleAnalytics sInstance;

    @VisibleForTesting
    GoogleAnalytics() {
    }

    private GoogleAnalytics(Context context) {
        this(context, GAThread.getInstance(context));
    }

    private GoogleAnalytics(Context context, AnalyticsThread thread) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.mThread = thread;
        this.mAdHitIdGenerator = new AdHitIdGenerator();
        this.mThread.requestAppOptOut(new AppOptOutCallback(){

            @Override
            public void reportAppOptOut(boolean optOut) {
                GoogleAnalytics.this.mAppOptOut = optOut;
            }
        });
        this.mThread.requestClientId(new AnalyticsThread.ClientIdCallback(){

            @Override
            public void reportClientId(String clientId) {
                GoogleAnalytics.this.mClientId = clientId;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleAnalytics getInstance(Context context) {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (sInstance == null) {
                sInstance = new GoogleAnalytics(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GoogleAnalytics getInstance() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static GoogleAnalytics getNewInstance(Context context, AnalyticsThread thread) {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (sInstance != null) {
                sInstance.close();
            }
            sInstance = new GoogleAnalytics(context, thread);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstance() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            sInstance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDebug(boolean debug) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_DEBUG);
        this.mDebug = debug;
        Log.setDebug(debug);
    }

    public boolean isDebugEnabled() {
        GAUsage.getInstance().setUsage(GAUsage.Field.GET_DEBUG);
        return this.mDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker getTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            if (trackingId == null) {
                throw new IllegalArgumentException("trackingId cannot be null");
            }
            Tracker tracker = this.mTrackers.get(trackingId);
            if (tracker == null) {
                tracker = new Tracker(trackingId, this);
                this.mTrackers.put(trackingId, tracker);
                if (this.mDefaultTracker == null) {
                    this.mDefaultTracker = tracker;
                }
            }
            GAUsage.getInstance().setUsage(GAUsage.Field.GET_TRACKER);
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker getDefaultTracker() {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            GAUsage.getInstance().setUsage(GAUsage.Field.GET_DEFAULT_TRACKER);
            return this.mDefaultTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTracker(Tracker tracker) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            GAUsage.getInstance().setUsage(GAUsage.Field.SET_DEFAULT_TRACKER);
            this.mDefaultTracker = tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTracker(Tracker tracker) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            this.mTrackers.values().remove(tracker);
            if (tracker == this.mDefaultTracker) {
                this.mDefaultTracker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendHit(Map<String, String> hit) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            if (hit == null) {
                throw new IllegalArgumentException("hit cannot be null");
            }
            hit.put("language", Utils.getLanguage(Locale.getDefault()));
            hit.put("adSenseAdMobHitId", Integer.toString(this.mAdHitIdGenerator.getAdHitId()));
            hit.put("screenResolution", this.mContext.getResources().getDisplayMetrics().widthPixels + "x" + this.mContext.getResources().getDisplayMetrics().heightPixels);
            hit.put("usage", GAUsage.getInstance().getAndClearSequence());
            GAUsage.getInstance().getAndClearUsage();
            this.mThread.sendHit(hit);
            this.mLastTrackingId = hit.get("trackingId");
        }
    }

    @VisibleForTesting
    void close() {
    }

    String getTrackingIdForAds() {
        return this.mLastTrackingId;
    }

    String getClientIdForAds() {
        if (this.mClientId == null) {
            return null;
        }
        return this.mClientId.toString();
    }

    public void setAppOptOut(boolean optOut) {
        GAUsage.getInstance().setUsage(GAUsage.Field.SET_APP_OPT_OUT);
        this.mAppOptOut = optOut;
        this.mThread.setAppOptOut(optOut);
    }

    @VisibleForTesting
    Boolean getAppOptOut() {
        return this.mAppOptOut;
    }

    public void requestAppOptOut(AppOptOutCallback callback) {
        GAUsage.getInstance().setUsage(GAUsage.Field.REQUEST_APP_OPT_OUT);
        if (this.mAppOptOut != null) {
            callback.reportAppOptOut(this.mAppOptOut);
        } else {
            this.mThread.requestAppOptOut(callback);
        }
    }

    public static interface AppOptOutCallback {
        public void reportAppOptOut(boolean var1);
    }
}

