/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import com.google.android.gms.common.util.VisibleForTesting;

public class Log {
    @VisibleForTesting
    static final String LOG_TAG = "GAV2";
    private static boolean sDebug;

    private Log() {
    }

    public static void setDebug(boolean debug) {
        sDebug = debug;
    }

    public static boolean isDebugEnabled() {
        return sDebug;
    }

    public static int d(String msg) {
        return android.util.Log.d((String)LOG_TAG, (String)Log.formatMessage(msg));
    }

    public static int dDebug(String msg) {
        if (sDebug) {
            return Log.d(msg);
        }
        return 0;
    }

    public static int e(String msg) {
        return android.util.Log.e((String)LOG_TAG, (String)Log.formatMessage(msg));
    }

    public static int eDebug(String msg) {
        if (sDebug) {
            return Log.e(msg);
        }
        return 0;
    }

    public static int i(String msg) {
        return android.util.Log.i((String)LOG_TAG, (String)Log.formatMessage(msg));
    }

    public static int iDebug(String msg) {
        if (sDebug) {
            return Log.i(msg);
        }
        return 0;
    }

    public static int v(String msg) {
        return android.util.Log.v((String)LOG_TAG, (String)Log.formatMessage(msg));
    }

    public static int vDebug(String msg) {
        if (sDebug) {
            return Log.v(msg);
        }
        return 0;
    }

    public static int w(String msg) {
        return android.util.Log.w((String)LOG_TAG, (String)Log.formatMessage(msg));
    }

    public static int wDebug(String msg) {
        if (sDebug) {
            return Log.w(msg);
        }
        return 0;
    }

    private static String formatMessage(String msg) {
        return Thread.currentThread().toString() + ": " + msg;
    }
}

