/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import android.content.Context;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import org.openqa.selenium.android.AndroidWebDriver;
import org.openqa.selenium.android.ChromeClient;
import org.openqa.selenium.android.JavascriptExecutor;
import org.openqa.selenium.android.JavascriptInterface;
import org.openqa.selenium.android.ViewClient;

class WebDriverWebView {
    private static JavascriptInterface jsInterface = new JavascriptInterface(new JavascriptExecutor());

    public static WebView create(final AndroidWebDriver driver) {
        ChromeClient chromeClient = new ChromeClient(driver);
        ViewClient viewClient = new ViewClient(driver);
        WebView view = new WebView((Context)driver.getActivity());
        view.setWebChromeClient((WebChromeClient)chromeClient);
        view.setWebViewClient((WebViewClient)viewClient);
        view.getScale();
        view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focused) {
                if (!focused) {
                    driver.setEditAreaHasFocus(true);
                }
            }
        });
        view.addJavascriptInterface((Object)jsInterface, "webdriver");
        WebDriverWebView.initWebViewSettings(view);
        return view;
    }

    private WebDriverWebView() {
    }

    private static void initWebViewSettings(WebView view) {
        view.clearCache(true);
        view.clearFormData();
        view.clearHistory();
        view.clearView();
        view.requestFocus(130);
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        WebSettings settings = view.getSettings();
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportMultipleWindows(true);
        settings.setBuiltInZoomControls(true);
        settings.setJavaScriptEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setSaveFormData(true);
        settings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        settings.setLoadWithOverviewMode(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setDefaultZoom(WebSettings.ZoomDensity.valueOf((String)"MEDIUM"));
        settings.setUseWideViewPort(true);
        settings.setMinimumFontSize(1);
        settings.setMinimumLogicalFontSize(1);
        settings.setDefaultFontSize(16);
        settings.setDefaultFixedFontSize(13);
        WebView.enablePlatformNotifications();
        view.setNetworkAvailable(true);
    }
}

