/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android;

import android.app.Activity;
import android.webkit.WebView;
import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.android.JavascriptExecutor;
import org.openqa.selenium.android.JavascriptResultNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebViewManager
implements JavascriptResultNotifier {
    private static HashBiMap<String, WebView> map = HashBiMap.create();
    private volatile boolean done;
    private volatile String result;
    private Object syncObject = new Object();
    private Activity activity;

    WebViewManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebView getView(String nameOrHandle) {
        Object object = this.syncObject;
        synchronized (object) {
            WebView toReturn = this.searchForViewByHandle(nameOrHandle);
            return toReturn == null ? this.searchForViewByWindowName(nameOrHandle) : toReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addView(WebView view) {
        Object object = this.syncObject;
        synchronized (object) {
            String u = UUID.randomUUID().toString();
            map.put((Object)u, (Object)view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebView getNextView() {
        Object object = this.syncObject;
        synchronized (object) {
            String key = (String)map.keySet().iterator().next();
            return (WebView)map.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(String nameOrHandle) {
        Object object = this.syncObject;
        synchronized (object) {
            WebView toRemove = this.searchForViewByHandle(nameOrHandle);
            toRemove = toRemove != null ? toRemove : this.searchForViewByWindowName(nameOrHandle);
            this.removeView(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeView(WebView view) {
        Object object = this.syncObject;
        synchronized (object) {
            map.inverse().remove((Object)view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllHandles() {
        Object object = this.syncObject;
        synchronized (object) {
            return map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebView searchForViewByHandle(String handle) {
        Object object = this.syncObject;
        synchronized (object) {
            return (WebView)map.get((Object)handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebView searchForViewByWindowName(String windowName) {
        Object object = this.syncObject;
        synchronized (object) {
            for (WebView view : map.inverse().keySet()) {
                this.done = false;
                JavascriptExecutor.executeJs(view, this, "window.webdriver.resultMethod(window.name);");
                long timeout = System.currentTimeMillis() + 10000L;
                while (!this.done && System.currentTimeMillis() < timeout) {
                    try {
                        this.syncObject.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        throw new WebDriverException(e);
                    }
                }
                if (this.result == null || !this.result.equals(windowName)) continue;
                return view;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWindowHandle(WebView view) {
        Object object = this.syncObject;
        synchronized (object) {
            return (String)map.inverse().get((Object)view);
        }
    }

    public void closeAll() {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            ((WebView)map.get((Object)s)).removeAllViews();
            ((WebView)map.get((Object)s)).destroy();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyResultReady(String result) {
        Object object = this.syncObject;
        synchronized (object) {
            this.result = result;
            this.done = true;
            this.syncObject.notify();
        }
    }
}

