/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BuildInfo {
    private static final Properties BUILD_PROPERTIES = BuildInfo.loadBuildProperties();

    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        Manifest manifest = null;
        try {
            URL url = BuildInfo.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(url.toURI());
            JarFile jar = new JarFile(file);
            manifest = jar.getManifest();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (manifest == null) {
            return properties;
        }
        try {
            Attributes attributes = manifest.getAttributes("Build-Info");
            Set<Map.Entry<Object, Object>> entries = attributes.entrySet();
            for (Map.Entry<Object, Object> e : entries) {
                properties.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
        catch (NullPointerException nullPointerException) {}
        return properties;
    }

    public String getReleaseLabel() {
        return BUILD_PROPERTIES.getProperty("Selenium-Version", "unknown");
    }

    public String getBuildRevision() {
        return BUILD_PROPERTIES.getProperty("Selenium-Revision", "unknown");
    }

    public String getBuildTime() {
        return BUILD_PROPERTIES.getProperty("Selenium-Build-Time", "unknown");
    }

    public String toString() {
        return String.format("Build info: version: '%s', revision: '%s', time: '%s'", this.getReleaseLabel(), this.getBuildRevision(), this.getBuildTime());
    }
}

