/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    private static final Method JDK6_CAN_EXECUTE = CommandLine.findJdk6CanExecuteMethod();
    private final String[] commandAndArgs;
    private volatile StreamDrainer drainer;
    private volatile OutputStream drainTo;
    private volatile Thread drainerThread;
    private volatile int exitCode;
    private volatile boolean executed;
    private volatile Process proc;
    private volatile String allInput;
    private Map<String, String> env = new ConcurrentHashMap<String, String>();
    private Thread cleanup;

    public CommandLine(String executable, String ... args) {
        this.commandAndArgs = new String[args.length + 1];
        this.commandAndArgs[0] = CommandLine.findExecutable(executable);
        int index = 1;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.commandAndArgs[index++] = arg;
            ++n2;
        }
    }

    public CommandLine(String[] cmdarray) {
        this.commandAndArgs = cmdarray;
    }

    Map<String, String> getEnvironment() {
        return new HashMap<String, String>(this.env);
    }

    public void setEnvironmentVariables(Map<String, String> environment) {
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            this.setEnvironmentVariable(entry.getKey(), entry.getValue());
        }
    }

    public void setEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot have a null environment variable name!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot have a null value for environment variable " + name);
        }
        this.env.put(name, value);
    }

    public void setDynamicLibraryPath(String newLibraryPath) {
        if (newLibraryPath != null) {
            this.setEnvironmentVariable(CommandLine.getLibraryPathPropertyName(), newLibraryPath);
        }
    }

    public static String getLibraryPathPropertyName() {
        switch (Platform.getCurrent()) {
            case MAC: {
                return "DYLD_LIBRARY_PATH";
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                return "PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    public static String findExecutable(String named) {
        File file = new File(named);
        if (CommandLine.canExecute(file)) {
            return named;
        }
        Map<String, String> env = System.getenv();
        String pathName = "PATH";
        if (!env.containsKey("PATH")) {
            for (String key : env.keySet()) {
                if (!"path".equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        String path = env.get(pathName);
        String[] endings = new String[]{""};
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            endings = new String[]{"", ".exe", ".com", ".bat"};
        }
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            String[] stringArray2 = endings;
            int n3 = endings.length;
            int n4 = 0;
            while (n4 < n3) {
                String ending = stringArray2[n4];
                file = new File(segment, String.valueOf(named) + ending);
                if (CommandLine.canExecute(file)) {
                    return file.getAbsolutePath();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void execute() {
        this.createProcess();
        this.setupDrainer();
        this.waitFor();
    }

    public Process executeAsync() {
        this.createProcess();
        new Thread(){

            public void run() {
                CommandLine.this.setupDrainer();
                CommandLine.this.waitFor();
            }
        }.start();
        this.cleanup = new Thread(){

            public void run() {
                if (CommandLine.this.proc != null) {
                    try {
                        CommandLine.this.proc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        CommandLine.this.proc.destroy();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.cleanup);
        return this.proc;
    }

    private void waitFor() {
        try {
            this.proc.waitFor();
            if (this.drainerThread != null) {
                this.drainerThread.join();
            }
            this.exitCode = this.proc.exitValue();
            this.postRunCleanup();
        }
        catch (InterruptedException e) {
            throw new WebDriverException(e);
        }
    }

    private void setupDrainer() {
        try {
            this.drainer = new StreamDrainer(this.proc, this.drainTo);
            this.drainerThread = new Thread((Runnable)this.drainer, "Command line drainer: " + this.commandAndArgs[0]);
            this.drainerThread.start();
            if (this.allInput != null) {
                byte[] bytes = this.allInput.getBytes();
                this.proc.getOutputStream().write(bytes);
                this.proc.getOutputStream().close();
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private void createProcess() {
        try {
            ProcessBuilder builder = new ProcessBuilder(this.commandAndArgs);
            builder.redirectErrorStream(true);
            builder.environment().putAll(this.env);
            this.proc = builder.start();
            this.executed = true;
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    public boolean isSuccessful() {
        return this.getExitCode() == 0;
    }

    public int getExitCode() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot get exit code before executing command line: " + this.commandAndArgs[0]);
        }
        return this.exitCode;
    }

    public String getStdOut() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot get output before executing command line: " + this.commandAndArgs[0]);
        }
        return this.drainer.getStdOut();
    }

    public void destroy() {
        if (!this.executed) {
            throw new IllegalStateException("Cannot quit a process that's not running: " + this.commandAndArgs[0]);
        }
        if (this.proc != null) {
            this.proc.destroy();
        }
        this.postRunCleanup();
    }

    private void postRunCleanup() {
        this.proc = null;
        if (this.cleanup != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.cleanup);
            }
            catch (IllegalStateException illegalStateException) {}
            this.cleanup = null;
        }
    }

    private static boolean canExecute(File file) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        if (JDK6_CAN_EXECUTE != null) {
            try {
                return (Boolean)JDK6_CAN_EXECUTE.invoke((Object)file, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return true;
    }

    private static Method findJdk6CanExecuteMethod() {
        try {
            return File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public void setInput(String allInput) {
        this.allInput = allInput;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String[] stringArray = this.commandAndArgs;
        int n = this.commandAndArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            buf.append(s).append(' ');
            ++n2;
        }
        return buf.toString();
    }

    public void copyOutputTo(OutputStream out) {
        this.drainTo = out;
    }

    private static class StreamDrainer
    implements Runnable {
        private final Process toWatch;
        private final ByteArrayOutputStream inputOut;
        private final OutputStream drainTo;

        StreamDrainer(Process toWatch, OutputStream drainTo) {
            this.toWatch = toWatch;
            this.drainTo = drainTo;
            this.inputOut = new ByteArrayOutputStream();
        }

        public void run() {
            block12: {
                BufferedInputStream inputStream = new BufferedInputStream(this.toWatch.getInputStream());
                byte[] buffer = new byte[2048];
                try {
                    try {
                        int read;
                        while ((read = ((InputStream)inputStream).read(buffer)) > 0) {
                            this.inputOut.write(buffer, 0, read);
                            this.inputOut.flush();
                            if (this.drainTo == null) continue;
                            this.drainTo.write(buffer, 0, read);
                            this.drainTo.flush();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.inputOut.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.inputOut.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    this.inputOut.close();
                }
                catch (IOException iOException) {}
            }
        }

        public String getStdOut() {
            return new String(this.inputOut.toByteArray());
        }
    }
}

