/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyDescriptor {
    private String name;
    private Method readMethod;
    private Method writeMethod;

    public SimplePropertyDescriptor() {
    }

    public SimplePropertyDescriptor(String name, Method readMethod, Method writeMethod) {
        this.name = name;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    public String getName() {
        return this.name;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public static SimplePropertyDescriptor[] getPropertyDescriptors(Class<? extends Object> clazz) {
        HashMap<String, SimplePropertyDescriptor> properties = new HashMap<String, SimplePropertyDescriptor>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName;
            Method m = methodArray[n2];
            String methodName = m.getName();
            if (methodName.length() > 2 && methodName.startsWith("is")) {
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(2));
                if (properties.containsKey(propertyName)) {
                    ((SimplePropertyDescriptor)properties.get((Object)propertyName)).readMethod = m;
                } else {
                    properties.put(propertyName, new SimplePropertyDescriptor(propertyName, m, null));
                }
            }
            if (methodName.length() > 3) {
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(3));
                if (methodName.startsWith("get") || methodName.startsWith("has")) {
                    if (properties.containsKey(propertyName)) {
                        ((SimplePropertyDescriptor)properties.get((Object)propertyName)).readMethod = m;
                    } else {
                        properties.put(propertyName, new SimplePropertyDescriptor(propertyName, m, null));
                    }
                }
                if (methodName.startsWith("set")) {
                    if (properties.containsKey(propertyName)) {
                        ((SimplePropertyDescriptor)properties.get((Object)propertyName)).writeMethod = m;
                    } else {
                        properties.put(propertyName, new SimplePropertyDescriptor(propertyName, null, m));
                    }
                }
            }
            ++n2;
        }
        SimplePropertyDescriptor[] pdsArray = new SimplePropertyDescriptor[properties.size()];
        return properties.values().toArray(pdsArray);
    }

    private static String uncapitalize(String s) {
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }
}

