/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.TypedValue;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class AssetManager {
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    public static final String TAG = "AssetManager";
    public static final boolean localLOGV = false;
    public static final boolean DEBUG_REFS = false;
    public static final Object sSync = new Object();
    public static AssetManager sSystem = null;
    public final TypedValue mValue = new TypedValue();
    public final long[] mOffsets = new long[2];
    public int mObject;
    public int mNObject;
    public StringBlock[] mStringBlocks = null;
    public int mNumRefs = 1;
    public boolean mOpen = true;
    public HashMap<Integer, RuntimeException> mRefStacks;
    public static final int STYLE_NUM_ENTRIES = 6;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetManager() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.init();
            AssetManager.ensureSystemAssets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager system = new AssetManager(true);
                system.makeStringBlocks(false);
                sSystem = system;
            }
        }
    }

    public AssetManager(boolean isSystem) {
        this.init();
    }

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getResourceText(int ident) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceValue(ident, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence getResourceBagText(int ident, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue tmpValue = this.mValue;
            int block = this.loadResourceBagValue(ident, bagEntryId, tmpValue, true);
            if (block >= 0) {
                if (tmpValue.type == 3) {
                    return this.mStringBlocks[block].get(tmpValue.data);
                }
                return tmpValue.coerceToString();
            }
        }
        return null;
    }

    public String[] getResourceStringArray(int id2) {
        String[] retArray = this.getArrayStringResource(id2);
        return retArray;
    }

    public boolean getResourceValue(int ident, TypedValue outValue, boolean resolveRefs) {
        int block = this.loadResourceValue(ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            outValue.string = this.mStringBlocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    public CharSequence[] getResourceTextArray(int id2) {
        int[] rawInfoArray = this.getArrayStringInfo(id2);
        int rawInfoArrayLen = rawInfoArray.length;
        int infoArrayLen = rawInfoArrayLen / 2;
        CharSequence[] retArray = new CharSequence[infoArrayLen];
        int i = 0;
        int j = 0;
        while (i < rawInfoArrayLen) {
            int block = rawInfoArray[i];
            int index = rawInfoArray[i + 1];
            retArray[j] = index >= 0 ? this.mStringBlocks[block].get(index) : null;
            i += 2;
            ++j;
        }
        return retArray;
    }

    public boolean getThemeValue(int theme, int ident, TypedValue outValue, boolean resolveRefs) {
        int block = AssetManager.loadThemeAttributeValue(theme, ident, outValue, resolveRefs);
        if (block >= 0) {
            if (outValue.type != 3) {
                return true;
            }
            StringBlock[] blocks = this.mStringBlocks;
            if (blocks == null) {
                this.ensureStringBlocks();
            }
            outValue.string = blocks[block].get(outValue.data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStringBlocks() {
        if (this.mStringBlocks == null) {
            AssetManager assetManager = this;
            synchronized (assetManager) {
                if (this.mStringBlocks == null) {
                    this.makeStringBlocks(true);
                }
            }
        }
    }

    public void makeStringBlocks(boolean copyFromSystem) {
        int sysNum = copyFromSystem ? AssetManager.sSystem.mStringBlocks.length : 0;
        int num = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[num];
        for (int i = 0; i < num; ++i) {
            this.mStringBlocks[i] = i < sysNum ? AssetManager.sSystem.mStringBlocks[i] : new StringBlock(this.getNativeStringBlock(i), true);
        }
    }

    public CharSequence getPooledString(int block, int id2) {
        return this.mStringBlocks[block - 1].get(id2);
    }

    public InputStream open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open(String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int asset = this.openAsset(fileName, accessMode);
            if (asset != 0) {
                AssetInputStream res = new AssetInputStream(asset, null);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openFd(String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openAssetFd(fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset file: " + fileName);
    }

    public String[] list(String string2) throws IOException {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#list(Ljava/lang/String;)[Ljava/lang/String;", true, this);
    }

    public InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    public InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    public InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int asset = this.openNonAssetNative(cookie, fileName, accessMode);
            if (asset != 0) {
                AssetInputStream res = new AssetInputStream(asset, null);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor pfd = this.openNonAssetFdNative(cookie, fileName, this.mOffsets);
            if (pfd != null) {
                return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
            }
        }
        throw new FileNotFoundException("Asset absolute file: " + fileName);
    }

    public XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock block = this.openXmlBlockAsset(cookie, fileName);
        XmlResourceParser rp = block.newParser();
        block.close();
        return rp;
    }

    public XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int xmlBlock = this.openXmlAssetNative(cookie, fileName);
            if (xmlBlock != 0) {
                XmlBlock res = new XmlBlock(this, xmlBlock);
                this.incRefsLocked(res.hashCode());
                return res;
            }
        }
        throw new FileNotFoundException("Asset XML file: " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            int res = this.newTheme();
            this.incRefsLocked(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTheme(int theme) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.deleteTheme(theme);
            this.decRefsLocked(theme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public int addAssetPath(String string2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#addAssetPath(Ljava/lang/String;)I", true, this);
    }

    public int[] addAssetPaths(String[] paths) {
        if (paths == null) {
            return null;
        }
        int[] cookies = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            cookies[i] = this.addAssetPath(paths[i]);
        }
        return cookies;
    }

    public boolean isUpToDate() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#isUpToDate()Z", true, this) != 0;
    }

    public void setLocale(String string2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#setLocale(Ljava/lang/String;)V", true, this);
    }

    public String[] getLocales() {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#getLocales()[Ljava/lang/String;", true, this);
    }

    public void setConfiguration(int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        OverrideMethod.invokeV("android.content.res.AssetManager#setConfiguration(IILjava/lang/String;IIIIIIIIIII)V", true, this);
    }

    public int getResourceIdentifier(String string2, String string3, String string4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getResourceIdentifier(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I", true, this);
    }

    public String getResourceName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceName(I)Ljava/lang/String;", true, this);
    }

    public String getResourcePackageName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourcePackageName(I)Ljava/lang/String;", true, this);
    }

    public String getResourceTypeName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceTypeName(I)Ljava/lang/String;", true, this);
    }

    public String getResourceEntryName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getResourceEntryName(I)Ljava/lang/String;", true, this);
    }

    public int openAsset(String string2, int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#openAsset(Ljava/lang/String;I)I", true, this);
    }

    public ParcelFileDescriptor openAssetFd(String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#openAssetFd(Ljava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, this);
    }

    public int openNonAssetNative(int n, String string2, int n2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#openNonAssetNative(ILjava/lang/String;I)I", true, this);
    }

    public ParcelFileDescriptor openNonAssetFdNative(int n, String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#openNonAssetFdNative(ILjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, this);
    }

    public void destroyAsset(int n) {
        OverrideMethod.invokeV("android.content.res.AssetManager#destroyAsset(I)V", true, this);
    }

    public int readAssetChar(int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#readAssetChar(I)I", true, this);
    }

    public int readAsset(int n, byte[] byArray, int n2, int n3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#readAsset(I[BII)I", true, this);
    }

    public long seekAsset(int n, long l, int n2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#seekAsset(IJI)J", true, this);
    }

    public long getAssetLength(int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#getAssetLength(I)J", true, this);
    }

    public long getAssetRemainingLength(int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#getAssetRemainingLength(I)J", true, this);
    }

    public int loadResourceValue(int n, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadResourceValue(ILandroid/util/TypedValue;Z)I", true, this);
    }

    public int loadResourceBagValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadResourceBagValue(IILandroid/util/TypedValue;Z)I", true, this);
    }

    public static boolean applyStyle(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#applyStyle(IIII[I[I[I)Z", true, null) != 0;
    }

    public boolean retrieveAttributes(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#retrieveAttributes(I[I[I[I)Z", true, this) != 0;
    }

    public int getArraySize(int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getArraySize(I)I", true, this);
    }

    public int retrieveArray(int n, int[] nArray) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#retrieveArray(I[I)I", true, this);
    }

    public int getStringBlockCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getStringBlockCount()I", true, this);
    }

    public int getNativeStringBlock(int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getNativeStringBlock(I)I", true, this);
    }

    public String getCookieName(int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getCookieName(I)Ljava/lang/String;", true, this);
    }

    public static int getGlobalAssetCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetCount()I", true, null);
    }

    public static String getAssetAllocations() {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getAssetAllocations()Ljava/lang/String;", true, null);
    }

    public static int getGlobalAssetManagerCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetManagerCount()I", true, null);
    }

    public int newTheme() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#newTheme()I", true, this);
    }

    public void deleteTheme(int n) {
        OverrideMethod.invokeV("android.content.res.AssetManager#deleteTheme(I)V", true, this);
    }

    public static void applyThemeStyle(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#applyThemeStyle(IIZ)V", true, null);
    }

    public static void copyTheme(int n, int n2) {
        OverrideMethod.invokeV("android.content.res.AssetManager#copyTheme(II)V", true, null);
    }

    public static int loadThemeAttributeValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#loadThemeAttributeValue(IILandroid/util/TypedValue;Z)I", true, null);
    }

    public static void dumpTheme(int n, int n2, String string2, String string3) {
        OverrideMethod.invokeV("android.content.res.AssetManager#dumpTheme(IILjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    public int openXmlAssetNative(int n, String string2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#openXmlAssetNative(ILjava/lang/String;)I", true, this);
    }

    public String[] getArrayStringResource(int n) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayStringResource(I)[Ljava/lang/String;", true, this);
    }

    public int[] getArrayStringInfo(int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayStringInfo(I)[I", true, this);
    }

    public int[] getArrayIntResource(int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#getArrayIntResource(I)[I", true, this);
    }

    public void init() {
        OverrideMethod.invokeV("android.content.res.AssetManager#init()V", true, this);
    }

    public void destroy() {
        OverrideMethod.invokeV("android.content.res.AssetManager#destroy()V", true, this);
    }

    public void incRefsLocked(int id2) {
        ++this.mNumRefs;
    }

    public void decRefsLocked(int id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    public static class 1 {
    }

    public class AssetInputStream
    extends InputStream {
        public int mAsset;
        public long mLength;
        public long mMarkPos;

        public int getAssetInt() {
            return this.mAsset;
        }

        public AssetInputStream(int asset) {
            this.mAsset = asset;
            this.mLength = AssetManager.this.getAssetLength(asset);
        }

        public int read() throws IOException {
            return AssetManager.this.readAssetChar(this.mAsset);
        }

        public boolean markSupported() {
            return true;
        }

        public int available() throws IOException {
            long len = AssetManager.this.getAssetRemainingLength(this.mAsset);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0) {
                    AssetManager.this.destroyAsset(this.mAsset);
                    this.mAsset = 0;
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        public void mark(int readlimit) {
            this.mMarkPos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
        }

        public void reset() throws IOException {
            AssetManager.this.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        public int read(byte[] b) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, b, off, len);
        }

        public long skip(long n) throws IOException {
            long pos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.this.seekAsset(this.mAsset, n, 0);
            }
            return n;
        }

        public void finalize() throws Throwable {
            this.close();
        }

        public /* synthetic */ AssetInputStream(int x1, 1 x2) {
            this(x1);
        }
    }
}

