/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.CharArrayBuffer;
import android.database.sqlite.SQLiteClosable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    public int nWindow;
    public int mStartPos;
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        @Override
        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source, null);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };

    public CursorWindow(boolean localWindow) {
        this.mStartPos = 0;
        this.native_init(localWindow);
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        this.acquireReference();
        try {
            int n = this.getNumRows_native();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public int getNumRows_native() {
        return OverrideMethod.invokeI("android.database.CursorWindow#getNumRows_native()I", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = this.setNumColumns_native(columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean setNumColumns_native(int n) {
        return OverrideMethod.invokeI("android.database.CursorWindow#setNumColumns_native(I)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = this.allocRow_native();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean allocRow_native() {
        return OverrideMethod.invokeI("android.database.CursorWindow#allocRow_native()Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLastRow() {
        this.acquireReference();
        try {
            this.freeLastRow_native();
        }
        finally {
            this.releaseReference();
        }
    }

    public void freeLastRow_native() {
        OverrideMethod.invokeV("android.database.CursorWindow#freeLastRow_native()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBlob(byte[] value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putBlob_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putBlob_native(byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#putBlob_native([BII)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putString(String value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putString_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putString_native(String string2, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#putString_native(Ljava/lang/String;II)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putLong(long value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putLong_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putLong_native(long l, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#putLong_native(JII)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putDouble(double value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putDouble_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putDouble_native(double d, int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#putDouble_native(DII)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putNull(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putNull_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean putNull_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#putNull_native(II)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isNull_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean isNull_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#isNull_native(II)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int row, int col) {
        this.acquireReference();
        try {
            byte[] byArray = this.getBlob_native(row - this.mStartPos, col);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    public byte[] getBlob_native(int n, int n2) {
        return (byte[])OverrideMethod.invokeA("android.database.CursorWindow#getBlob_native(II)[B", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlob(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isBlob_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLong(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isInteger_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFloat(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isFloat_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isString(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isString_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean isBlob_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#isBlob_native(II)Z", true, this) != 0;
    }

    public boolean isString_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#isString_native(II)Z", true, this) != 0;
    }

    public boolean isInteger_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#isInteger_native(II)Z", true, this) != 0;
    }

    public boolean isFloat_native(int n, int n2) {
        return OverrideMethod.invokeI("android.database.CursorWindow#isFloat_native(II)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int row, int col) {
        this.acquireReference();
        try {
            String string2 = this.getString_native(row - this.mStartPos, col);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    public String getString_native(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.database.CursorWindow#getString_native(II)Ljava/lang/String;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int row, int col, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        if (buffer.data == null) {
            buffer.data = new char[64];
        }
        this.acquireReference();
        try {
            char[] newbuf = this.copyStringToBuffer_native(row - this.mStartPos, col, buffer.data.length, buffer);
            if (newbuf != null) {
                buffer.data = newbuf;
            }
        }
        finally {
            this.releaseReference();
        }
    }

    public char[] copyStringToBuffer_native(int n, int n2, int n3, CharArrayBuffer charArrayBuffer) {
        return (char[])OverrideMethod.invokeA("android.database.CursorWindow#copyStringToBuffer_native(IIILandroid/database/CharArrayBuffer;)[C", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int row, int col) {
        this.acquireReference();
        try {
            long l = this.getLong_native(row - this.mStartPos, col);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    public long getLong_native(int n, int n2) {
        return OverrideMethod.invokeL("android.database.CursorWindow#getLong_native(II)J", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int row, int col) {
        this.acquireReference();
        try {
            double d = this.getDouble_native(row - this.mStartPos, col);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public double getDouble_native(int n, int n2) {
        return OverrideMethod.invokeD("android.database.CursorWindow#getDouble_native(II)D", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int row, int col) {
        this.acquireReference();
        try {
            short s = (short)this.getLong_native(row - this.mStartPos, col);
            return s;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int row, int col) {
        this.acquireReference();
        try {
            int n = (int)this.getLong_native(row - this.mStartPos, col);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int row, int col) {
        this.acquireReference();
        try {
            float f = (float)this.getDouble_native(row - this.mStartPos, col);
            return f;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            this.native_clear();
        }
        finally {
            this.releaseReference();
        }
    }

    public void native_clear() {
        OverrideMethod.invokeV("android.database.CursorWindow#native_clear()V", true, this);
    }

    public void close() {
        this.releaseReference();
    }

    public void close_native() {
        OverrideMethod.invokeV("android.database.CursorWindow#close_native()V", true, this);
    }

    public void finalize() {
        this.close_native();
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return CREATOR.createFromParcel(p);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.native_getBinder());
        dest.writeInt(this.mStartPos);
    }

    public CursorWindow(Parcel source) {
        IBinder nativeBinder = source.readStrongBinder();
        this.mStartPos = source.readInt();
        this.native_init(nativeBinder);
    }

    public IBinder native_getBinder() {
        return (IBinder)OverrideMethod.invokeA("android.database.CursorWindow#native_getBinder()Landroid/os/IBinder;", true, this);
    }

    public void native_init(boolean bl) {
        OverrideMethod.invokeV("android.database.CursorWindow#native_init(Z)V", true, this);
    }

    public void native_init(IBinder iBinder) {
        OverrideMethod.invokeV("android.database.CursorWindow#native_init(Landroid/os/IBinder;)V", true, this);
    }

    public void onAllReferencesReleased() {
        this.close_native();
    }

    public /* synthetic */ CursorWindow(Parcel x0, 1 x1) {
        this(x0);
    }
}

