/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.os.StrictMode;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;

public class SQLiteCompiledSql {
    public static final String TAG = "SQLiteCompiledSql";
    public SQLiteDatabase mDatabase;
    public int nHandle = 0;
    public int nStatement = 0;
    public String mSqlStmt = null;
    public Throwable mStackTrace = null;
    public boolean mInUse = false;

    public SQLiteCompiledSql(SQLiteDatabase db, String sql) {
        if (!db.isOpen()) {
            throw new IllegalStateException("database " + db.getPath() + " already closed");
        }
        this.mDatabase = db;
        this.mSqlStmt = sql;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = db.mNativeHandle;
        this.compile(sql, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String sql, boolean forceCompilation) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        if (forceCompilation) {
            this.mDatabase.lock();
            try {
                this.native_compile(sql);
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSqlStatement() {
        if (this.nStatement != 0) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "closed and deallocated DbObj (id#" + this.nStatement + ")");
            }
            try {
                this.mDatabase.lock();
                this.native_finalize();
                this.nStatement = 0;
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    public synchronized boolean acquire() {
        if (this.mInUse) {
            return false;
        }
        this.mInUse = true;
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v(TAG, "Acquired DbObj (id#" + this.nStatement + ") from DB cache");
        }
        return true;
    }

    public synchronized void release() {
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v(TAG, "Released DbObj (id#" + this.nStatement + ") back to DB cache");
        }
        this.mInUse = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.nStatement == 0) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "** warning ** Finalized DbObj (id#" + this.nStatement + ")");
            }
            if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                int len = this.mSqlStmt.length();
                StrictMode.onSqliteObjectLeaked("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: " + this.mSqlStmt.substring(0, len > 100 ? 100 : len), this.mStackTrace);
            }
            this.releaseSqlStatement();
        }
        finally {
            super.finalize();
        }
    }

    public void native_compile(String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteCompiledSql#native_compile(Ljava/lang/String;)V", true, this);
    }

    public void native_finalize() {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteCompiledSql#native_finalize()V", true, this);
    }
}

