/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Bitmap_Delegate;
import android.graphics.NinePatch;
import android.graphics.NinePatch_Delegate;
import android.graphics.Rect;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeResources;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.Density;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;

class BitmapFactory_Delegate {
    BitmapFactory_Delegate() {
    }

    @LayoutlibDelegate
    static Bitmap finishDecode(Bitmap bm, Rect outPadding, BitmapFactory.Options opts) {
        boolean isNinePatch;
        if (bm == null || opts == null) {
            return bm;
        }
        int density = opts.inDensity;
        if (density == 0) {
            return bm;
        }
        bm.setDensity(density);
        int targetDensity = opts.inTargetDensity;
        if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
            return bm;
        }
        byte[] np = bm.getNinePatchChunk();
        boolean bl = isNinePatch = np != null && NinePatch.isNinePatchChunk(np);
        if (opts.inScaled && !isNinePatch) {
            float scale = (float)targetDensity / (float)density;
            Bitmap oldBitmap = bm;
            bm = Bitmap.createScaledBitmap(oldBitmap, (int)((float)bm.getWidth() * scale + 0.5f), (int)((float)bm.getHeight() * scale + 0.5f), true);
            oldBitmap.recycle();
            if (isNinePatch) {
                np = BitmapFactory_Delegate.nativeScaleNinePatch(np, scale, outPadding);
                bm.setNinePatchChunk(np);
            }
            bm.setDensity(targetDensity);
        }
        return bm;
    }

    @LayoutlibDelegate
    static void nativeSetDefaultConfig(int nativeConfig) {
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeStream(InputStream is, byte[] storage, Rect padding, BitmapFactory.Options opts) {
        Bitmap bm = null;
        Density density = Density.MEDIUM;
        if (opts != null) {
            density = Density.getEnum((int)opts.inDensity);
        }
        try {
            if (is instanceof BridgeResources.NinePatchInputStream) {
                BridgeResources.NinePatchInputStream npis = (BridgeResources.NinePatchInputStream)is;
                npis.disableFakeMarkSupport();
                com.android.ninepatch.NinePatch ninePatch = com.android.ninepatch.NinePatch.load(npis, true, false);
                bm = Bitmap_Delegate.createBitmap(ninePatch.getImage(), true, density);
                NinePatchChunk chunk = ninePatch.getChunk();
                bm.setNinePatchChunk(NinePatch_Delegate.serialize(chunk));
                int[] paddingarray = chunk.getPadding();
                padding.left = paddingarray[0];
                padding.top = paddingarray[1];
                padding.right = paddingarray[2];
                padding.bottom = paddingarray[3];
            } else {
                bm = Bitmap_Delegate.createBitmap(is, true, density);
            }
        }
        catch (IOException e) {
            Bridge.getLog().error(null, "Failed to load image", (Throwable)e, null);
        }
        return bm;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeFileDescriptor(FileDescriptor fd, Rect padding, BitmapFactory.Options opts) {
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeAsset(int asset, Rect padding, BitmapFactory.Options opts) {
        return null;
    }

    @LayoutlibDelegate
    static Bitmap nativeDecodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        return null;
    }

    @LayoutlibDelegate
    static byte[] nativeScaleNinePatch(byte[] chunk, float scale, Rect pad) {
        return chunk;
    }
}

