/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Gradient_Delegate;
import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;

public final class LinearGradient_Delegate
extends Gradient_Delegate {
    private Paint mJavaPaint;

    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    @LayoutlibDelegate
    static int nativeCreate1(float x0, float y0, float x1, float y1, int[] colors, float[] positions, int tileMode) {
        LinearGradient_Delegate newDelegate = new LinearGradient_Delegate(x0, y0, x1, y1, colors, positions, Shader_Delegate.getTileMode(tileMode));
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static int nativeCreate2(float x0, float y0, float x1, float y1, int color0, int color1, int tileMode) {
        return LinearGradient_Delegate.nativeCreate1(x0, y0, x1, y1, new int[]{color0, color1}, null, tileMode);
    }

    private LinearGradient_Delegate(float x0, float y0, float x1, float y1, int[] colors, float[] positions, Shader.TileMode tile) {
        super(colors, positions);
        this.mJavaPaint = new LinearGradientPaint(x0, y0, x1, y1, this.mColors, this.mPositions, tile);
    }

    private class LinearGradientPaint
    extends Gradient_Delegate.GradientPaint {
        private final float mX0;
        private final float mY0;
        private final float mDx;
        private final float mDy;
        private final float mDSize2;

        public LinearGradientPaint(float x0, float y0, float x1, float y1, int[] colors, float[] positions, Shader.TileMode tile) {
            super(colors, positions, tile);
            this.mX0 = x0;
            this.mY0 = y0;
            this.mDx = x1 - x0;
            this.mDy = y1 - y0;
            this.mDSize2 = this.mDx * this.mDx + this.mDy * this.mDy;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            AffineTransform canvasMatrix;
            this.precomputeGradientColors();
            try {
                canvasMatrix = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in LinearGradient", (Throwable)e, null);
                canvasMatrix = new AffineTransform();
            }
            AffineTransform localMatrix = LinearGradient_Delegate.this.getLocalMatrix();
            try {
                localMatrix = localMatrix.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in LinearGradient", (Throwable)e, null);
                localMatrix = new AffineTransform();
            }
            return new LinearGradientPaintContext(canvasMatrix, localMatrix, colorModel);
        }

        private int getColor(float x, float y) {
            float pos;
            if (this.mDx == 0.0f) {
                pos = (y - this.mY0) / this.mDy;
            } else if (this.mDy == 0.0f) {
                pos = (x - this.mX0) / this.mDx;
            } else {
                float _x = (this.mDx * this.mDy * (y - this.mY0) + this.mDy * this.mDy * this.mX0 + this.mDx * this.mDx * x) / this.mDSize2;
                pos = (_x - this.mX0) / this.mDx;
            }
            return this.getGradientColor(pos);
        }

        private class LinearGradientPaintContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            private LinearGradientPaintContext(AffineTransform canvasMatrix, AffineTransform localMatrix, ColorModel colorModel) {
                this.mCanvasMatrix = canvasMatrix;
                this.mLocalMatrix = localMatrix;
                this.mColorModel = colorModel;
            }

            public void dispose() {
            }

            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            public Raster getRaster(int x, int y, int w, int h) {
                BufferedImage image = new BufferedImage(w, h, 2);
                int[] data = new int[w * h];
                int index = 0;
                float[] pt1 = new float[2];
                float[] pt2 = new float[2];
                for (int iy = 0; iy < h; ++iy) {
                    for (int ix = 0; ix < w; ++ix) {
                        pt1[0] = x + ix;
                        pt1[1] = y + iy;
                        this.mCanvasMatrix.transform(pt1, 0, pt2, 0, 1);
                        pt1[0] = pt2[0];
                        pt1[1] = pt2[1];
                        this.mLocalMatrix.transform(pt1, 0, pt2, 0, 1);
                        data[index++] = LinearGradientPaint.this.getColor(pt2[0], pt2[1]);
                    }
                }
                image.setRGB(0, 0, w, h, data, 0, w);
                return image.getRaster();
            }
        }
    }
}

