/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public final class Matrix_Delegate {
    private static final int MATRIX_SIZE = 9;
    private static final DelegateManager<Matrix_Delegate> sManager = new DelegateManager<Matrix_Delegate>(Matrix_Delegate.class);
    private float[] mValues = new float[9];
    private static final int kIdentity_Mask = 0;
    private static final int kTranslate_Mask = 1;
    private static final int kScale_Mask = 2;
    private static final int kAffine_Mask = 4;
    private static final int kPerspective_Mask = 8;
    private static final int kRectStaysRect_Mask = 16;
    private static final int kUnknown_Mask = 128;
    private static final int kAllMasks = 31;
    private static final int kTranslate_Shift = 0;
    private static final int kScale_Shift = 1;
    private static final int kAffine_Shift = 2;
    private static final int kPerspective_Shift = 3;
    private static final int kRectStaysRect_Shift = 4;

    public static Matrix_Delegate getDelegate(int native_instance) {
        return sManager.getDelegate(native_instance);
    }

    public static AffineTransform getAffineTransform(Matrix m) {
        Matrix_Delegate delegate = sManager.getDelegate(m.native_instance);
        if (delegate == null) {
            return null;
        }
        return delegate.getAffineTransform();
    }

    public static boolean hasPerspective(Matrix m) {
        Matrix_Delegate delegate = sManager.getDelegate(m.native_instance);
        if (delegate == null) {
            return false;
        }
        return delegate.hasPerspective();
    }

    public void set(Matrix_Delegate matrix) {
        System.arraycopy(matrix.mValues, 0, this.mValues, 0, 9);
    }

    public void set(float[] values) {
        System.arraycopy(values, 0, this.mValues, 0, 9);
    }

    public void reset() {
        Matrix_Delegate.reset(this.mValues);
    }

    public boolean isIdentity() {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                if (this.mValues[k] != (float)(i == j ? 1 : 0)) {
                    return false;
                }
                ++j;
                ++k;
            }
        }
        return true;
    }

    public static float[] makeValues(AffineTransform matrix) {
        float[] values = new float[]{(float)matrix.getScaleX(), (float)matrix.getShearX(), (float)matrix.getTranslateX(), (float)matrix.getShearY(), (float)matrix.getScaleY(), (float)matrix.getTranslateY(), 0.0f, 0.0f, 1.0f};
        return values;
    }

    public static Matrix_Delegate make(AffineTransform matrix) {
        return new Matrix_Delegate(Matrix_Delegate.makeValues(matrix));
    }

    public boolean mapRect(RectF dst, RectF src) {
        float[] corners = new float[]{src.left, src.top, src.right, src.top, src.right, src.bottom, src.left, src.bottom};
        this.mapPoints(corners);
        dst.left = Math.min(Math.min(corners[0], corners[2]), Math.min(corners[4], corners[6]));
        dst.right = Math.max(Math.max(corners[0], corners[2]), Math.max(corners[4], corners[6]));
        dst.top = Math.min(Math.min(corners[1], corners[3]), Math.min(corners[5], corners[7]));
        dst.bottom = Math.max(Math.max(corners[1], corners[3]), Math.max(corners[5], corners[7]));
        return (this.computeTypeMask() & 0x10) != 0;
    }

    public AffineTransform getAffineTransform() {
        return Matrix_Delegate.getAffineTransform(this.mValues);
    }

    public boolean hasPerspective() {
        return this.mValues[6] != 0.0f || this.mValues[7] != 0.0f || this.mValues[8] != 1.0f;
    }

    @LayoutlibDelegate
    static int native_create(int native_src_or_zero) {
        Matrix_Delegate oldDelegate;
        Matrix_Delegate newDelegate = new Matrix_Delegate();
        if (native_src_or_zero > 0 && (oldDelegate = sManager.getDelegate(native_src_or_zero)) != null) {
            System.arraycopy(oldDelegate.mValues, 0, newDelegate.mValues, 0, 9);
        }
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static boolean native_isIdentity(int native_object) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        return d.isIdentity();
    }

    @LayoutlibDelegate
    static boolean native_rectStaysRect(int native_object) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return true;
        }
        return (d.computeTypeMask() & 0x10) != 0;
    }

    @LayoutlibDelegate
    static void native_reset(int native_object) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate.reset(d.mValues);
    }

    @LayoutlibDelegate
    static void native_set(int native_object, int other) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate src = sManager.getDelegate(other);
        if (src == null) {
            return;
        }
        System.arraycopy(src.mValues, 0, d.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static void native_setTranslate(int native_object, float dx, float dy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate.setTranslate(d.mValues, dx, dy);
    }

    @LayoutlibDelegate
    static void native_setScale(int native_object, float sx, float sy, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        d.mValues = Matrix_Delegate.getScale(sx, sy, px, py);
    }

    @LayoutlibDelegate
    static void native_setScale(int native_object, float sx, float sy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        d.mValues[0] = sx;
        d.mValues[1] = 0.0f;
        d.mValues[2] = 0.0f;
        d.mValues[3] = 0.0f;
        d.mValues[4] = sy;
        d.mValues[5] = 0.0f;
        d.mValues[6] = 0.0f;
        d.mValues[7] = 0.0f;
        d.mValues[8] = 1.0f;
    }

    @LayoutlibDelegate
    static void native_setRotate(int native_object, float degrees, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        d.mValues = Matrix_Delegate.getRotate(degrees, px, py);
    }

    @LayoutlibDelegate
    static void native_setRotate(int native_object, float degrees) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate.setRotate(d.mValues, degrees);
    }

    @LayoutlibDelegate
    static void native_setSinCos(int native_object, float sinValue, float cosValue, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate.setTranslate(d.mValues, -px, -py);
        d.postTransform(Matrix_Delegate.getRotate(sinValue, cosValue));
        d.postTransform(Matrix_Delegate.getTranslate(px, py));
    }

    @LayoutlibDelegate
    static void native_setSinCos(int native_object, float sinValue, float cosValue) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        Matrix_Delegate.setRotate(d.mValues, sinValue, cosValue);
    }

    @LayoutlibDelegate
    static void native_setSkew(int native_object, float kx, float ky, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        d.mValues = Matrix_Delegate.getSkew(kx, ky, px, py);
    }

    @LayoutlibDelegate
    static void native_setSkew(int native_object, float kx, float ky) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        d.mValues[0] = 1.0f;
        d.mValues[1] = kx;
        d.mValues[2] = 0.0f;
        d.mValues[3] = ky;
        d.mValues[4] = 1.0f;
        d.mValues[5] = 0.0f;
        d.mValues[6] = 0.0f;
        d.mValues[7] = 0.0f;
        d.mValues[8] = 1.0f;
    }

    @LayoutlibDelegate
    static boolean native_setConcat(int native_object, int a, int b) {
        if (a == native_object) {
            return Matrix_Delegate.native_preConcat(native_object, b);
        }
        if (b == native_object) {
            return Matrix_Delegate.native_postConcat(native_object, a);
        }
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        Matrix_Delegate a_mtx = sManager.getDelegate(a);
        if (a_mtx == null) {
            return false;
        }
        Matrix_Delegate b_mtx = sManager.getDelegate(b);
        if (b_mtx == null) {
            return false;
        }
        Matrix_Delegate.multiply(d.mValues, a_mtx.mValues, b_mtx.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preTranslate(int native_object, float dx, float dy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getTranslate(dx, dy));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preScale(int native_object, float sx, float sy, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getScale(sx, sy, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preScale(int native_object, float sx, float sy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getScale(sx, sy));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preRotate(int native_object, float degrees, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getRotate(degrees, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preRotate(int native_object, float degrees) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        double rad = Math.toRadians(degrees);
        float sin = (float)Math.sin(rad);
        float cos = (float)Math.cos(rad);
        d.preTransform(Matrix_Delegate.getRotate(sin, cos));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preSkew(int native_object, float kx, float ky, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getSkew(kx, ky, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preSkew(int native_object, float kx, float ky) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.preTransform(Matrix_Delegate.getSkew(kx, ky));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_preConcat(int native_object, int other_matrix) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        Matrix_Delegate other = sManager.getDelegate(other_matrix);
        if (d == null) {
            return false;
        }
        d.preTransform(other.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postTranslate(int native_object, float dx, float dy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getTranslate(dx, dy));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postScale(int native_object, float sx, float sy, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getScale(sx, sy, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postScale(int native_object, float sx, float sy) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getScale(sx, sy));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postRotate(int native_object, float degrees, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getRotate(degrees, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postRotate(int native_object, float degrees) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getRotate(degrees));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postSkew(int native_object, float kx, float ky, float px, float py) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getSkew(kx, ky, px, py));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postSkew(int native_object, float kx, float ky) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        d.postTransform(Matrix_Delegate.getSkew(kx, ky));
        return true;
    }

    @LayoutlibDelegate
    static boolean native_postConcat(int native_object, int other_matrix) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        Matrix_Delegate other = sManager.getDelegate(other_matrix);
        if (d == null) {
            return false;
        }
        d.postTransform(other.mValues);
        return true;
    }

    @LayoutlibDelegate
    static boolean native_setRectToRect(int native_object, RectF src, RectF dst, int stf) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        if (src.isEmpty()) {
            Matrix_Delegate.reset(d.mValues);
            return false;
        }
        if (dst.isEmpty()) {
            d.mValues[7] = 0.0f;
            d.mValues[6] = 0.0f;
            d.mValues[5] = 0.0f;
            d.mValues[4] = 0.0f;
            d.mValues[3] = 0.0f;
            d.mValues[2] = 0.0f;
            d.mValues[1] = 0.0f;
            d.mValues[0] = 0.0f;
            d.mValues[8] = 1.0f;
        } else {
            float sx = dst.width() / src.width();
            float sy = dst.height() / src.height();
            boolean xLarger = false;
            if (stf != Matrix.ScaleToFit.FILL.nativeInt) {
                if (sx > sy) {
                    xLarger = true;
                    sx = sy;
                } else {
                    sy = sx;
                }
            }
            float tx = dst.left - src.left * sx;
            float ty = dst.top - src.top * sy;
            if (stf == Matrix.ScaleToFit.CENTER.nativeInt || stf == Matrix.ScaleToFit.END.nativeInt) {
                float diff = xLarger ? dst.width() - src.width() * sy : dst.height() - src.height() * sy;
                if (stf == Matrix.ScaleToFit.CENTER.nativeInt) {
                    diff /= 2.0f;
                }
                if (xLarger) {
                    tx += diff;
                } else {
                    ty += diff;
                }
            }
            d.mValues[0] = sx;
            d.mValues[4] = sy;
            d.mValues[2] = tx;
            d.mValues[5] = ty;
            d.mValues[7] = 0.0f;
            d.mValues[6] = 0.0f;
            d.mValues[3] = 0.0f;
            d.mValues[1] = 0.0f;
        }
        d.mValues[8] = 1.0f;
        return true;
    }

    @LayoutlibDelegate
    static boolean native_setPolyToPoly(int native_object, float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        Bridge.getLog().fidelityWarning("unsupported", "Matrix.setPolyToPoly is not supported.", null, null);
        return false;
    }

    @LayoutlibDelegate
    static boolean native_invert(int native_object, int inverse) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        Matrix_Delegate inv_mtx = sManager.getDelegate(inverse);
        if (inv_mtx == null) {
            return false;
        }
        try {
            AffineTransform affineTransform = d.getAffineTransform();
            AffineTransform inverseTransform = affineTransform.createInverse();
            inv_mtx.mValues[0] = (float)inverseTransform.getScaleX();
            inv_mtx.mValues[1] = (float)inverseTransform.getShearX();
            inv_mtx.mValues[2] = (float)inverseTransform.getTranslateX();
            inv_mtx.mValues[3] = (float)inverseTransform.getScaleX();
            inv_mtx.mValues[4] = (float)inverseTransform.getShearY();
            inv_mtx.mValues[5] = (float)inverseTransform.getTranslateY();
            return true;
        }
        catch (NoninvertibleTransformException e) {
            return false;
        }
    }

    @LayoutlibDelegate
    static void native_mapPoints(int native_object, float[] dst, int dstIndex, float[] src, int srcIndex, int ptCount, boolean isPts) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        if (isPts) {
            d.mapPoints(dst, dstIndex, src, srcIndex, ptCount);
        } else {
            d.mapVectors(dst, dstIndex, src, srcIndex, ptCount);
        }
    }

    @LayoutlibDelegate
    static boolean native_mapRect(int native_object, RectF dst, RectF src) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return false;
        }
        return d.mapRect(dst, src);
    }

    @LayoutlibDelegate
    static float native_mapRadius(int native_object, float radius) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return 0.0f;
        }
        float[] src = new float[]{radius, 0.0f, 0.0f, radius};
        d.mapVectors(src, 0, src, 0, 2);
        float l1 = Matrix_Delegate.getPointLength(src, 0);
        float l2 = Matrix_Delegate.getPointLength(src, 2);
        return (float)Math.sqrt(l1 * l2);
    }

    @LayoutlibDelegate
    static void native_getValues(int native_object, float[] values) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        System.arraycopy(d.mValues, 0, d.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static void native_setValues(int native_object, float[] values) {
        Matrix_Delegate d = sManager.getDelegate(native_object);
        if (d == null) {
            return;
        }
        System.arraycopy(values, 0, d.mValues, 0, 9);
    }

    @LayoutlibDelegate
    static boolean native_equals(int native_a, int native_b) {
        Matrix_Delegate a = sManager.getDelegate(native_a);
        if (a == null) {
            return false;
        }
        Matrix_Delegate b = sManager.getDelegate(native_b);
        if (b == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (a.mValues[i] == b.mValues[i]) continue;
            return false;
        }
        return true;
    }

    @LayoutlibDelegate
    static void finalizer(int native_instance) {
        sManager.removeJavaReferenceFor(native_instance);
    }

    static AffineTransform getAffineTransform(float[] matrix) {
        return new AffineTransform(matrix[0], matrix[3], matrix[1], matrix[4], matrix[2], matrix[5]);
    }

    private static void reset(float[] mtx) {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                mtx[k] = i == j ? 1 : 0;
                ++j;
                ++k;
            }
        }
    }

    private int computeTypeMask() {
        int mask = 0;
        if ((double)this.mValues[6] != 0.0 || (double)this.mValues[7] != 0.0 || (double)this.mValues[8] != 1.0) {
            mask |= 8;
        }
        if ((double)this.mValues[2] != 0.0 || (double)this.mValues[5] != 0.0) {
            mask |= 1;
        }
        float m00 = this.mValues[0];
        float m01 = this.mValues[1];
        float m10 = this.mValues[3];
        float m11 = this.mValues[4];
        if ((double)m01 != 0.0 || (double)m10 != 0.0) {
            mask |= 4;
        }
        if ((double)m00 != 1.0 || (double)m11 != 1.0) {
            mask |= 2;
        }
        if ((mask & 8) == 0) {
            boolean im00 = m00 != 0.0f;
            boolean im01 = m01 != 0.0f;
            boolean im10 = m10 != 0.0f;
            boolean im11 = m11 != 0.0f;
            boolean dp0 = (im00 | im11) ^ true;
            boolean dp1 = im00 & im11;
            boolean ds0 = (im01 | im10) ^ true;
            boolean ds1 = im01 & im10;
            mask |= (dp0 & ds1 | dp1 & ds0) << 4;
        }
        return mask;
    }

    private Matrix_Delegate() {
        this.reset();
    }

    private Matrix_Delegate(float[] values) {
        System.arraycopy(values, 0, this.mValues, 0, 9);
    }

    private void postTransform(float[] matrix) {
        float[] tmp = new float[9];
        Matrix_Delegate.multiply(tmp, this.mValues, matrix);
        this.mValues = tmp;
    }

    private void preTransform(float[] matrix) {
        float[] tmp = new float[9];
        Matrix_Delegate.multiply(tmp, matrix, this.mValues);
        this.mValues = tmp;
    }

    private void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        boolean inPlace;
        int count = pointCount * 2;
        float[] tmpDest = dst;
        boolean bl = inPlace = dst == src;
        if (inPlace) {
            tmpDest = new float[dstIndex + count];
        }
        for (int i = 0; i < count; i += 2) {
            float x = this.mValues[0] * src[i + srcIndex] + this.mValues[1] * src[i + srcIndex + 1] + this.mValues[2];
            float y = this.mValues[3] * src[i + srcIndex] + this.mValues[4] * src[i + srcIndex + 1] + this.mValues[5];
            tmpDest[i + dstIndex] = x;
            tmpDest[i + dstIndex + 1] = y;
        }
        if (inPlace) {
            System.arraycopy(tmpDest, dstIndex, dst, dstIndex, count);
        }
    }

    private void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    private void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int ptCount) {
        if (this.hasPerspective()) {
            float[] origin = new float[]{0.0f, 0.0f};
            this.mapPoints(origin);
            this.mapPoints(dst, dstIndex, src, srcIndex, ptCount);
            int count = ptCount * 2;
            for (int i = 0; i < count; i += 2) {
                dst[dstIndex + i] = dst[dstIndex + i] - origin[0];
                dst[dstIndex + i + 1] = dst[dstIndex + i + 1] - origin[1];
            }
        } else {
            Matrix_Delegate copy = new Matrix_Delegate(this.mValues);
            Matrix_Delegate.setTranslate(copy.mValues, 0.0f, 0.0f);
            copy.mapPoints(dst, dstIndex, src, srcIndex, ptCount);
        }
    }

    private static float getPointLength(float[] src, int index) {
        return (float)Math.sqrt(src[index] * src[index] + src[index + 1] * src[index + 1]);
    }

    static void multiply(float[] dest, float[] a, float[] b) {
        dest[0] = b[0] * a[0] + b[1] * a[3] + b[2] * a[6];
        dest[1] = b[0] * a[1] + b[1] * a[4] + b[2] * a[7];
        dest[2] = b[0] * a[2] + b[1] * a[5] + b[2] * a[8];
        dest[3] = b[3] * a[0] + b[4] * a[3] + b[5] * a[6];
        dest[4] = b[3] * a[1] + b[4] * a[4] + b[5] * a[7];
        dest[5] = b[3] * a[2] + b[4] * a[5] + b[5] * a[8];
        dest[6] = b[6] * a[0] + b[7] * a[3] + b[8] * a[6];
        dest[7] = b[6] * a[1] + b[7] * a[4] + b[8] * a[7];
        dest[8] = b[6] * a[2] + b[7] * a[5] + b[8] * a[8];
    }

    static float[] getTranslate(float dx, float dy) {
        return Matrix_Delegate.setTranslate(new float[9], dx, dy);
    }

    static float[] setTranslate(float[] dest, float dx, float dy) {
        dest[0] = 1.0f;
        dest[1] = 0.0f;
        dest[2] = dx;
        dest[3] = 0.0f;
        dest[4] = 1.0f;
        dest[5] = dy;
        dest[6] = 0.0f;
        dest[7] = 0.0f;
        dest[8] = 1.0f;
        return dest;
    }

    static float[] getScale(float sx, float sy) {
        return new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    static float[] getScale(float sx, float sy, float px, float py) {
        float[] tmp = new float[9];
        float[] tmp2 = new float[9];
        Matrix_Delegate.setTranslate(tmp, -px, -py);
        Matrix_Delegate.multiply(tmp2, tmp, Matrix_Delegate.getScale(sx, sy));
        Matrix_Delegate.multiply(tmp, tmp2, Matrix_Delegate.getTranslate(px, py));
        return tmp;
    }

    static float[] getRotate(float degrees) {
        double rad = Math.toRadians(degrees);
        float sin = (float)Math.sin(rad);
        float cos = (float)Math.cos(rad);
        return Matrix_Delegate.getRotate(sin, cos);
    }

    static float[] getRotate(float sin, float cos) {
        return Matrix_Delegate.setRotate(new float[9], sin, cos);
    }

    static float[] setRotate(float[] dest, float degrees) {
        double rad = Math.toRadians(degrees);
        float sin = (float)Math.sin(rad);
        float cos = (float)Math.cos(rad);
        return Matrix_Delegate.setRotate(dest, sin, cos);
    }

    static float[] setRotate(float[] dest, float sin, float cos) {
        dest[0] = cos;
        dest[1] = -sin;
        dest[2] = 0.0f;
        dest[3] = sin;
        dest[4] = cos;
        dest[5] = 0.0f;
        dest[6] = 0.0f;
        dest[7] = 0.0f;
        dest[8] = 1.0f;
        return dest;
    }

    static float[] getRotate(float degrees, float px, float py) {
        float[] tmp = new float[9];
        float[] tmp2 = new float[9];
        Matrix_Delegate.setTranslate(tmp, -px, -py);
        double rad = Math.toRadians(degrees);
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        Matrix_Delegate.multiply(tmp2, tmp, Matrix_Delegate.getRotate(sin, cos));
        Matrix_Delegate.multiply(tmp, tmp2, Matrix_Delegate.getTranslate(px, py));
        return tmp;
    }

    static float[] getSkew(float kx, float ky) {
        return new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    static float[] getSkew(float kx, float ky, float px, float py) {
        float[] tmp = new float[9];
        float[] tmp2 = new float[9];
        Matrix_Delegate.setTranslate(tmp, -px, -py);
        Matrix_Delegate.multiply(tmp2, tmp, new float[]{1.0f, kx, 0.0f, ky, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        Matrix_Delegate.multiply(tmp, tmp2, Matrix_Delegate.getTranslate(px, py));
        return tmp;
    }
}

