/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.app.PendingIntent;
import android.content.Context;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class UsbManager {
    public static final String TAG = "UsbManager";
    public static final String ACTION_USB_STATE = "android.hardware.usb.action.USB_STATE";
    public static final String ACTION_USB_ACCESSORY_ATTACHED = "android.hardware.usb.action.USB_ACCESSORY_ATTACHED";
    public static final String ACTION_USB_ACCESSORY_DETACHED = "android.hardware.usb.action.USB_ACCESSORY_DETACHED";
    public static final String USB_CONNECTED = "connected";
    public static final String USB_CONFIGURATION = "configuration";
    public static final String USB_FUNCTION_MASS_STORAGE = "mass_storage";
    public static final String USB_FUNCTION_ADB = "adb";
    public static final String USB_FUNCTION_RNDIS = "rndis";
    public static final String USB_FUNCTION_MTP = "mtp";
    public static final String USB_FUNCTION_ACCESSORY = "accessory";
    public static final String USB_FUNCTION_ENABLED = "enabled";
    public static final String USB_FUNCTION_DISABLED = "disabled";
    public static final String EXTRA_ACCESSORY = "accessory";
    public static final String EXTRA_PERMISSION_GRANTED = "permission";
    public final Context mContext;
    public final IUsbManager mService;

    public UsbManager(Context context, IUsbManager service) {
        this.mContext = context;
        this.mService = service;
    }

    public UsbAccessory[] getAccessoryList() {
        try {
            UsbAccessory accessory = this.mService.getCurrentAccessory();
            if (accessory == null) {
                return null;
            }
            return new UsbAccessory[]{accessory};
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getAccessoryList", e);
            return null;
        }
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            return this.mService.openAccessory(accessory);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in openAccessory", e);
            return null;
        }
    }

    public boolean hasPermission(UsbAccessory accessory) {
        try {
            return this.mService.hasAccessoryPermission(accessory);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in hasPermission", e);
            return false;
        }
    }

    public void requestPermission(UsbAccessory accessory, PendingIntent pi) {
        try {
            this.mService.requestAccessoryPermission(accessory, this.mContext.getPackageName(), pi);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in requestPermission", e);
        }
    }

    public static File getFunctionEnableFile(String function) {
        return new File("/sys/class/usb_composite/" + function + "/enable");
    }

    public static boolean isFunctionSupported(String function) {
        return UsbManager.getFunctionEnableFile(function).exists();
    }

    public static boolean isFunctionEnabled(String function) {
        try {
            FileInputStream stream = new FileInputStream(UsbManager.getFunctionEnableFile(function));
            boolean enabled = stream.read() == 49;
            stream.close();
            return enabled;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean setFunctionEnabled(String function, boolean enable) {
        try {
            FileOutputStream stream = new FileOutputStream(UsbManager.getFunctionEnableFile(function));
            stream.write(enable ? 49 : 48);
            stream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

