/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.SSLSessionCache;
import android.os.SystemProperties;
import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.OpenSSLContextImpl;
import org.apache.harmony.xnet.provider.jsse.OpenSSLSocketImpl;
import org.apache.harmony.xnet.provider.jsse.SSLClientSessionCache;

public class SSLCertificateSocketFactory
extends SSLSocketFactory {
    public static final String TAG = "SSLCertificateSocketFactory";
    public static final TrustManager[] INSECURE_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    public static final HostnameVerifier HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    public SSLSocketFactory mInsecureFactory = null;
    public SSLSocketFactory mSecureFactory = null;
    public final int mHandshakeTimeoutMillis;
    public final SSLClientSessionCache mSessionCache;
    public final boolean mSecure;

    @Deprecated
    public SSLCertificateSocketFactory(int handshakeTimeoutMillis) {
        this(handshakeTimeoutMillis, null, true);
    }

    public SSLCertificateSocketFactory(int handshakeTimeoutMillis, SSLSessionCache cache, boolean secure) {
        this.mHandshakeTimeoutMillis = handshakeTimeoutMillis;
        this.mSessionCache = cache == null ? null : cache.mSessionCache;
        this.mSecure = secure;
    }

    public static SocketFactory getDefault(int handshakeTimeoutMillis) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, null, true);
    }

    public static SSLSocketFactory getDefault(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, true);
    }

    public static SSLSocketFactory getInsecure(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, false);
    }

    public static org.apache.http.conn.ssl.SSLSocketFactory getHttpSocketFactory(int handshakeTimeoutMillis, SSLSessionCache cache) {
        return new org.apache.http.conn.ssl.SSLSocketFactory((SSLSocketFactory)new SSLCertificateSocketFactory(handshakeTimeoutMillis, cache, true));
    }

    public static void verifyHostname(Socket socket, String hostname) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        if (!SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            SSLSocket ssl = (SSLSocket)socket;
            ssl.startHandshake();
            SSLSession session = ssl.getSession();
            if (session == null) {
                throw new SSLException("Cannot verify SSL socket without session");
            }
            if (!HOSTNAME_VERIFIER.verify(hostname, session)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: " + hostname);
            }
        }
    }

    public SSLSocketFactory makeSocketFactory(TrustManager[] trustManagers) {
        try {
            OpenSSLContextImpl sslContext = new OpenSSLContextImpl();
            sslContext.engineInit(null, trustManagers, null);
            sslContext.engineGetClientSessionContext().setPersistentCache(this.mSessionCache);
            return sslContext.engineGetSocketFactory();
        }
        catch (KeyManagementException e) {
            Log.wtf(TAG, e);
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    public static boolean isSslCheckRelaxed() {
        return "1".equals(SystemProperties.get("ro.debuggable")) && "yes".equals(SystemProperties.get("socket.relaxsslcheck"));
    }

    public synchronized SSLSocketFactory getDelegate() {
        if (!this.mSecure || SSLCertificateSocketFactory.isSslCheckRelaxed()) {
            if (this.mInsecureFactory == null) {
                if (this.mSecure) {
                    Log.w(TAG, "*** BYPASSING SSL SECURITY CHECKS (socket.relaxsslcheck=yes) ***");
                } else {
                    Log.w(TAG, "Bypassing SSL security checks at caller's request");
                }
                this.mInsecureFactory = this.makeSocketFactory(INSECURE_TRUST_MANAGER);
            }
            return this.mInsecureFactory;
        }
        if (this.mSecureFactory == null) {
            this.mSecureFactory = this.makeSocketFactory(null);
        }
        return this.mSecureFactory;
    }

    public Socket createSocket(Socket k, String host, int port, boolean close) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(k, host, port, close);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    public Socket createSocket() throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket();
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        return s;
    }

    public Socket createSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(addr, port, localAddr, localPort);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        return s;
    }

    public Socket createSocket(InetAddress addr, int port) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(addr, port);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        return s;
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(host, port, localAddr, localPort);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    public Socket createSocket(String host, int port) throws IOException {
        OpenSSLSocketImpl s = (OpenSSLSocketImpl)this.getDelegate().createSocket(host, port);
        s.setHandshakeTimeout(this.mHandshakeTimeoutMillis);
        if (this.mSecure) {
            SSLCertificateSocketFactory.verifyHostname(s, host);
        }
        return s;
    }

    public String[] getDefaultCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.getDelegate().getSupportedCipherSuites();
    }
}

