/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Map;

public class AudioGroup {
    public static final int MODE_ON_HOLD = 0;
    public static final int MODE_MUTED = 1;
    public static final int MODE_NORMAL = 2;
    public static final int MODE_ECHO_SUPPRESSION = 3;
    public final Map<AudioStream, Integer> mStreams = new HashMap<AudioStream, Integer>();
    public int mMode = 0;
    public int mNative;

    public int getMode() {
        return this.mMode;
    }

    public synchronized void setMode(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#setMode(I)V", true, this);
    }

    public void add(int n, int n2, String string2, int n3, String string3, int n4) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#add(IILjava/lang/String;ILjava/lang/String;I)V", true, this);
    }

    public synchronized void add(AudioStream stream, AudioCodec codec, int dtmfType) {
        if (!this.mStreams.containsKey(stream)) {
            try {
                int socket = stream.dup();
                String codecSpec = String.format("%d %s %s", codec.type, codec.rtpmap, codec.fmtp);
                this.add(stream.getMode(), socket, stream.getRemoteAddress().getHostAddress(), stream.getRemotePort(), codecSpec, dtmfType);
                this.mStreams.put(stream, socket);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void remove(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#remove(I)V", true, this);
    }

    public synchronized void remove(AudioStream stream) {
        Integer socket = this.mStreams.remove(stream);
        if (socket != null) {
            this.remove(socket);
        }
    }

    public synchronized void sendDtmf(int n) {
        OverrideMethod.invokeV("android.net.rtp.AudioGroup#sendDtmf(I)V", true, this);
    }

    public synchronized void clear() {
        this.remove(-1);
    }

    public void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    static {
        System.loadLibrary("rtp_jni");
    }
}

