/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;

public class MessageQueue {
    public Message mMessages;
    public final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    public IdleHandler[] mPendingIdleHandlers;
    public boolean mQuiting;
    public boolean mQuitAllowed = true;
    public boolean mBlocked;
    public int mPtr;

    public void nativeInit() {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeInit()V", true, this);
    }

    public void nativeDestroy() {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeDestroy()V", true, this);
    }

    public void nativePollOnce(int n, int n2) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativePollOnce(II)V", true, this);
    }

    public void nativeWake(int n) {
        OverrideMethod.invokeV("android.os.MessageQueue#nativeWake(I)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    public MessageQueue() {
        this.nativeInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.nativeDestroy();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message next() {
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.nativePollOnce(this.mPtr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now = SystemClock.uptimeMillis();
                Message msg = this.mMessages;
                if (msg != null) {
                    long when = msg.when;
                    if (now >= when) {
                        this.mBlocked = false;
                        this.mMessages = msg.next;
                        msg.next = null;
                        return msg;
                    }
                    nextPollTimeoutMillis = (int)Math.min(when - now, Integer.MAX_VALUE);
                } else {
                    nextPollTimeoutMillis = -1;
                }
                if (pendingIdleHandlerCount < 0) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount == 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf("MessageQueue", "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueMessage(Message msg, long when) {
        boolean needWake;
        if (msg.when != 0L) {
            throw new AndroidRuntimeException(msg + " This message is already in use.");
        }
        if (msg.target == null && !this.mQuitAllowed) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuiting) {
                RuntimeException e = new RuntimeException(msg.target + " sending message to a Handler on a dead thread");
                Log.w("MessageQueue", e.getMessage(), e);
                return false;
            }
            if (msg.target == null) {
                this.mQuiting = true;
            }
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                Message prev = null;
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
                msg.next = prev.next;
                prev.next = msg;
                needWake = false;
            }
        }
        if (needWake) {
            this.nativeWake(this.mPtr);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessages(Handler h, int what, Object object, boolean doRemove) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            boolean found = false;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                if (!doRemove) {
                    return true;
                }
                found = true;
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    if (!doRemove) {
                        return true;
                    }
                    found = true;
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
            return found;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(Handler h, Runnable r, Object object) {
        if (r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbacksAndMessages(Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycle();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycle();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

