/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.ZygoteStartFailedEx;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Process {
    public static final String LOG_TAG = "Process";
    public static final String ZYGOTE_SOCKET = "zygote";
    public static final String ANDROID_SHARED_MEDIA = "com.android.process.media";
    public static final String GOOGLE_SHARED_APP_CONTENT = "com.google.process.content";
    public static final int SYSTEM_UID = 1000;
    public static final int PHONE_UID = 1001;
    public static final int SHELL_UID = 2000;
    public static final int LOG_UID = 1007;
    public static final int WIFI_UID = 1010;
    public static final int NFC_UID = 1025;
    public static final int FIRST_APPLICATION_UID = 10000;
    public static final int LAST_APPLICATION_UID = 99999;
    public static final int BLUETOOTH_GID = 2000;
    public static final int THREAD_PRIORITY_DEFAULT = 0;
    public static final int THREAD_PRIORITY_LOWEST = 19;
    public static final int THREAD_PRIORITY_BACKGROUND = 10;
    public static final int THREAD_PRIORITY_FOREGROUND = -2;
    public static final int THREAD_PRIORITY_DISPLAY = -4;
    public static final int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static final int THREAD_PRIORITY_AUDIO = -16;
    public static final int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static final int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static final int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static final int THREAD_GROUP_DEFAULT = 0;
    public static final int THREAD_GROUP_BG_NONINTERACTIVE = 1;
    public static final int THREAD_GROUP_FG_BOOST = 2;
    public static final int SIGNAL_QUIT = 3;
    public static final int SIGNAL_KILL = 9;
    public static final int SIGNAL_USR1 = 10;
    public static LocalSocket sZygoteSocket;
    public static DataInputStream sZygoteInputStream;
    public static BufferedWriter sZygoteWriter;
    public static boolean sPreviousZygoteOpenFailed;
    public static final int ZYGOTE_RETRY_MILLIS = 500;
    public static final int PROC_TERM_MASK = 255;
    public static final int PROC_ZERO_TERM = 0;
    public static final int PROC_SPACE_TERM = 32;
    public static final int PROC_TAB_TERM = 9;
    public static final int PROC_COMBINE = 256;
    public static final int PROC_PARENS = 512;
    public static final int PROC_OUT_STRING = 4096;
    public static final int PROC_OUT_LONG = 8192;
    public static final int PROC_OUT_FLOAT = 16384;

    public static int start(final String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, String[] zygoteArgs) {
        if (Process.supportsProcesses()) {
            try {
                return Process.startViaZygote(processClass, niceName, uid, gid, gids, debugFlags, zygoteArgs);
            }
            catch (ZygoteStartFailedEx ex) {
                Log.e(LOG_TAG, "Starting VM process through Zygote failed");
                throw new RuntimeException("Starting VM process through Zygote failed", ex);
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Process.invokeStaticMain(processClass);
            }
        };
        if (niceName != null) {
            new Thread(runnable, niceName).start();
        } else {
            new Thread(runnable).start();
        }
        return 0;
    }

    public static int start(String processClass, int uid, int gid, int[] gids, int debugFlags, String[] zygoteArgs) {
        return Process.start(processClass, "", uid, gid, gids, debugFlags, zygoteArgs);
    }

    public static void invokeStaticMain(String className) {
        Object[] args = new Object[]{new String[0]};
        try {
            Class<?> cl = Class.forName(className);
            cl.getMethod("main", String[].class).invoke(null, args);
        }
        catch (Exception ex) {
            Log.e(LOG_TAG, "Exception invoking static main on " + className, ex);
            throw new RuntimeException(ex);
        }
    }

    public static void openZygoteSocketIfNeeded() throws ZygoteStartFailedEx {
        int retryCount = sPreviousZygoteOpenFailed ? 0 : 10;
        for (int retry = 0; sZygoteSocket == null && retry < retryCount + 1; ++retry) {
            if (retry > 0) {
                try {
                    Log.i("Zygote", "Zygote not up yet, sleeping...");
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            try {
                sZygoteSocket = new LocalSocket();
                sZygoteSocket.connect(new LocalSocketAddress(ZYGOTE_SOCKET, LocalSocketAddress.Namespace.RESERVED));
                sZygoteInputStream = new DataInputStream(sZygoteSocket.getInputStream());
                sZygoteWriter = new BufferedWriter(new OutputStreamWriter(sZygoteSocket.getOutputStream()), 256);
                Log.i("Zygote", "Process: zygote socket opened");
                sPreviousZygoteOpenFailed = false;
                break;
            }
            catch (IOException ex) {
                if (sZygoteSocket != null) {
                    try {
                        sZygoteSocket.close();
                    }
                    catch (IOException ex2) {
                        Log.e(LOG_TAG, "I/O exception on close after exception", ex2);
                    }
                }
                sZygoteSocket = null;
                continue;
            }
        }
        if (sZygoteSocket == null) {
            sPreviousZygoteOpenFailed = true;
            throw new ZygoteStartFailedEx("connect failed");
        }
    }

    public static int zygoteSendArgsAndGetPid(ArrayList<String> args) throws ZygoteStartFailedEx {
        int pid;
        Process.openZygoteSocketIfNeeded();
        try {
            sZygoteWriter.write(Integer.toString(args.size()));
            sZygoteWriter.newLine();
            int sz = args.size();
            for (int i = 0; i < sz; ++i) {
                String arg = args.get(i);
                if (arg.indexOf(10) >= 0) {
                    throw new ZygoteStartFailedEx("embedded newlines not allowed");
                }
                sZygoteWriter.write(arg);
                sZygoteWriter.newLine();
            }
            sZygoteWriter.flush();
            pid = sZygoteInputStream.readInt();
            if (pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
        }
        catch (IOException ex) {
            try {
                if (sZygoteSocket != null) {
                    sZygoteSocket.close();
                }
            }
            catch (IOException ex2) {
                Log.e(LOG_TAG, "I/O exception on routine close", ex2);
            }
            sZygoteSocket = null;
            throw new ZygoteStartFailedEx(ex);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, String[] extraArgs) throws ZygoteStartFailedEx {
        Class<Process> clazz = Process.class;
        synchronized (Process.class) {
            ArrayList<String> argsForZygote = new ArrayList<String>();
            argsForZygote.add("--runtime-init");
            argsForZygote.add("--setuid=" + uid);
            argsForZygote.add("--setgid=" + gid);
            if ((debugFlags & 8) != 0) {
                argsForZygote.add("--enable-safemode");
            }
            if ((debugFlags & 1) != 0) {
                argsForZygote.add("--enable-debugger");
            }
            if ((debugFlags & 2) != 0) {
                argsForZygote.add("--enable-checkjni");
            }
            if ((debugFlags & 4) != 0) {
                argsForZygote.add("--enable-assert");
            }
            if (gids != null && gids.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("--setgroups=");
                int sz = gids.length;
                for (int i = 0; i < sz; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(gids[i]);
                }
                argsForZygote.add(sb.toString());
            }
            if (niceName != null) {
                argsForZygote.add("--nice-name=" + niceName);
            }
            argsForZygote.add(processClass);
            if (extraArgs != null) {
                for (String arg : extraArgs) {
                    argsForZygote.add(arg);
                }
            }
            int pid = Process.zygoteSendArgsAndGetPid(argsForZygote);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            if (pid <= 0) {
                throw new ZygoteStartFailedEx("zygote start failed:" + pid);
            }
            return pid;
        }
    }

    public static long getElapsedCpuTime() {
        return OverrideMethod.invokeL("android.os.Process#getElapsedCpuTime()J", true, null);
    }

    public static int myPid() {
        return OverrideMethod.invokeI("android.os.Process#myPid()I", true, null);
    }

    public static int myTid() {
        return OverrideMethod.invokeI("android.os.Process#myTid()I", true, null);
    }

    public static int myUid() {
        return OverrideMethod.invokeI("android.os.Process#myUid()I", true, null);
    }

    public static int getUidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getUidForName(Ljava/lang/String;)I", true, null);
    }

    public static int getGidForName(String string2) {
        return OverrideMethod.invokeI("android.os.Process#getGidForName(Ljava/lang/String;)I", true, null);
    }

    public static int getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    public static void setThreadPriority(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(II)V", true, null);
    }

    public static void setCanSelfBackground(boolean bl) {
        OverrideMethod.invokeV("android.os.Process#setCanSelfBackground(Z)V", true, null);
    }

    public static void setThreadGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadGroup(II)V", true, null);
    }

    public static void setProcessGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setProcessGroup(II)V", true, null);
    }

    public static void setThreadPriority(int n) throws IllegalArgumentException, SecurityException {
        OverrideMethod.invokeV("android.os.Process#setThreadPriority(I)V", true, null);
    }

    public static int getThreadPriority(int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.os.Process#getThreadPriority(I)I", true, null);
    }

    public static boolean supportsProcesses() {
        return OverrideMethod.invokeI("android.os.Process#supportsProcesses()Z", true, null) != 0;
    }

    public static boolean setOomAdj(int n, int n2) {
        return OverrideMethod.invokeI("android.os.Process#setOomAdj(II)Z", true, null) != 0;
    }

    public static void setArgV0(String string2) {
        OverrideMethod.invokeV("android.os.Process#setArgV0(Ljava/lang/String;)V", true, null);
    }

    public static void killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    public static int setUid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setUid(I)I", true, null);
    }

    public static int setGid(int n) {
        return OverrideMethod.invokeI("android.os.Process#setGid(I)I", true, null);
    }

    public static void sendSignal(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignal(II)V", true, null);
    }

    public static void killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    public static void sendSignalQuiet(int n, int n2) {
        OverrideMethod.invokeV("android.os.Process#sendSignalQuiet(II)V", true, null);
    }

    public static long getFreeMemory() {
        return OverrideMethod.invokeL("android.os.Process#getFreeMemory()J", true, null);
    }

    public static void readProcLines(String string2, String[] stringArray, long[] lArray) {
        OverrideMethod.invokeV("android.os.Process#readProcLines(Ljava/lang/String;[Ljava/lang/String;[J)V", true, null);
    }

    public static int[] getPids(String string2, int[] nArray) {
        return (int[])OverrideMethod.invokeA("android.os.Process#getPids(Ljava/lang/String;[I)[I", true, null);
    }

    public static boolean readProcFile(String string2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#readProcFile(Ljava/lang/String;[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    public static boolean parseProcLine(byte[] byArray, int n, int n2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return OverrideMethod.invokeI("android.os.Process#parseProcLine([BII[I[Ljava/lang/String;[J[F)Z", true, null) != 0;
    }

    public static long getPss(int n) {
        return OverrideMethod.invokeL("android.os.Process#getPss(I)J", true, null);
    }
}

