/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import java.lang.ref.WeakReference;

public class Registrant {
    public WeakReference refH;
    public int what;
    public Object userObj;

    public Registrant(Handler h, int what, Object obj) {
        this.refH = new WeakReference<Handler>(h);
        this.what = what;
        this.userObj = obj;
    }

    public void clear() {
        this.refH = null;
        this.userObj = null;
    }

    public void notifyRegistrant() {
        this.internalNotifyRegistrant(null, null);
    }

    public void notifyResult(Object result) {
        this.internalNotifyRegistrant(result, null);
    }

    public void notifyException(Throwable exception) {
        this.internalNotifyRegistrant(null, exception);
    }

    public void notifyRegistrant(AsyncResult ar) {
        this.internalNotifyRegistrant(ar.result, ar.exception);
    }

    public void internalNotifyRegistrant(Object result, Throwable exception) {
        Handler h = this.getHandler();
        if (h == null) {
            this.clear();
        } else {
            Message msg = Message.obtain();
            msg.what = this.what;
            msg.obj = new AsyncResult(this.userObj, result, exception);
            h.sendMessage(msg);
        }
    }

    public Message messageForRegistrant() {
        Handler h = this.getHandler();
        if (h == null) {
            this.clear();
            return null;
        }
        Message msg = h.obtainMessage();
        msg.what = this.what;
        msg.obj = this.userObj;
        return msg;
    }

    public Handler getHandler() {
        if (this.refH == null) {
            return null;
        }
        return (Handler)this.refH.get();
    }
}

