/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.text.TextUtils;
import android.text.format.Time;
import com.android.tools.layoutlib.create.OverrideMethod;

public class EventRecurrence {
    public static final int SECONDLY = 1;
    public static final int MINUTELY = 2;
    public static final int HOURLY = 3;
    public static final int DAILY = 4;
    public static final int WEEKLY = 5;
    public static final int MONTHLY = 6;
    public static final int YEARLY = 7;
    public static final int SU = 65536;
    public static final int MO = 131072;
    public static final int TU = 262144;
    public static final int WE = 524288;
    public static final int TH = 0x100000;
    public static final int FR = 0x200000;
    public static final int SA = 0x400000;
    public Time startDate;
    public int freq;
    public String until;
    public int count;
    public int interval;
    public int wkst = 131072;
    public int[] bysecond;
    public int bysecondCount;
    public int[] byminute;
    public int byminuteCount;
    public int[] byhour;
    public int byhourCount;
    public int[] byday;
    public int[] bydayNum;
    public int bydayCount;
    public int[] bymonthday;
    public int bymonthdayCount;
    public int[] byyearday;
    public int byyeardayCount;
    public int[] byweekno;
    public int byweeknoCount;
    public int[] bymonth;
    public int bymonthCount;
    public int[] bysetpos;
    public int bysetposCount;

    public void parse(String string2) {
        OverrideMethod.invokeV("android.pim.EventRecurrence#parse(Ljava/lang/String;)V", true, this);
    }

    public void setStartDate(Time date) {
        this.startDate = date;
    }

    public static int calendarDay2Day(int day) {
        switch (day) {
            case 1: {
                return 65536;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 262144;
            }
            case 4: {
                return 524288;
            }
            case 5: {
                return 0x100000;
            }
            case 6: {
                return 0x200000;
            }
            case 7: {
                return 0x400000;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int timeDay2Day(int day) {
        switch (day) {
            case 0: {
                return 65536;
            }
            case 1: {
                return 131072;
            }
            case 2: {
                return 262144;
            }
            case 3: {
                return 524288;
            }
            case 4: {
                return 0x100000;
            }
            case 5: {
                return 0x200000;
            }
            case 6: {
                return 0x400000;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int day2TimeDay(int day) {
        switch (day) {
            case 65536: {
                return 0;
            }
            case 131072: {
                return 1;
            }
            case 262144: {
                return 2;
            }
            case 524288: {
                return 3;
            }
            case 0x100000: {
                return 4;
            }
            case 0x200000: {
                return 5;
            }
            case 0x400000: {
                return 6;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int day2CalendarDay(int day) {
        switch (day) {
            case 65536: {
                return 1;
            }
            case 131072: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 524288: {
                return 4;
            }
            case 0x100000: {
                return 5;
            }
            case 0x200000: {
                return 6;
            }
            case 0x400000: {
                return 7;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static String day2String(int day) {
        switch (day) {
            case 65536: {
                return "SU";
            }
            case 131072: {
                return "MO";
            }
            case 262144: {
                return "TU";
            }
            case 524288: {
                return "WE";
            }
            case 0x100000: {
                return "TH";
            }
            case 0x200000: {
                return "FR";
            }
            case 0x400000: {
                return "SA";
            }
        }
        throw new IllegalArgumentException("bad day argument: " + day);
    }

    public static void appendNumbers(StringBuilder s, String label, int count, int[] values) {
        if (count > 0) {
            s.append(label);
            --count;
            for (int i = 0; i < count; ++i) {
                s.append(values[i]);
                s.append(",");
            }
            s.append(values[count]);
        }
    }

    public void appendByDay(StringBuilder s, int i) {
        int n = this.bydayNum[i];
        if (n != 0) {
            s.append(n);
        }
        String str = EventRecurrence.day2String(this.byday[i]);
        s.append(str);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("FREQ=");
        switch (this.freq) {
            case 1: {
                s.append("SECONDLY");
                break;
            }
            case 2: {
                s.append("MINUTELY");
                break;
            }
            case 3: {
                s.append("HOURLY");
                break;
            }
            case 4: {
                s.append("DAILY");
                break;
            }
            case 5: {
                s.append("WEEKLY");
                break;
            }
            case 6: {
                s.append("MONTHLY");
                break;
            }
            case 7: {
                s.append("YEARLY");
            }
        }
        if (!TextUtils.isEmpty(this.until)) {
            s.append(";UNTIL=");
            s.append(this.until);
        }
        if (this.count != 0) {
            s.append(";COUNT=");
            s.append(this.count);
        }
        if (this.interval != 0) {
            s.append(";INTERVAL=");
            s.append(this.interval);
        }
        if (this.wkst != 0) {
            s.append(";WKST=");
            s.append(EventRecurrence.day2String(this.wkst));
        }
        EventRecurrence.appendNumbers(s, ";BYSECOND=", this.bysecondCount, this.bysecond);
        EventRecurrence.appendNumbers(s, ";BYMINUTE=", this.byminuteCount, this.byminute);
        EventRecurrence.appendNumbers(s, ";BYSECOND=", this.byhourCount, this.byhour);
        int count = this.bydayCount;
        if (count > 0) {
            s.append(";BYDAY=");
            --count;
            for (int i = 0; i < count; ++i) {
                this.appendByDay(s, i);
                s.append(",");
            }
            this.appendByDay(s, count);
        }
        EventRecurrence.appendNumbers(s, ";BYMONTHDAY=", this.bymonthdayCount, this.bymonthday);
        EventRecurrence.appendNumbers(s, ";BYYEARDAY=", this.byyeardayCount, this.byyearday);
        EventRecurrence.appendNumbers(s, ";BYWEEKNO=", this.byweeknoCount, this.byweekno);
        EventRecurrence.appendNumbers(s, ";BYMONTH=", this.bymonthCount, this.bymonth);
        EventRecurrence.appendNumbers(s, ";BYSETPOS=", this.bysetposCount, this.bysetpos);
        return s.toString();
    }

    public boolean repeatsOnEveryWeekDay() {
        if (this.freq != 5) {
            return false;
        }
        int count = this.bydayCount;
        if (count != 5) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            int day = this.byday[i];
            if (day != 65536 && day != 0x400000) continue;
            return false;
        }
        return true;
    }

    public boolean repeatsMonthlyOnDayCount() {
        if (this.freq != 6) {
            return false;
        }
        return this.bydayCount == 1 && this.bymonthdayCount == 0;
    }

    public static class InvalidFormatException
    extends RuntimeException {
        public InvalidFormatException(String s) {
            super(s);
        }
    }
}

