/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.view.MotionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTracker
implements Poolable<VelocityTracker> {
    public static final String TAG = "VelocityTracker";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public static final int NUM_PAST = 10;
    public static final int MAX_AGE_MILLISECONDS = 200;
    public static final int POINTER_POOL_CAPACITY = 20;
    public static final Pool<VelocityTracker> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<VelocityTracker>(){

        @Override
        public VelocityTracker newInstance() {
            return new VelocityTracker(null);
        }

        @Override
        public void onAcquired(VelocityTracker element) {
        }

        @Override
        public void onReleased(VelocityTracker element) {
            element.clear();
        }
    }, 2));
    public static Pointer sRecycledPointerListHead;
    public static int sRecycledPointerCount;
    public Pointer mPointerListHead;
    public int mLastTouchIndex;
    public int mGeneration;
    public VelocityTracker mNext;

    public static VelocityTracker obtain() {
        return sPool.acquire();
    }

    public void recycle() {
        sPool.release(this);
    }

    @Override
    public void setNextPoolable(VelocityTracker element) {
        this.mNext = element;
    }

    @Override
    public VelocityTracker getNextPoolable() {
        return this.mNext;
    }

    public VelocityTracker() {
        this.clear();
    }

    public void clear() {
        VelocityTracker.releasePointerList(this.mPointerListHead);
        this.mPointerListHead = null;
        this.mLastTouchIndex = 0;
    }

    public void addMovement(MotionEvent ev) {
        int historySize = ev.getHistorySize();
        int pointerCount = ev.getPointerCount();
        int lastTouchIndex = this.mLastTouchIndex;
        int nextTouchIndex = (lastTouchIndex + 1) % 10;
        int finalTouchIndex = (nextTouchIndex + historySize) % 10;
        int generation = this.mGeneration++;
        this.mLastTouchIndex = finalTouchIndex;
        Pointer previousPointer = null;
        for (int i = 0; i < pointerCount; ++i) {
            Pointer pointer;
            block13: {
                Pointer nextPointer;
                int pointerId = ev.getPointerId(i);
                if (previousPointer == null || pointerId < previousPointer.id) {
                    previousPointer = null;
                    nextPointer = this.mPointerListHead;
                } else {
                    nextPointer = previousPointer.next;
                }
                while (nextPointer != null) {
                    int nextPointerId = nextPointer.id;
                    if (nextPointerId == pointerId) {
                        pointer = nextPointer;
                        break block13;
                    }
                    if (nextPointerId >= pointerId) break;
                    nextPointer = nextPointer.next;
                }
                pointer = VelocityTracker.obtainPointer();
                pointer.id = pointerId;
                pointer.pastTime[lastTouchIndex] = Long.MIN_VALUE;
                pointer.next = nextPointer;
                if (previousPointer == null) {
                    this.mPointerListHead = pointer;
                } else {
                    previousPointer.next = pointer;
                }
            }
            pointer.generation = generation;
            previousPointer = pointer;
            float[] pastX = pointer.pastX;
            float[] pastY = pointer.pastY;
            long[] pastTime = pointer.pastTime;
            for (int j = 0; j < historySize; ++j) {
                int touchIndex = (nextTouchIndex + j) % 10;
                pastX[touchIndex] = ev.getHistoricalX(i, j);
                pastY[touchIndex] = ev.getHistoricalY(i, j);
                pastTime[touchIndex] = ev.getHistoricalEventTime(j);
            }
            pastX[finalTouchIndex] = ev.getX(i);
            pastY[finalTouchIndex] = ev.getY(i);
            pastTime[finalTouchIndex] = ev.getEventTime();
        }
        previousPointer = null;
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            Pointer nextPointer = pointer.next;
            if (pointer.generation != generation) {
                if (previousPointer == null) {
                    this.mPointerListHead = nextPointer;
                } else {
                    previousPointer.next = nextPointer;
                }
                VelocityTracker.releasePointer(pointer);
            } else {
                previousPointer = pointer;
            }
            pointer = nextPointer;
        }
    }

    public void computeCurrentVelocity(int units) {
        this.computeCurrentVelocity(units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        int lastTouchIndex = this.mLastTouchIndex;
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            int nextOldestTouchIndex;
            long nextOldestTime;
            int numTouches;
            long[] pastTime = pointer.pastTime;
            int oldestTouchIndex = lastTouchIndex;
            long minTime = pastTime[lastTouchIndex] - 200L;
            for (numTouches = 1; numTouches < 10 && (nextOldestTime = pastTime[nextOldestTouchIndex = (oldestTouchIndex + 10 - 1) % 10]) >= minTime; ++numTouches) {
                oldestTouchIndex = nextOldestTouchIndex;
            }
            if (numTouches > 3) {
                --numTouches;
            }
            float[] pastX = pointer.pastX;
            float[] pastY = pointer.pastY;
            float oldestX = pastX[oldestTouchIndex];
            float oldestY = pastY[oldestTouchIndex];
            long oldestTime = pastTime[oldestTouchIndex];
            float accumX = 0.0f;
            float accumY = 0.0f;
            for (int i = 1; i < numTouches; ++i) {
                int touchIndex = (oldestTouchIndex + i) % 10;
                int duration = (int)(pastTime[touchIndex] - oldestTime);
                if (duration == 0) continue;
                float delta = pastX[touchIndex] - oldestX;
                float velocity = delta / (float)duration * (float)units;
                accumX = accumX == 0.0f ? velocity : (accumX + velocity) * 0.5f;
                delta = pastY[touchIndex] - oldestY;
                velocity = delta / (float)duration * (float)units;
                accumY = accumY == 0.0f ? velocity : (accumY + velocity) * 0.5f;
            }
            if (accumX < -maxVelocity) {
                accumX = -maxVelocity;
            } else if (accumX > maxVelocity) {
                accumX = maxVelocity;
            }
            if (accumY < -maxVelocity) {
                accumY = -maxVelocity;
            } else if (accumY > maxVelocity) {
                accumY = maxVelocity;
            }
            pointer.xVelocity = accumX;
            pointer.yVelocity = accumY;
            pointer = pointer.next;
        }
    }

    public float getXVelocity() {
        Pointer pointer = this.getPointer(0);
        return pointer != null ? pointer.xVelocity : 0.0f;
    }

    public float getYVelocity() {
        Pointer pointer = this.getPointer(0);
        return pointer != null ? pointer.yVelocity : 0.0f;
    }

    public float getXVelocity(int id2) {
        Pointer pointer = this.getPointer(id2);
        return pointer != null ? pointer.xVelocity : 0.0f;
    }

    public float getYVelocity(int id2) {
        Pointer pointer = this.getPointer(id2);
        return pointer != null ? pointer.yVelocity : 0.0f;
    }

    public Pointer getPointer(int id2) {
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            if (pointer.id == id2) {
                return pointer;
            }
            pointer = pointer.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pointer obtainPointer() {
        Pool<VelocityTracker> pool = sPool;
        synchronized (pool) {
            if (sRecycledPointerCount != 0) {
                Pointer element = sRecycledPointerListHead;
                --sRecycledPointerCount;
                sRecycledPointerListHead = element.next;
                element.next = null;
                return element;
            }
        }
        return new Pointer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasePointer(Pointer pointer) {
        Pool<VelocityTracker> pool = sPool;
        synchronized (pool) {
            if (sRecycledPointerCount < 20) {
                pointer.next = sRecycledPointerListHead;
                ++sRecycledPointerCount;
                sRecycledPointerListHead = pointer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasePointerList(Pointer pointer) {
        if (pointer != null) {
            Pool<VelocityTracker> pool = sPool;
            synchronized (pool) {
                Pointer next;
                int count = sRecycledPointerCount;
                if (count >= 20) {
                    return;
                }
                Pointer tail = pointer;
                while (++count < 20 && (next = tail.next) != null) {
                    tail = next;
                }
                tail.next = sRecycledPointerListHead;
                sRecycledPointerCount = count;
                sRecycledPointerListHead = pointer;
            }
        }
    }

    public /* synthetic */ VelocityTracker(1 x0) {
        this();
    }

    public static class Pointer {
        public Pointer next;
        public int id;
        public float xVelocity;
        public float yVelocity;
        public final float[] pastX = new float[10];
        public final float[] pastY = new float[10];
        public final long[] pastTime = new long[10];
        public int generation;

        public Pointer() {
        }

        public /* synthetic */ Pointer(1 x0) {
            this();
        }
    }
}

