/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;

public abstract class WindowOrientationListener {
    public static final String TAG = "WindowOrientationListener";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public SensorManager mSensorManager;
    public boolean mEnabled = false;
    public int mRate;
    public Sensor mSensor;
    public SensorEventListenerImpl mSensorEventListener;

    public WindowOrientationListener(Context context) {
        this(context, 3);
    }

    public WindowOrientationListener(Context context, int rate) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    public void enable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    public void disable() {
        if (this.mSensor == null) {
            Log.w(TAG, "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    public void setAllow180Rotation(boolean allowed) {
        if (this.mSensorEventListener != null) {
            this.mSensorEventListener.setAllow180Rotation(allowed);
        }
    }

    public int getCurrentRotation(int lastRotation) {
        if (this.mEnabled) {
            return this.mSensorEventListener.getCurrentRotation(lastRotation);
        }
        return lastRotation;
    }

    public boolean canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onOrientationChanged(int var1);

    public static class SensorEventListenerImpl
    implements SensorEventListener {
        public static final float RADIANS_TO_DEGREES = 57.29578f;
        public static final int _DATA_X = 0;
        public static final int _DATA_Y = 1;
        public static final int _DATA_Z = 2;
        public static final int ROTATION_0 = 0;
        public static final int ROTATION_90 = 1;
        public static final int ROTATION_270 = 2;
        public static final int ROTATION_180 = 3;
        public static final int[] INTERNAL_TO_SURFACE_ROTATION = new int[]{0, 1, 3, 2};
        public static final int[] SURFACE_TO_INTERNAL_ROTATION = new int[]{0, 1, 3, 2};
        public static final int[][][] THRESHOLDS = new int[][][]{new int[][]{{60, 180}, {180, 300}}, new int[][]{{0, 30}, {195, 315}, {315, 360}}, new int[][]{{0, 45}, {45, 165}, {330, 360}}, new int[][]{{0, 45}, {45, 135}, {135, 225}, {225, 315}, {315, 360}}};
        public static final int[][] ROTATE_TO = new int[][]{{1, 2}, {0, 2, 0}, {0, 1, 0}, {0, 1, 0, 2, 0}};
        public static final int[][][] THRESHOLDS_WITH_180 = new int[][][]{new int[][]{{60, 165}, {165, 195}, {195, 300}}, new int[][]{{0, 30}, {165, 195}, {195, 315}, {315, 360}}, new int[][]{{0, 45}, {45, 165}, {165, 195}, {330, 360}}, new int[][]{{0, 45}, {45, 135}, {225, 315}, {315, 360}}};
        public static final int[][] ROTATE_TO_WITH_180 = new int[][]{{1, 3, 2}, {0, 3, 1, 0}, {0, 2, 3, 0}, {0, 1, 2, 0}};
        public static final int MAX_TILT = 75;
        public static final int[] MAX_TRANSITION_TILT = new int[]{75, 65, 65, 40};
        public static final int PARTIAL_TILT = 50;
        public static final float MAX_DEVIATION_FROM_GRAVITY = 1.5f;
        public static final float MIN_ABS_ACCELERATION = 1.5f;
        public static final int SAMPLING_PERIOD_MS = 200;
        public static final int DEFAULT_TIME_CONSTANT_MS = 100;
        public static final int TILTED_TIME_CONSTANT_MS = 500;
        public static final int ACCELERATING_TIME_CONSTANT_MS = 2000;
        public static final float DEFAULT_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(100);
        public static final float TILTED_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(500);
        public static final float ACCELERATING_LOWPASS_ALPHA = SensorEventListenerImpl.computeLowpassAlpha(2000);
        public boolean mAllow180Rotation = false;
        public WindowOrientationListener mOrientationListener;
        public int mRotation = 0;
        public float mTiltAngle = 0.0f;
        public float mOrientationAngle = 0.0f;
        public int mAccelerationDistrust = 0;
        public int mTiltDistrust = 0;

        public SensorEventListenerImpl(WindowOrientationListener orientationListener) {
            this.mOrientationListener = orientationListener;
        }

        public static float computeLowpassAlpha(int timeConstantMs) {
            return 200.0f / (float)(timeConstantMs + 200);
        }

        public void setAllow180Rotation(boolean allowed) {
            this.mAllow180Rotation = allowed;
        }

        public int getCurrentRotation(int lastRotation) {
            if (this.mTiltDistrust > 0) {
                this.mRotation = SURFACE_TO_INTERNAL_ROTATION[lastRotation];
            }
            return INTERNAL_TO_SURFACE_ROTATION[this.mRotation];
        }

        public void calculateNewRotation(float orientation, float tiltAngle) {
            int rotation;
            boolean allow180Rotation = this.mAllow180Rotation;
            int[][] thresholdRanges = allow180Rotation ? THRESHOLDS_WITH_180[this.mRotation] : THRESHOLDS[this.mRotation];
            int row = -1;
            for (int i = 0; i < thresholdRanges.length; ++i) {
                if (!(orientation >= (float)thresholdRanges[i][0]) || !(orientation < (float)thresholdRanges[i][1])) continue;
                row = i;
                break;
            }
            if (row == -1) {
                return;
            }
            int n = rotation = allow180Rotation ? ROTATE_TO_WITH_180[this.mRotation][row] : ROTATE_TO[this.mRotation][row];
            if (tiltAngle > (float)MAX_TRANSITION_TILT[rotation]) {
                return;
            }
            this.mRotation = rotation;
            this.mOrientationListener.onOrientationChanged(INTERNAL_TO_SURFACE_ROTATION[this.mRotation]);
        }

        public float lowpassFilter(float newValue, float oldValue, float alpha) {
            return alpha * newValue + (1.0f - alpha) * oldValue;
        }

        public float vectorMagnitude(float x, float y, float z) {
            return (float)Math.sqrt(x * x + y * y + z * z);
        }

        public float tiltAngle(float z, float magnitude) {
            return (float)Math.asin(z / magnitude) * 57.29578f;
        }

        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            float magnitude = this.vectorMagnitude(x, y, z);
            float deviation = Math.abs(magnitude - 9.80665f);
            this.handleAccelerationDistrust(deviation);
            if (magnitude < 1.5f) {
                return;
            }
            float alpha = 1.0f;
            if (this.mAccelerationDistrust > 0) {
                alpha = ACCELERATING_LOWPASS_ALPHA;
            }
            float newTiltAngle = this.tiltAngle(z, magnitude);
            this.mTiltAngle = this.lowpassFilter(newTiltAngle, this.mTiltAngle, alpha);
            float absoluteTilt = Math.abs(this.mTiltAngle);
            this.checkFullyTilted(absoluteTilt);
            if (this.mTiltDistrust > 0) {
                return;
            }
            float newOrientationAngle = this.computeNewOrientation(x, y);
            this.filterOrientation(absoluteTilt, newOrientationAngle);
            this.calculateNewRotation(this.mOrientationAngle, absoluteTilt);
        }

        public void handleAccelerationDistrust(float deviation) {
            if (deviation > 1.5f) {
                if (this.mAccelerationDistrust < 5) {
                    ++this.mAccelerationDistrust;
                }
            } else if (this.mAccelerationDistrust > 0) {
                --this.mAccelerationDistrust;
            }
        }

        public void checkFullyTilted(float absoluteTilt) {
            if (absoluteTilt > 75.0f) {
                this.mOrientationAngle = this.mRotation == 0 ? 0.0f : (this.mRotation == 1 ? 90.0f : 270.0f);
                if (this.mTiltDistrust < 3) {
                    this.mTiltDistrust = 3;
                }
            } else if (this.mTiltDistrust > 0) {
                --this.mTiltDistrust;
            }
        }

        public float computeNewOrientation(float x, float y) {
            float orientationAngle = (float)(-Math.atan2(-x, y)) * 57.29578f;
            if (orientationAngle < 0.0f) {
                orientationAngle += 360.0f;
            }
            return orientationAngle;
        }

        public void filterOrientation(float absoluteTilt, float orientationAngle) {
            float alpha = DEFAULT_LOWPASS_ALPHA;
            if (this.mAccelerationDistrust > 1) {
                alpha = ACCELERATING_LOWPASS_ALPHA;
            } else if (absoluteTilt > 50.0f || this.mAccelerationDistrust == 1) {
                alpha = TILTED_LOWPASS_ALPHA;
            }
            float deltaOrientation = orientationAngle - this.mOrientationAngle;
            if (deltaOrientation > 180.0f) {
                orientationAngle -= 360.0f;
            } else if (deltaOrientation < -180.0f) {
                orientationAngle += 360.0f;
            }
            this.mOrientationAngle = this.lowpassFilter(orientationAngle, this.mOrientationAngle, alpha);
            if (this.mOrientationAngle > 360.0f) {
                this.mOrientationAngle -= 360.0f;
            } else if (this.mOrientationAngle < 0.0f) {
                this.mOrientationAngle += 360.0f;
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

