/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewRoot;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view._Original_SurfaceView$1;
import android.view._Original_SurfaceView$2;
import android.view._Original_SurfaceView$3;
import com.android.internal.view.BaseIWindow;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class _Original_SurfaceView
extends View {
    public static final String TAG = "SurfaceView";
    public static final boolean DEBUG = false;
    public static final boolean localLOGV = false;
    public final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    public final int[] mLocation = new int[2];
    public final ReentrantLock mSurfaceLock = new ReentrantLock();
    public final Surface mSurface = new Surface();
    public boolean mDrawingStopped = true;
    public final WindowManager.LayoutParams mLayout = new WindowManager.LayoutParams();
    public IWindowSession mSession;
    public MyWindow mWindow;
    public final Rect mVisibleInsets = new Rect();
    public final Rect mWinFrame = new Rect();
    public final Rect mContentInsets = new Rect();
    public final Configuration mConfiguration = new Configuration();
    public static final int KEEP_SCREEN_ON_MSG = 1;
    public static final int GET_NEW_SURFACE_MSG = 2;
    public static final int UPDATE_WINDOW_MSG = 3;
    public int mWindowType = 1001;
    public boolean mIsCreating = false;
    public final Handler mHandler = new _Original_SurfaceView$1(this);
    public final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = new _Original_SurfaceView$2(this);
    public boolean mRequestedVisible = false;
    public boolean mWindowVisibility = false;
    public boolean mViewVisibility = false;
    public int mRequestedWidth = -1;
    public int mRequestedHeight = -1;
    public int mRequestedFormat = 4;
    public int mRequestedType = -1;
    public boolean mHaveFrame = false;
    public boolean mDestroyReportNeeded = false;
    public boolean mNewSurfaceNeeded = false;
    public long mLastLockTime = 0L;
    public boolean mVisible = false;
    public int mLeft = -1;
    public int mTop = -1;
    public int mWidth = -1;
    public int mHeight = -1;
    public int mFormat = -1;
    public int mType = -1;
    public final Rect mSurfaceFrame = new Rect();
    public int mLastSurfaceWidth = -1;
    public int mLastSurfaceHeight = -1;
    public boolean mUpdateWindowNeeded;
    public boolean mReportDrawNeeded;
    public CompatibilityInfo.Translator mTranslator;
    public SurfaceHolder mSurfaceHolder = new _Original_SurfaceView$3(this);

    public _Original_SurfaceView(Context context) {
        super(context);
        this.init();
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void init() {
        this.setWillNotDraw(true);
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mParent.requestTransparentRegion(this);
        this.mSession = this.getWindowSession();
        this.mLayout.token = this.getWindowToken();
        this.mLayout.setTitle(TAG);
        this.mViewVisibility = this.getVisibility() == 0;
        this.getViewTreeObserver().addOnScrollChangedListener(this.mScrollChangedListener);
    }

    public void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.mRequestedVisible = this.mWindowVisibility && this.mViewVisibility;
        this.updateWindow(false, false);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        this.mRequestedVisible = this.mWindowVisibility && this.mViewVisibility;
        this.updateWindow(false, false);
    }

    public void showSurface() {
        if (this.mSession != null) {
            this.updateWindow(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSurface() {
        if (this.mSession != null && this.mWindow != null) {
            this.mSurfaceLock.lock();
            try {
                try {
                    DisplayMetrics metrics = this.getResources().getDisplayMetrics();
                    this.mLayout.x = metrics.widthPixels * 3;
                    this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, 0, false, this.mWinFrame, this.mContentInsets, this.mVisibleInsets, this.mConfiguration, this.mSurface);
                }
                catch (RemoteException remoteException) {
                    Object var3_4 = null;
                    this.mSurfaceLock.unlock();
                }
                Object var3_3 = null;
                this.mSurfaceLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.mSurfaceLock.unlock();
                throw throwable;
            }
        }
    }

    public void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnScrollChangedListener(this.mScrollChangedListener);
        this.mRequestedVisible = false;
        this.updateWindow(false, false);
        this.mHaveFrame = false;
        if (this.mWindow != null) {
            try {
                this.mSession.remove(this.mWindow);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mWindow = null;
        }
        this.mSession = null;
        this.mLayout.token = null;
        super.onDetachedFromWindow();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = _Original_SurfaceView.getDefaultSize(this.mRequestedWidth, widthMeasureSpec);
        int height = _Original_SurfaceView.getDefaultSize(this.mRequestedHeight, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateWindow(false, false);
        return result;
    }

    public boolean gatherTransparentRegion(Region region) {
        if (this.mWindowType == 1000) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    public void draw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 0) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    public void dispatchDraw(Canvas canvas) {
        if (this.mWindowType != 1000 && (this.mPrivateFlags & 0x80) == 128) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.mHaveFrame = true;
        this.updateWindow(false, false);
        super.dispatchDraw(canvas);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mWindowType = isMediaOverlay ? 1004 : 1001;
    }

    public void setZOrderOnTop(boolean onTop) {
        if (onTop) {
            this.mWindowType = 1000;
            this.mLayout.flags |= 0x20000;
        } else {
            this.mWindowType = 1001;
            this.mLayout.flags &= 0xFFFDFFFF;
        }
    }

    public void setWindowType(int type) {
        this.mWindowType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateWindow(boolean force, boolean redrawNeeded) {
        boolean typeChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRoot viewRoot = (ViewRoot)this.getRootView().getParent();
        if (viewRoot != null) {
            this.mTranslator = viewRoot.mTranslator;
        }
        Resources res = this.getContext().getResources();
        if (this.mTranslator != null || !res.getCompatibilityInfo().supportsScreen()) {
            this.mSurface.setCompatibleDisplayMetrics(res.getDisplayMetrics(), this.mTranslator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        this.getLocationInWindow(this.mLocation);
        boolean creating = this.mWindow == null;
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible || this.mNewSurfaceNeeded;
        boolean bl = typeChanged = this.mType != this.mRequestedType;
        if (!force && !creating && !formatChanged && !sizeChanged && !visibleChanged && !typeChanged && this.mLeft == this.mLocation[0] && this.mTop == this.mLocation[1] && !this.mUpdateWindowNeeded && !this.mReportDrawNeeded && !redrawNeeded) return;
        try {
            boolean realSizeChanged;
            boolean reportDrawNeeded;
            boolean visible = this.mVisible = this.mRequestedVisible;
            this.mLeft = this.mLocation[0];
            this.mTop = this.mLocation[1];
            this.mWidth = myWidth;
            this.mHeight = myHeight;
            this.mFormat = this.mRequestedFormat;
            this.mType = this.mRequestedType;
            this.mLayout.x = this.mLeft;
            this.mLayout.y = this.mTop;
            this.mLayout.width = this.getWidth();
            this.mLayout.height = this.getHeight();
            if (this.mTranslator != null) {
                this.mTranslator.translateLayoutParamsInAppWindowToScreen(this.mLayout);
            }
            this.mLayout.format = this.mRequestedFormat;
            this.mLayout.flags |= 0x4218;
            if (!this.getContext().getResources().getCompatibilityInfo().supportsScreen()) {
                this.mLayout.flags |= 0x20000000;
            }
            this.mLayout.memoryType = this.mRequestedType;
            if (this.mWindow == null) {
                this.mWindow = new MyWindow(this);
                this.mLayout.type = this.mWindowType;
                this.mLayout.gravity = 51;
                this.mSession.addWithoutInputChannel(this.mWindow, this.mLayout, this.mVisible ? 0 : 8, this.mContentInsets);
            }
            if (visibleChanged && (!visible || this.mNewSurfaceNeeded)) {
                this.reportSurfaceDestroyed();
            }
            this.mNewSurfaceNeeded = false;
            this.mSurfaceLock.lock();
            try {
                this.mUpdateWindowNeeded = false;
                reportDrawNeeded = this.mReportDrawNeeded;
                this.mReportDrawNeeded = false;
                this.mDrawingStopped = !visible;
                int relayoutResult = this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, visible ? 0 : 8, false, this.mWinFrame, this.mContentInsets, this.mVisibleInsets, this.mConfiguration, this.mSurface);
                if ((relayoutResult & 2) != 0) {
                    this.mReportDrawNeeded = true;
                }
                this.mSurfaceFrame.left = 0;
                this.mSurfaceFrame.top = 0;
                if (this.mTranslator == null) {
                    this.mSurfaceFrame.right = this.mWinFrame.width();
                    this.mSurfaceFrame.bottom = this.mWinFrame.height();
                } else {
                    float appInvertedScale = this.mTranslator.applicationInvertedScale;
                    this.mSurfaceFrame.right = (int)((float)this.mWinFrame.width() * appInvertedScale + 0.5f);
                    this.mSurfaceFrame.bottom = (int)((float)this.mWinFrame.height() * appInvertedScale + 0.5f);
                }
                int surfaceWidth = this.mSurfaceFrame.right;
                int surfaceHeight = this.mSurfaceFrame.bottom;
                realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
                this.mLastSurfaceWidth = surfaceWidth;
                this.mLastSurfaceHeight = surfaceHeight;
                Object var19_22 = null;
                this.mSurfaceLock.unlock();
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                this.mSurfaceLock.unlock();
                throw throwable;
            }
            try {
                redrawNeeded |= creating | reportDrawNeeded;
                if (visible) {
                    SurfaceHolder.Callback[] callbacks;
                    this.mDestroyReportNeeded = true;
                    ArrayList<SurfaceHolder.Callback> surfaceWidth = this.mCallbacks;
                    synchronized (surfaceWidth) {
                        callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
                        this.mCallbacks.toArray(callbacks);
                    }
                    if (visibleChanged) {
                        this.mIsCreating = true;
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceCreated(this.mSurfaceHolder);
                        }
                    }
                    if (creating || formatChanged || sizeChanged || visibleChanged || realSizeChanged) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                        }
                    }
                    if (redrawNeeded) {
                        for (SurfaceHolder.Callback c : callbacks) {
                            if (!(c instanceof SurfaceHolder.Callback2)) continue;
                            ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                        }
                    }
                } else {
                    this.mSurface.release();
                }
                Object var22_27 = null;
                this.mIsCreating = false;
                if (!redrawNeeded) return;
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                this.mIsCreating = false;
                if (!redrawNeeded) throw throwable;
                this.mSession.finishDrawing(this.mWindow);
                throw throwable;
            }
            this.mSession.finishDrawing(this.mWindow);
            return;
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSurfaceDestroyed() {
        if (this.mDestroyReportNeeded) {
            SurfaceHolder.Callback[] callbacks;
            this.mDestroyReportNeeded = false;
            ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
            synchronized (arrayList) {
                callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
                this.mCallbacks.toArray(callbacks);
            }
            for (SurfaceHolder.Callback c : callbacks) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
        }
        super.onDetachedFromWindow();
    }

    public void handleGetNewSurface() {
        this.mNewSurfaceNeeded = true;
        this.updateWindow(false, false);
    }

    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    public static /* synthetic */ void access$000(_Original_SurfaceView x0, boolean x1, boolean x2) {
        x0.updateWindow(x1, x2);
    }

    public static class MyWindow
    extends BaseIWindow {
        public final WeakReference<_Original_SurfaceView> mSurfaceView;
        public int mCurWidth = -1;
        public int mCurHeight = -1;

        public MyWindow(_Original_SurfaceView surfaceView) {
            this.mSurfaceView = new WeakReference<_Original_SurfaceView>(surfaceView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
            _Original_SurfaceView surfaceView = (_Original_SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                surfaceView.mSurfaceLock.lock();
                try {
                    if (reportDraw) {
                        surfaceView.mUpdateWindowNeeded = true;
                        surfaceView.mReportDrawNeeded = true;
                        surfaceView.mHandler.sendEmptyMessage(3);
                    } else if (surfaceView.mWinFrame.width() != w || surfaceView.mWinFrame.height() != h) {
                        surfaceView.mUpdateWindowNeeded = true;
                        surfaceView.mHandler.sendEmptyMessage(3);
                    }
                    Object var9_8 = null;
                    surfaceView.mSurfaceLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    surfaceView.mSurfaceLock.unlock();
                    throw throwable;
                }
            }
        }

        public void dispatchAppVisibility(boolean visible) {
        }

        public void dispatchGetNewSurface() {
            _Original_SurfaceView surfaceView = (_Original_SurfaceView)this.mSurfaceView.get();
            if (surfaceView != null) {
                Message msg = surfaceView.mHandler.obtainMessage(2);
                surfaceView.mHandler.sendMessage(msg);
            }
        }

        public void windowFocusChanged(boolean hasFocus, boolean touchEnabled) {
            Log.w(_Original_SurfaceView.TAG, "Unexpected focus in surface: focus=" + hasFocus + ", touchEnabled=" + touchEnabled);
        }

        public void executeCommand(String command, String parameters, ParcelFileDescriptor out) {
        }
    }
}

