/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityEvent
implements Parcelable {
    public static final int INVALID_POSITION = -1;
    public static final int MAX_TEXT_LENGTH = 500;
    public static final int TYPE_VIEW_CLICKED = 1;
    public static final int TYPE_VIEW_LONG_CLICKED = 2;
    public static final int TYPE_VIEW_SELECTED = 4;
    public static final int TYPE_VIEW_FOCUSED = 8;
    public static final int TYPE_VIEW_TEXT_CHANGED = 16;
    public static final int TYPE_WINDOW_STATE_CHANGED = 32;
    public static final int TYPE_NOTIFICATION_STATE_CHANGED = 64;
    public static final int TYPES_ALL_MASK = -1;
    public static final int MAX_POOL_SIZE = 2;
    public static final Object mPoolLock = new Object();
    public static AccessibilityEvent sPool;
    public static int sPoolSize;
    public static final int CHECKED = 1;
    public static final int ENABLED = 2;
    public static final int PASSWORD = 4;
    public static final int FULL_SCREEN = 128;
    public AccessibilityEvent mNext;
    public int mEventType;
    public int mBooleanProperties;
    public int mCurrentItemIndex = -1;
    public int mItemCount;
    public int mFromIndex;
    public int mAddedCount;
    public int mRemovedCount;
    public long mEventTime;
    public CharSequence mClassName;
    public CharSequence mPackageName;
    public CharSequence mContentDescription;
    public CharSequence mBeforeText;
    public Parcelable mParcelableData;
    public final List<CharSequence> mText = new ArrayList<CharSequence>();
    public boolean mIsInPool;
    public static final Parcelable.Creator<AccessibilityEvent> CREATOR;

    public boolean isChecked() {
        return this.getBooleanProperty(1);
    }

    public void setChecked(boolean isChecked) {
        this.setBooleanProperty(1, isChecked);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(2);
    }

    public void setEnabled(boolean isEnabled) {
        this.setBooleanProperty(2, isEnabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(4);
    }

    public void setPassword(boolean isPassword) {
        this.setBooleanProperty(4, isPassword);
    }

    public void setFullScreen(boolean isFullScreen) {
        this.setBooleanProperty(128, isFullScreen);
    }

    public boolean isFullScreen() {
        return this.getBooleanProperty(128);
    }

    public int getEventType() {
        return this.mEventType;
    }

    public void setEventType(int eventType) {
        this.mEventType = eventType;
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public void setItemCount(int itemCount) {
        this.mItemCount = itemCount;
    }

    public int getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    public void setCurrentItemIndex(int currentItemIndex) {
        this.mCurrentItemIndex = currentItemIndex;
    }

    public int getFromIndex() {
        return this.mFromIndex;
    }

    public void setFromIndex(int fromIndex) {
        this.mFromIndex = fromIndex;
    }

    public int getAddedCount() {
        return this.mAddedCount;
    }

    public void setAddedCount(int addedCount) {
        this.mAddedCount = addedCount;
    }

    public int getRemovedCount() {
        return this.mRemovedCount;
    }

    public void setRemovedCount(int removedCount) {
        this.mRemovedCount = removedCount;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public void setEventTime(long eventTime) {
        this.mEventTime = eventTime;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.mClassName = className;
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.mPackageName = packageName;
    }

    public List<CharSequence> getText() {
        return this.mText;
    }

    public CharSequence getBeforeText() {
        return this.mBeforeText;
    }

    public void setBeforeText(CharSequence beforeText) {
        this.mBeforeText = beforeText;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
    }

    public Parcelable getParcelableData() {
        return this.mParcelableData;
    }

    public void setParcelableData(Parcelable parcelableData) {
        this.mParcelableData = parcelableData;
    }

    public static AccessibilityEvent obtain(int eventType) {
        AccessibilityEvent event = AccessibilityEvent.obtain();
        event.setEventType(eventType);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityEvent obtain() {
        Object object = mPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityEvent event = sPool;
                sPool = AccessibilityEvent.sPool.mNext;
                --sPoolSize;
                event.mNext = null;
                event.mIsInPool = false;
                return event;
            }
            return new AccessibilityEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mIsInPool) {
            return;
        }
        this.clear();
        Object object = mPoolLock;
        synchronized (object) {
            if (sPoolSize <= 2) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
        }
    }

    public void clear() {
        this.mEventType = 0;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = 0;
        this.mFromIndex = 0;
        this.mAddedCount = 0;
        this.mRemovedCount = 0;
        this.mEventTime = 0L;
        this.mClassName = null;
        this.mPackageName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
    }

    public boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) == property;
    }

    public void setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public void initFromParcel(Parcel parcel) {
        this.mEventType = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mCurrentItemIndex = parcel.readInt();
        this.mItemCount = parcel.readInt();
        this.mFromIndex = parcel.readInt();
        this.mAddedCount = parcel.readInt();
        this.mRemovedCount = parcel.readInt();
        this.mEventTime = parcel.readLong();
        this.mClassName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mBeforeText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mParcelableData = parcel.readParcelable(null);
        parcel.readList(this.mText, null);
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mEventType);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeInt(this.mCurrentItemIndex);
        parcel.writeInt(this.mItemCount);
        parcel.writeInt(this.mFromIndex);
        parcel.writeInt(this.mAddedCount);
        parcel.writeInt(this.mRemovedCount);
        parcel.writeLong(this.mEventTime);
        TextUtils.writeToParcel(this.mClassName, parcel, 0);
        TextUtils.writeToParcel(this.mPackageName, parcel, 0);
        TextUtils.writeToParcel(this.mContentDescription, parcel, 0);
        TextUtils.writeToParcel(this.mBeforeText, parcel, 0);
        parcel.writeParcelable(this.mParcelableData, flags);
        parcel.writeList(this.mText);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("; EventType: " + this.mEventType);
        builder.append("; EventTime: " + this.mEventTime);
        builder.append("; ClassName: " + this.mClassName);
        builder.append("; PackageName: " + this.mPackageName);
        builder.append("; Text: " + this.mText);
        builder.append("; ContentDescription: " + this.mContentDescription);
        builder.append("; ItemCount: " + this.mItemCount);
        builder.append("; CurrentItemIndex: " + this.mCurrentItemIndex);
        builder.append("; IsEnabled: " + this.isEnabled());
        builder.append("; IsPassword: " + this.isPassword());
        builder.append("; IsChecked: " + this.isChecked());
        builder.append("; IsFullScreen: " + this.isFullScreen());
        builder.append("; BeforeText: " + this.mBeforeText);
        builder.append("; FromIndex: " + this.mFromIndex);
        builder.append("; AddedCount: " + this.mAddedCount);
        builder.append("; RemovedCount: " + this.mRemovedCount);
        builder.append("; ParcelableData: " + this.mParcelableData);
        return builder.toString();
    }

    static {
        CREATOR = new Parcelable.Creator<AccessibilityEvent>(){

            @Override
            public AccessibilityEvent createFromParcel(Parcel parcel) {
                AccessibilityEvent event = AccessibilityEvent.obtain();
                event.initFromParcel(parcel);
                return event;
            }

            public AccessibilityEvent[] newArray(int size) {
                return new AccessibilityEvent[size];
            }
        };
    }
}

