/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Transformation;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.Scroller;
import com.android.internal.R;

public class Gallery
extends AbsSpinner
implements GestureDetector.OnGestureListener {
    public static final String TAG = "Gallery";
    public static final boolean localLOGV = false;
    public static final int SCROLL_TO_FLING_UNCERTAINTY_TIMEOUT = 250;
    public int mSpacing = 0;
    public int mAnimationDuration = 400;
    public float mUnselectedAlpha;
    public int mLeftMost;
    public int mRightMost;
    public int mGravity;
    public GestureDetector mGestureDetector;
    public int mDownTouchPosition;
    public View mDownTouchView;
    public FlingRunnable mFlingRunnable = new FlingRunnable();
    public Runnable mDisableSuppressSelectionChangedRunnable = new Runnable(){

        public void run() {
            Gallery.this.mSuppressSelectionChanged = false;
            Gallery.this.selectionChanged();
        }
    };
    public boolean mShouldStopFling;
    public View mSelectedChild;
    public boolean mShouldCallbackDuringFling = true;
    public boolean mShouldCallbackOnUnselectedItemClick = true;
    public boolean mSuppressSelectionChanged;
    public boolean mReceivedInvokeKeyDown;
    public AdapterView.AdapterContextMenuInfo mContextMenuInfo;
    public boolean mIsFirstScroll;

    public Gallery(Context context) {
        this(context, null);
    }

    public Gallery(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010070);
    }

    public Gallery(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int animationDuration;
        this.mGestureDetector = new GestureDetector(context, this);
        this.mGestureDetector.setIsLongpressEnabled(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Gallery, defStyle, 0);
        int index = a.getInt(0, -1);
        if (index >= 0) {
            this.setGravity(index);
        }
        if ((animationDuration = a.getInt(1, -1)) > 0) {
            this.setAnimationDuration(animationDuration);
        }
        int spacing = a.getDimensionPixelOffset(2, 0);
        this.setSpacing(spacing);
        float unselectedAlpha = a.getFloat(3, 0.5f);
        this.setUnselectedAlpha(unselectedAlpha);
        a.recycle();
        this.mGroupFlags |= 0x400;
        this.mGroupFlags |= 0x800;
    }

    public void setCallbackDuringFling(boolean shouldCallback) {
        this.mShouldCallbackDuringFling = shouldCallback;
    }

    public void setCallbackOnUnselectedItemClick(boolean shouldCallback) {
        this.mShouldCallbackOnUnselectedItemClick = shouldCallback;
    }

    public void setAnimationDuration(int animationDurationMillis) {
        this.mAnimationDuration = animationDurationMillis;
    }

    public void setSpacing(int spacing) {
        this.mSpacing = spacing;
    }

    public void setUnselectedAlpha(float unselectedAlpha) {
        this.mUnselectedAlpha = unselectedAlpha;
    }

    public boolean getChildStaticTransformation(View child, Transformation t) {
        t.clear();
        t.setAlpha(child == this.mSelectedChild ? 1.0f : this.mUnselectedAlpha);
        return true;
    }

    public int computeHorizontalScrollExtent() {
        return 1;
    }

    public int computeHorizontalScrollOffset() {
        return this.mSelectedPosition;
    }

    public int computeHorizontalScrollRange() {
        return this.mItemCount;
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    public int getChildHeight(View child) {
        return child.getMeasuredHeight();
    }

    public void trackMotionScroll(int deltaX) {
        if (this.getChildCount() == 0) {
            return;
        }
        boolean toLeft = deltaX < 0;
        int limitedDeltaX = this.getLimitedMotionScrollAmount(toLeft, deltaX);
        if (limitedDeltaX != deltaX) {
            this.mFlingRunnable.endFling(false);
            this.onFinishedMovement();
        }
        this.offsetChildrenLeftAndRight(limitedDeltaX);
        this.detachOffScreenChildren(toLeft);
        if (toLeft) {
            this.fillToGalleryRight();
        } else {
            this.fillToGalleryLeft();
        }
        this.mRecycler.clear();
        this.setSelectionToCenterChild();
        this.invalidate();
    }

    public int getLimitedMotionScrollAmount(boolean motionToLeft, int deltaX) {
        int extremeItemPosition = motionToLeft ? this.mItemCount - 1 : 0;
        View extremeChild = this.getChildAt(extremeItemPosition - this.mFirstPosition);
        if (extremeChild == null) {
            return deltaX;
        }
        int extremeChildCenter = Gallery.getCenterOfView(extremeChild);
        int galleryCenter = this.getCenterOfGallery();
        if (motionToLeft ? extremeChildCenter <= galleryCenter : extremeChildCenter >= galleryCenter) {
            return 0;
        }
        int centerDifference = galleryCenter - extremeChildCenter;
        return motionToLeft ? Math.max(centerDifference, deltaX) : Math.min(centerDifference, deltaX);
    }

    public void offsetChildrenLeftAndRight(int offset) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).offsetLeftAndRight(offset);
        }
    }

    public int getCenterOfGallery() {
        return (this.getWidth() - this.mPaddingLeft - this.mPaddingRight) / 2 + this.mPaddingLeft;
    }

    public static int getCenterOfView(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    public void detachOffScreenChildren(boolean toLeft) {
        int numChildren = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        int start = 0;
        int count = 0;
        if (toLeft) {
            View child;
            int galleryLeft = this.mPaddingLeft;
            for (int i = 0; i < numChildren && (child = this.getChildAt(i)).getRight() < galleryLeft; ++i) {
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
        } else {
            View child;
            int galleryRight = this.getWidth() - this.mPaddingRight;
            for (int i = numChildren - 1; i >= 0 && (child = this.getChildAt(i)).getLeft() > galleryRight; --i) {
                start = i;
                ++count;
                this.mRecycler.put(firstPosition + i, child);
            }
        }
        this.detachViewsFromParent(start, count);
        if (toLeft) {
            this.mFirstPosition += count;
        }
    }

    public void scrollIntoSlots() {
        if (this.getChildCount() == 0 || this.mSelectedChild == null) {
            return;
        }
        int selectedCenter = Gallery.getCenterOfView(this.mSelectedChild);
        int targetCenter = this.getCenterOfGallery();
        int scrollAmount = targetCenter - selectedCenter;
        if (scrollAmount != 0) {
            this.mFlingRunnable.startUsingDistance(scrollAmount);
        } else {
            this.onFinishedMovement();
        }
    }

    public void onFinishedMovement() {
        if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
            super.selectionChanged();
        }
        this.invalidate();
    }

    public void selectionChanged() {
        if (!this.mSuppressSelectionChanged) {
            super.selectionChanged();
        }
    }

    public void setSelectionToCenterChild() {
        int newPos;
        View selView = this.mSelectedChild;
        if (this.mSelectedChild == null) {
            return;
        }
        int galleryCenter = this.getCenterOfGallery();
        if (selView.getLeft() <= galleryCenter && selView.getRight() >= galleryCenter) {
            return;
        }
        int closestEdgeDistance = Integer.MAX_VALUE;
        int newSelectedChildIndex = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getLeft() <= galleryCenter && child.getRight() >= galleryCenter) {
                newSelectedChildIndex = i;
                break;
            }
            int childClosestEdgeDistance = Math.min(Math.abs(child.getLeft() - galleryCenter), Math.abs(child.getRight() - galleryCenter));
            if (childClosestEdgeDistance >= closestEdgeDistance) continue;
            closestEdgeDistance = childClosestEdgeDistance;
            newSelectedChildIndex = i;
        }
        if ((newPos = this.mFirstPosition + newSelectedChildIndex) != this.mSelectedPosition) {
            this.setSelectedPositionInt(newPos);
            this.setNextSelectedPositionInt(newPos);
            this.checkSelectionChanged();
        }
    }

    public void layout(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        this.mRightMost = 0;
        this.mLeftMost = 0;
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddView(this.mSelectedPosition, 0, 0, true);
        int selectedOffset = childrenLeft + childrenWidth / 2 - sel.getWidth() / 2;
        sel.offsetLeftAndRight(selectedOffset);
        this.fillToGalleryRight();
        this.fillToGalleryLeft();
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
        this.updateSelectedItemMetadata();
    }

    public void fillToGalleryLeft() {
        int curRightEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryLeft = this.mPaddingLeft;
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.mRight - this.mLeft - this.mPaddingRight;
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryLeft && curPosition >= 0) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        }
    }

    public void fillToGalleryRight() {
        int curLeftEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryRight = this.mRight - this.mLeft - this.mPaddingRight;
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.mPaddingLeft;
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition < numItems) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
            ++curPosition;
        }
    }

    public View makeAndAddView(int position, int offset, int x, boolean fromLeft) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            int childLeft = child.getLeft();
            this.mRightMost = Math.max(this.mRightMost, childLeft + child.getMeasuredWidth());
            this.mLeftMost = Math.min(this.mLeftMost, childLeft);
            this.setUpChild(child, offset, x, fromLeft);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child, offset, x, fromLeft);
        return child;
    }

    public void setUpChild(View child, int offset, int x, boolean fromLeft) {
        int childRight;
        int childLeft;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp == null) {
            lp = (LayoutParams)this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, fromLeft ? -1 : 0, lp);
        child.setSelected(offset == 0);
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.calculateTop(child, true);
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        if (fromLeft) {
            childLeft = x;
            childRight = childLeft + width;
        } else {
            childLeft = x - width;
            childRight = x;
        }
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    public int calculateTop(View child, boolean duringLayout) {
        int myHeight = duringLayout ? this.mMeasuredHeight : this.getHeight();
        int childHeight = duringLayout ? child.getMeasuredHeight() : child.getHeight();
        int childTop = 0;
        switch (this.mGravity) {
            case 48: {
                childTop = this.mSpinnerPadding.top;
                break;
            }
            case 16: {
                int availableSpace = myHeight - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - childHeight;
                childTop = this.mSpinnerPadding.top + availableSpace / 2;
                break;
            }
            case 80: {
                childTop = myHeight - this.mSpinnerPadding.bottom - childHeight;
            }
        }
        return childTop;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction();
        if (action == 1) {
            this.onUp();
        } else if (action == 3) {
            this.onCancel();
        }
        return retValue;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mDownTouchPosition >= 0) {
            this.scrollToChild(this.mDownTouchPosition - this.mFirstPosition);
            if (this.mShouldCallbackOnUnselectedItemClick || this.mDownTouchPosition == this.mSelectedPosition) {
                this.performItemClick(this.mDownTouchView, this.mDownTouchPosition, this.mAdapter.getItemId(this.mDownTouchPosition));
            }
            return true;
        }
        return false;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mShouldCallbackDuringFling) {
            this.removeCallbacks(this.mDisableSuppressSelectionChangedRunnable);
            if (!this.mSuppressSelectionChanged) {
                this.mSuppressSelectionChanged = true;
            }
        }
        this.mFlingRunnable.startUsingVelocity((int)(-velocityX));
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.mParent.requestDisallowInterceptTouchEvent(true);
        if (!this.mShouldCallbackDuringFling) {
            if (this.mIsFirstScroll) {
                if (!this.mSuppressSelectionChanged) {
                    this.mSuppressSelectionChanged = true;
                }
                this.postDelayed(this.mDisableSuppressSelectionChangedRunnable, 250L);
            }
        } else if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
        }
        this.trackMotionScroll(-1 * (int)distanceX);
        this.mIsFirstScroll = false;
        return true;
    }

    public boolean onDown(MotionEvent e) {
        this.mFlingRunnable.stop(false);
        this.mDownTouchPosition = this.pointToPosition((int)e.getX(), (int)e.getY());
        if (this.mDownTouchPosition >= 0) {
            this.mDownTouchView = this.getChildAt(this.mDownTouchPosition - this.mFirstPosition);
            this.mDownTouchView.setPressed(true);
        }
        this.mIsFirstScroll = true;
        return true;
    }

    public void onUp() {
        if (this.mFlingRunnable.mScroller.isFinished()) {
            this.scrollIntoSlots();
        }
        this.dispatchUnpress();
    }

    public void onCancel() {
        this.onUp();
    }

    public void onLongPress(MotionEvent e) {
        if (this.mDownTouchPosition < 0) {
            return;
        }
        this.performHapticFeedback(0);
        long id2 = this.getItemIdAtPosition(this.mDownTouchPosition);
        this.dispatchLongPress(this.mDownTouchView, this.mDownTouchPosition, id2);
    }

    public void onShowPress(MotionEvent e) {
    }

    public void dispatchPress(View child) {
        if (child != null) {
            child.setPressed(true);
        }
        this.setPressed(true);
    }

    public void dispatchUnpress() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).setPressed(false);
        }
        this.setPressed(false);
    }

    public void dispatchSetSelected(boolean selected) {
    }

    public void dispatchSetPressed(boolean pressed) {
        if (this.mSelectedChild != null) {
            this.mSelectedChild.setPressed(pressed);
        }
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        return this.dispatchLongPress(originalView, longPressPosition, longPressId);
    }

    public boolean showContextMenu() {
        if (this.isPressed() && this.mSelectedPosition >= 0) {
            int index = this.mSelectedPosition - this.mFirstPosition;
            View v = this.getChildAt(index);
            return this.dispatchLongPress(v, this.mSelectedPosition, this.mSelectedRowId);
        }
        return false;
    }

    public boolean dispatchLongPress(View view, int position, long id2) {
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, this.mDownTouchView, this.mDownTouchPosition, id2);
        }
        if (!handled) {
            this.mContextMenuInfo = new AdapterView.AdapterContextMenuInfo(view, position, id2);
            handled = super.showContextMenuForChild(this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return event.dispatch(this, null, null);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                if (this.movePrevious()) {
                    this.playSoundEffect(1);
                }
                return true;
            }
            case 22: {
                if (this.moveNext()) {
                    this.playSoundEffect(3);
                }
                return true;
            }
            case 23: 
            case 66: {
                this.mReceivedInvokeKeyDown = true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (this.mReceivedInvokeKeyDown && this.mItemCount > 0) {
                    this.dispatchPress(this.mSelectedChild);
                    this.postDelayed(new Runnable(){

                        public void run() {
                            Gallery.this.dispatchUnpress();
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                    int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
                    this.performItemClick(this.getChildAt(selectedIndex), this.mSelectedPosition, this.mAdapter.getItemId(this.mSelectedPosition));
                }
                this.mReceivedInvokeKeyDown = false;
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean movePrevious() {
        if (this.mItemCount > 0 && this.mSelectedPosition > 0) {
            this.scrollToChild(this.mSelectedPosition - this.mFirstPosition - 1);
            return true;
        }
        return false;
    }

    public boolean moveNext() {
        if (this.mItemCount > 0 && this.mSelectedPosition < this.mItemCount - 1) {
            this.scrollToChild(this.mSelectedPosition - this.mFirstPosition + 1);
            return true;
        }
        return false;
    }

    public boolean scrollToChild(int childPosition) {
        View child = this.getChildAt(childPosition);
        if (child != null) {
            int distance = this.getCenterOfGallery() - Gallery.getCenterOfView(child);
            this.mFlingRunnable.startUsingDistance(distance);
            return true;
        }
        return false;
    }

    public void setSelectedPositionInt(int position) {
        super.setSelectedPositionInt(position);
        this.updateSelectedItemMetadata();
    }

    public void updateSelectedItemMetadata() {
        View oldSelectedChild = this.mSelectedChild;
        this.mSelectedChild = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        View child = this.mSelectedChild;
        if (child == null) {
            return;
        }
        child.setSelected(true);
        child.setFocusable(true);
        if (this.hasFocus()) {
            child.requestFocus();
        }
        if (oldSelectedChild != null) {
            oldSelectedChild.setSelected(false);
            oldSelectedChild.setFocusable(false);
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getChildDrawingOrder(int childCount, int i) {
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        if (selectedIndex < 0) {
            return i;
        }
        if (i == childCount - 1) {
            return selectedIndex;
        }
        if (i >= selectedIndex) {
            return i + 1;
        }
        return i;
    }

    public void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedChild != null) {
            this.mSelectedChild.requestFocus(direction);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    public class FlingRunnable
    implements Runnable {
        public Scroller mScroller;
        public int mLastFlingX;

        public FlingRunnable() {
            this.mScroller = new Scroller(Gallery.this.getContext());
        }

        public void startCommon() {
            Gallery.this.removeCallbacks(this);
        }

        public void startUsingVelocity(int initialVelocity) {
            int initialX;
            if (initialVelocity == 0) {
                return;
            }
            this.startCommon();
            this.mLastFlingX = initialX = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(initialX, 0, initialVelocity, 0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            Gallery.this.post(this);
        }

        public void startUsingDistance(int distance) {
            if (distance == 0) {
                return;
            }
            this.startCommon();
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, -distance, 0, Gallery.this.mAnimationDuration);
            Gallery.this.post(this);
        }

        public void stop(boolean scrollIntoSlots) {
            Gallery.this.removeCallbacks(this);
            this.endFling(scrollIntoSlots);
        }

        public void endFling(boolean scrollIntoSlots) {
            this.mScroller.forceFinished(true);
            if (scrollIntoSlots) {
                Gallery.this.scrollIntoSlots();
            }
        }

        public void run() {
            if (Gallery.this.mItemCount == 0) {
                this.endFling(true);
                return;
            }
            Gallery.this.mShouldStopFling = false;
            Scroller scroller = this.mScroller;
            boolean more = scroller.computeScrollOffset();
            int x = scroller.getCurrX();
            int delta = this.mLastFlingX - x;
            if (delta > 0) {
                Gallery.this.mDownTouchPosition = Gallery.this.mFirstPosition;
                delta = Math.min(Gallery.this.getWidth() - Gallery.this.mPaddingLeft - Gallery.this.mPaddingRight - 1, delta);
            } else {
                int offsetToLast = Gallery.this.getChildCount() - 1;
                Gallery.this.mDownTouchPosition = Gallery.this.mFirstPosition + offsetToLast;
                delta = Math.max(-(Gallery.this.getWidth() - Gallery.this.mPaddingRight - Gallery.this.mPaddingLeft - 1), delta);
            }
            Gallery.this.trackMotionScroll(delta);
            if (more && !Gallery.this.mShouldStopFling) {
                this.mLastFlingX = x;
                Gallery.this.post(this);
            } else {
                this.endFling(true);
            }
        }
    }
}

