/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.util.Log;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCardApplication;
import com.android.internal.telephony.IccCardStatus;
import com.android.internal.telephony.PhoneBase;

public abstract class IccCard {
    public String mLogTag;
    public boolean mDbg;
    public IccCardStatus mIccCardStatus = null;
    public State mState = null;
    public PhoneBase mPhone;
    public RegistrantList mAbsentRegistrants = new RegistrantList();
    public RegistrantList mPinLockedRegistrants = new RegistrantList();
    public RegistrantList mNetworkLockedRegistrants = new RegistrantList();
    public boolean mDesiredPinLocked;
    public boolean mDesiredFdnEnabled;
    public boolean mIccPinLocked = true;
    public boolean mIccFdnEnabled = false;
    public static final String INTENT_KEY_ICC_STATE = "ss";
    public static final String INTENT_VALUE_ICC_NOT_READY = "NOT_READY";
    public static final String INTENT_VALUE_ICC_ABSENT = "ABSENT";
    public static final String INTENT_VALUE_ICC_LOCKED = "LOCKED";
    public static final String INTENT_VALUE_ICC_READY = "READY";
    public static final String INTENT_VALUE_ICC_IMSI = "IMSI";
    public static final String INTENT_VALUE_ICC_LOADED = "LOADED";
    public static final String INTENT_KEY_LOCKED_REASON = "reason";
    public static final String INTENT_VALUE_LOCKED_ON_PIN = "PIN";
    public static final String INTENT_VALUE_LOCKED_ON_PUK = "PUK";
    public static final String INTENT_VALUE_LOCKED_NETWORK = "NETWORK";
    public static final int EVENT_ICC_LOCKED_OR_ABSENT = 1;
    public static final int EVENT_GET_ICC_STATUS_DONE = 2;
    public static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 3;
    public static final int EVENT_PINPUK_DONE = 4;
    public static final int EVENT_REPOLL_STATUS_DONE = 5;
    public static final int EVENT_ICC_READY = 6;
    public static final int EVENT_QUERY_FACILITY_LOCK_DONE = 7;
    public static final int EVENT_CHANGE_FACILITY_LOCK_DONE = 8;
    public static final int EVENT_CHANGE_ICC_PASSWORD_DONE = 9;
    public static final int EVENT_QUERY_FACILITY_FDN_DONE = 10;
    public static final int EVENT_CHANGE_FACILITY_FDN_DONE = 11;
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            int serviceClassX = 7;
            switch (msg.what) {
                case 3: {
                    IccCard.this.mState = null;
                    IccCard.this.updateStateProperty();
                    IccCard.this.broadcastIccStateChangedIntent(IccCard.INTENT_VALUE_ICC_NOT_READY, null);
                    break;
                }
                case 6: {
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                    IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                    IccCard.this.mPhone.mCM.queryFacilityLock("FD", "", serviceClassX, this.obtainMessage(10));
                    break;
                }
                case 1: {
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(2));
                    IccCard.this.mPhone.mCM.queryFacilityLock("SC", "", serviceClassX, this.obtainMessage(7));
                    break;
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.getIccCardStatusDone(ar);
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    IccCard.this.mPhone.mCM.getIccCardStatus(this.obtainMessage(5, ar.userObj));
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.getIccCardStatusDone(ar);
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 7: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.onQueryFacilityLock(ar);
                    break;
                }
                case 10: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccCard.this.onQueryFdnEnabled(ar);
                    break;
                }
                case 8: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        IccCard.this.mIccPinLocked = IccCard.this.mDesiredPinLocked;
                        if (IccCard.this.mDbg) {
                            IccCard.this.log("EVENT_CHANGE_FACILITY_LOCK_DONE: mIccPinLocked= " + IccCard.this.mIccPinLocked);
                        }
                    } else {
                        Log.e(IccCard.this.mLogTag, "Error change facility lock with exception " + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 11: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        IccCard.this.mIccFdnEnabled = IccCard.this.mDesiredFdnEnabled;
                        if (IccCard.this.mDbg) {
                            IccCard.this.log("EVENT_CHANGE_FACILITY_FDN_DONE: mIccFdnEnabled=" + IccCard.this.mIccFdnEnabled);
                        }
                    } else {
                        Log.e(IccCard.this.mLogTag, "Error change facility fdn with exception " + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                case 9: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        Log.e(IccCard.this.mLogTag, "Error in change sim password with exception" + ar.exception);
                    }
                    AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                    ((Message)ar.userObj).sendToTarget();
                    break;
                }
                default: {
                    Log.e(IccCard.this.mLogTag, "[IccCard] Unknown Event " + msg.what);
                }
            }
        }
    };

    public State getState() {
        if (this.mState == null) {
            switch (this.mPhone.mCM.getRadioState()) {
                case RADIO_OFF: 
                case RADIO_UNAVAILABLE: 
                case SIM_NOT_READY: 
                case RUIM_NOT_READY: {
                    return State.UNKNOWN;
                }
                case SIM_LOCKED_OR_ABSENT: 
                case RUIM_LOCKED_OR_ABSENT: {
                    return State.UNKNOWN;
                }
                case SIM_READY: 
                case RUIM_READY: 
                case NV_READY: {
                    return State.READY;
                }
                case NV_NOT_READY: {
                    return State.ABSENT;
                }
            }
        } else {
            return this.mState;
        }
        Log.e(this.mLogTag, "IccCard.getState(): case should never be reached");
        return State.UNKNOWN;
    }

    public IccCard(PhoneBase phone, String logTag, Boolean dbg) {
        this.mPhone = phone;
        this.mLogTag = logTag;
        this.mDbg = dbg;
    }

    public abstract void dispose();

    public void finalize() {
        if (this.mDbg) {
            Log.d(this.mLogTag, "IccCard finalized");
        }
    }

    public void registerForAbsent(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mAbsentRegistrants.add(r);
        if (this.getState() == State.ABSENT) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForAbsent(Handler h) {
        this.mAbsentRegistrants.remove(h);
    }

    public void registerForNetworkLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkLockedRegistrants.add(r);
        if (this.getState() == State.NETWORK_LOCKED) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkLocked(Handler h) {
        this.mNetworkLockedRegistrants.remove(h);
    }

    public void registerForLocked(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPinLockedRegistrants.add(r);
        if (this.getState().isPinLocked()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForLocked(Handler h) {
        this.mPinLockedRegistrants.remove(h);
    }

    public void supplyPin(String pin, Message onComplete) {
        this.mPhone.mCM.supplyIccPin(pin, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPuk(String puk, String newPin, Message onComplete) {
        this.mPhone.mCM.supplyIccPuk(puk, newPin, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPin2(String pin2, Message onComplete) {
        this.mPhone.mCM.supplyIccPin2(pin2, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyPuk2(String puk2, String newPin2, Message onComplete) {
        this.mPhone.mCM.supplyIccPuk2(puk2, newPin2, this.mHandler.obtainMessage(4, onComplete));
    }

    public void supplyNetworkDepersonalization(String pin, Message onComplete) {
        if (this.mDbg) {
            this.log("Network Despersonalization: " + pin);
        }
        this.mPhone.mCM.supplyNetworkDepersonalization(pin, this.mHandler.obtainMessage(4, onComplete));
    }

    public boolean getIccLockEnabled() {
        return this.mIccPinLocked;
    }

    public boolean getIccFdnEnabled() {
        return this.mIccFdnEnabled;
    }

    public void setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 7;
        this.mDesiredPinLocked = enabled;
        this.mPhone.mCM.setFacilityLock("SC", enabled, password, serviceClassX, this.mHandler.obtainMessage(8, onComplete));
    }

    public void setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        int serviceClassX = 15;
        this.mDesiredFdnEnabled = enabled;
        this.mPhone.mCM.setFacilityLock("FD", enabled, password, serviceClassX, this.mHandler.obtainMessage(11, onComplete));
    }

    public void changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        if (this.mDbg) {
            this.log("Change Pin1 old: " + oldPassword + " new: " + newPassword);
        }
        this.mPhone.mCM.changeIccPin(oldPassword, newPassword, this.mHandler.obtainMessage(9, onComplete));
    }

    public void changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        if (this.mDbg) {
            this.log("Change Pin2 old: " + oldPassword + " new: " + newPassword);
        }
        this.mPhone.mCM.changeIccPin2(oldPassword, newPassword, this.mHandler.obtainMessage(9, onComplete));
    }

    public abstract String getServiceProviderName();

    public void updateStateProperty() {
        this.mPhone.setSystemProperty("gsm.sim.state", this.getState().toString());
    }

    public void getIccCardStatusDone(AsyncResult ar) {
        if (ar.exception != null) {
            Log.e(this.mLogTag, "Error getting ICC status. RIL_REQUEST_GET_ICC_STATUS should never return an error", ar.exception);
            return;
        }
        this.handleIccCardStatus((IccCardStatus)ar.result);
    }

    public void handleIccCardStatus(IccCardStatus newCardStatus) {
        boolean transitionedIntoNetworkLocked;
        State newState;
        State oldState = this.mState;
        this.mIccCardStatus = newCardStatus;
        this.mState = newState = this.getIccCardState();
        this.updateStateProperty();
        boolean transitionedIntoPinLocked = oldState != State.PIN_REQUIRED && newState == State.PIN_REQUIRED || oldState != State.PUK_REQUIRED && newState == State.PUK_REQUIRED;
        boolean transitionedIntoAbsent = oldState != State.ABSENT && newState == State.ABSENT;
        boolean bl = transitionedIntoNetworkLocked = oldState != State.NETWORK_LOCKED && newState == State.NETWORK_LOCKED;
        if (transitionedIntoPinLocked) {
            if (this.mDbg) {
                this.log("Notify SIM pin or puk locked.");
            }
            this.mPinLockedRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, newState == State.PIN_REQUIRED ? INTENT_VALUE_LOCKED_ON_PIN : INTENT_VALUE_LOCKED_ON_PUK);
        } else if (transitionedIntoAbsent) {
            if (this.mDbg) {
                this.log("Notify SIM missing.");
            }
            this.mAbsentRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_ABSENT, null);
        } else if (transitionedIntoNetworkLocked) {
            if (this.mDbg) {
                this.log("Notify SIM network locked.");
            }
            this.mNetworkLockedRegistrants.notifyRegistrants();
            this.broadcastIccStateChangedIntent(INTENT_VALUE_ICC_LOCKED, INTENT_VALUE_LOCKED_NETWORK);
        }
    }

    public void onQueryFdnEnabled(AsyncResult ar) {
        if (ar.exception != null) {
            if (this.mDbg) {
                this.log("Error in querying facility lock:" + ar.exception);
            }
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            boolean bl = this.mIccFdnEnabled = 0 != ints[0];
            if (this.mDbg) {
                this.log("Query facility lock : " + this.mIccFdnEnabled);
            }
        } else {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
        }
    }

    public void onQueryFacilityLock(AsyncResult ar) {
        if (ar.exception != null) {
            if (this.mDbg) {
                this.log("Error in querying facility lock:" + ar.exception);
            }
            return;
        }
        int[] ints = (int[])ar.result;
        if (ints.length != 0) {
            boolean bl = this.mIccPinLocked = 0 != ints[0];
            if (this.mDbg) {
                this.log("Query facility lock : " + this.mIccPinLocked);
            }
        } else {
            Log.e(this.mLogTag, "[IccCard] Bogus facility lock response");
        }
    }

    public void broadcastIccStateChangedIntent(String value, String reason) {
        Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
        intent.addFlags(0x20000000);
        intent.putExtra("phoneName", this.mPhone.getPhoneName());
        intent.putExtra(INTENT_KEY_ICC_STATE, value);
        intent.putExtra(INTENT_KEY_LOCKED_REASON, reason);
        if (this.mDbg) {
            this.log("Broadcasting intent ACTION_SIM_STATE_CHANGED " + value + " reason " + reason);
        }
        ActivityManagerNative.broadcastStickyIntent(intent, "android.permission.READ_PHONE_STATE");
    }

    public State getIccCardState() {
        if (this.mIccCardStatus == null) {
            Log.e(this.mLogTag, "[IccCard] IccCardStatus is null");
            return State.ABSENT;
        }
        if (!this.mIccCardStatus.getCardState().isCardPresent()) {
            return State.ABSENT;
        }
        CommandsInterface.RadioState currentRadioState = this.mPhone.mCM.getRadioState();
        if (currentRadioState == CommandsInterface.RadioState.RADIO_OFF || currentRadioState == CommandsInterface.RadioState.RADIO_UNAVAILABLE || currentRadioState == CommandsInterface.RadioState.SIM_NOT_READY || currentRadioState == CommandsInterface.RadioState.RUIM_NOT_READY || currentRadioState == CommandsInterface.RadioState.NV_NOT_READY || currentRadioState == CommandsInterface.RadioState.NV_READY) {
            return State.NOT_READY;
        }
        if (currentRadioState == CommandsInterface.RadioState.SIM_LOCKED_OR_ABSENT || currentRadioState == CommandsInterface.RadioState.SIM_READY || currentRadioState == CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT || currentRadioState == CommandsInterface.RadioState.RUIM_READY) {
            int index = currentRadioState == CommandsInterface.RadioState.RUIM_LOCKED_OR_ABSENT || currentRadioState == CommandsInterface.RadioState.RUIM_READY ? this.mIccCardStatus.getCdmaSubscriptionAppIndex() : this.mIccCardStatus.getGsmUmtsSubscriptionAppIndex();
            IccCardApplication app = this.mIccCardStatus.getApplication(index);
            if (app == null) {
                Log.e(this.mLogTag, "[IccCard] Subscription Application in not present");
                return State.ABSENT;
            }
            if (app.app_state.isPinRequired()) {
                return State.PIN_REQUIRED;
            }
            if (app.app_state.isPukRequired()) {
                return State.PUK_REQUIRED;
            }
            if (app.app_state.isSubscriptionPersoEnabled()) {
                return State.NETWORK_LOCKED;
            }
            if (app.app_state.isAppReady()) {
                return State.READY;
            }
            if (app.app_state.isAppNotReady()) {
                return State.NOT_READY;
            }
            return State.NOT_READY;
        }
        return State.ABSENT;
    }

    public boolean isApplicationOnIcc(IccCardApplication.AppType type) {
        if (this.mIccCardStatus == null) {
            return false;
        }
        for (int i = 0; i < this.mIccCardStatus.getNumApplications(); ++i) {
            IccCardApplication app = this.mIccCardStatus.getApplication(i);
            if (app == null || app.app_type != type) continue;
            return true;
        }
        return false;
    }

    public boolean hasIccCard() {
        if (this.mPhone.getPhoneName().equals("GSM")) {
            return this.mIccCardStatus.getCardState().isCardPresent();
        }
        return false;
    }

    public void log(String msg) {
        Log.d(this.mLogTag, "[IccCard] " + msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        ABSENT,
        PIN_REQUIRED,
        PUK_REQUIRED,
        NETWORK_LOCKED,
        READY,
        NOT_READY;


        public boolean isPinLocked() {
            return this == PIN_REQUIRED || this == PUK_REQUIRED;
        }
    }
}

