/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.cdma.CDMAPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CdmaMmiCode
extends Handler
implements MmiCode {
    public static final String LOG_TAG = "CDMA_MMI";
    public static final String ACTION_REGISTER = "**";
    public static final String SC_PUK = "05";
    public static final int EVENT_SET_COMPLETE = 1;
    public CDMAPhone phone;
    public Context context;
    public String action;
    public String sc;
    public String sia;
    public String sib;
    public String sic;
    public String poundString;
    public String dialingNumber;
    public String pwd;
    public MmiCode.State state = MmiCode.State.PENDING;
    public CharSequence message;
    public static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    public static final int MATCH_GROUP_POUND_STRING = 1;
    public static final int MATCH_GROUP_ACTION = 2;
    public static final int MATCH_GROUP_SERVICE_CODE = 3;
    public static final int MATCH_GROUP_SIA = 5;
    public static final int MATCH_GROUP_SIB = 7;
    public static final int MATCH_GROUP_SIC = 9;
    public static final int MATCH_GROUP_PWD_CONFIRM = 11;
    public static final int MATCH_GROUP_DIALING_NUMBER = 12;

    public static CdmaMmiCode newFromDialString(String dialString, CDMAPhone phone) {
        CdmaMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new CdmaMmiCode(phone);
            ret.poundString = CdmaMmiCode.makeEmptyNull(m.group(1));
            ret.action = CdmaMmiCode.makeEmptyNull(m.group(2));
            ret.sc = CdmaMmiCode.makeEmptyNull(m.group(3));
            ret.sia = CdmaMmiCode.makeEmptyNull(m.group(5));
            ret.sib = CdmaMmiCode.makeEmptyNull(m.group(7));
            ret.sic = CdmaMmiCode.makeEmptyNull(m.group(9));
            ret.pwd = CdmaMmiCode.makeEmptyNull(m.group(11));
            ret.dialingNumber = CdmaMmiCode.makeEmptyNull(m.group(12));
        }
        return ret;
    }

    public static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public CdmaMmiCode(CDMAPhone phone) {
        super(phone.getHandler().getLooper());
        this.phone = phone;
        this.context = phone.getContext();
    }

    public MmiCode.State getState() {
        return this.state;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public void cancel() {
        if (this.state == MmiCode.State.COMPLETE || this.state == MmiCode.State.FAILED) {
            return;
        }
        this.state = MmiCode.State.CANCELLED;
        this.phone.onMMIDone(this);
    }

    public boolean isCancelable() {
        return false;
    }

    public boolean isPukCommand() {
        return this.sc != null && this.sc.equals(SC_PUK);
    }

    public boolean isRegister() {
        return this.action != null && this.action.equals(ACTION_REGISTER);
    }

    public boolean isUssdRequest() {
        Log.w(LOG_TAG, "isUssdRequest is not implemented in CdmaMmiCode");
        return false;
    }

    public void processCode() {
        block8: {
            try {
                if (this.isPukCommand()) {
                    String oldPinOrPuk = this.sia;
                    String newPin = this.sib;
                    int pinLen = newPin.length();
                    if (this.isRegister()) {
                        if (!newPin.equals(this.sic)) {
                            this.handlePasswordError(17039554);
                        } else if (pinLen < 4 || pinLen > 8) {
                            this.handlePasswordError(17039555);
                        } else {
                            this.phone.mCM.supplyIccPuk(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        }
                        break block8;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.state = MmiCode.State.FAILED;
                this.message = this.context.getText(17039543);
                this.phone.onMMIDone(this);
            }
        }
    }

    public void handlePasswordError(int res) {
        this.state = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.context.getText(res));
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public void handleMessage(Message msg) {
        if (msg.what == 1) {
            AsyncResult ar = (AsyncResult)msg.obj;
            this.onSetComplete(ar);
        } else {
            Log.e(LOG_TAG, "Unexpected reply");
        }
    }

    public CharSequence getScString() {
        if (this.sc != null && this.isPukCommand()) {
            return this.context.getText(17039564);
        }
        return "";
    }

    public void onSetComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPukCommand()) {
                        sb.append(this.context.getText(17039553));
                    } else {
                        sb.append(this.context.getText(17039550));
                    }
                } else {
                    sb.append(this.context.getText(17039543));
                }
            } else {
                sb.append(this.context.getText(17039543));
            }
        } else if (this.isRegister()) {
            this.state = MmiCode.State.COMPLETE;
            sb.append(this.context.getText(17039548));
        } else {
            this.state = MmiCode.State.FAILED;
            sb.append(this.context.getText(17039543));
        }
        this.message = sb;
        this.phone.onMMIDone(this);
    }
}

