/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.IccVmNotSupportedException;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import com.android.internal.telephony.gsm.GsmDataConnectionTracker;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import com.android.internal.telephony.gsm.GsmServiceStateTracker;
import com.android.internal.telephony.gsm.NetworkInfo;
import com.android.internal.telephony.gsm.SIMFileHandler;
import com.android.internal.telephony.gsm.SIMRecords;
import com.android.internal.telephony.gsm.SimCard;
import com.android.internal.telephony.gsm.SimPhoneBookInterfaceManager;
import com.android.internal.telephony.gsm.SimSmsInterfaceManager;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.gsm.stk.StkService;
import com.android.internal.telephony.test.SimulatedRadioControl;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSMPhone
extends PhoneBase {
    public static final String LOG_TAG = "GSM";
    public static final boolean LOCAL_DEBUG = true;
    public static final String CIPHERING_KEY = "ciphering_key";
    public static final String VM_NUMBER = "vm_number_key";
    public static final String VM_SIM_IMSI = "vm_sim_imsi_key";
    public GsmCallTracker mCT;
    public GsmServiceStateTracker mSST;
    public GsmSMSDispatcher mSMS;
    public SIMRecords mSIMRecords;
    public SimCard mSimCard;
    public StkService mStkService;
    public ArrayList<GsmMmiCode> mPendingMMIs = new ArrayList();
    public SimPhoneBookInterfaceManager mSimPhoneBookIntManager;
    public SimSmsInterfaceManager mSimSmsIntManager;
    public PhoneSubInfo mSubInfo;
    public Registrant mPostDialHandler;
    public RegistrantList mSsnRegistrants = new RegistrantList();
    public Thread debugPortThread;
    public ServerSocket debugSocket;
    public String mImei;
    public String mImeiSv;
    public String mVmNumber;

    public GSMPhone(Context context, CommandsInterface ci, PhoneNotifier notifier) {
        this(context, ci, notifier, false);
    }

    public GSMPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode) {
        super(notifier, context, ci, unitTestMode);
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCM.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mSMS = new GsmSMSDispatcher(this);
        this.mIccFileHandler = new SIMFileHandler(this);
        this.mSIMRecords = new SIMRecords(this);
        this.mDataConnection = new GsmDataConnectionTracker(this);
        this.mSimCard = new SimCard(this);
        if (!unitTestMode) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSimSmsIntManager = new SimSmsInterfaceManager(this, this.mSMS);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mStkService = StkService.getInstance(this.mCM, this.mSIMRecords, this.mContext, (SIMFileHandler)this.mIccFileHandler, this.mSimCard);
        this.mCM.registerForAvailable(this, 1, null);
        this.mSIMRecords.registerForRecordsLoaded(this, 3, null);
        this.mCM.registerForOffOrNotAvailable(this, 8, null);
        this.mCM.registerForOn(this, 5, null);
        this.mCM.setOnUSSD(this, 7, null);
        this.mCM.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttach(this, 19, null);
        SystemProperties.set("gsm.current.phone-type", new Integer(1).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mCM.unregisterForAvailable(this);
            this.mSIMRecords.unregisterForRecordsLoaded(this);
            this.mCM.unregisterForOffOrNotAvailable(this);
            this.mCM.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttach(this);
            this.mCM.unSetOnUSSD(this);
            this.mCM.unSetOnSuppServiceNotification(this);
            this.mPendingMMIs.clear();
            this.mStkService.dispose();
            this.mCT.dispose();
            this.mDataConnection.dispose();
            this.mSST.dispose();
            this.mIccFileHandler.dispose();
            this.mSIMRecords.dispose();
            this.mSimCard.dispose();
            this.mSimPhoneBookIntManager.dispose();
            this.mSimSmsIntManager.dispose();
            this.mSubInfo.dispose();
        }
    }

    public void removeReferences() {
        this.mSimulatedRadioControl = null;
        this.mStkService = null;
        this.mSimPhoneBookIntManager = null;
        this.mSimSmsIntManager = null;
        this.mSMS = null;
        this.mSubInfo = null;
        this.mSIMRecords = null;
        this.mIccFileHandler = null;
        this.mSimCard = null;
        this.mDataConnection = null;
        this.mCT = null;
        this.mSST = null;
    }

    public void finalize() {
        Log.d(LOG_TAG, "GSMPhone finalized");
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSST.ss;
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mSST.cellLoc;
    }

    @Override
    public Phone.State getState() {
        return this.mCT.state;
    }

    @Override
    public String getPhoneName() {
        return LOG_TAG;
    }

    @Override
    public int getPhoneType() {
        return 1;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return this.mSST.mSignalStrength;
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mSIMRecords.getVoiceMessageWaiting();
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return this.mSIMRecords.getVoiceCallForwardingFlag();
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        Phone.DataState ret = Phone.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = Phone.DataState.DISCONNECTED;
        } else if (this.mSST.getCurrentGprsState() != 0) {
            ret = Phone.DataState.DISCONNECTED;
        } else {
            switch (this.mDataConnection.getState()) {
                case FAILED: 
                case IDLE: {
                    ret = Phone.DataState.DISCONNECTED;
                    break;
                }
                case CONNECTED: 
                case DISCONNECTING: {
                    if (this.mCT.state != Phone.State.IDLE && !this.mSST.isConcurrentVoiceAndData()) {
                        ret = Phone.DataState.SUSPENDED;
                        break;
                    }
                    ret = Phone.DataState.CONNECTED;
                    break;
                }
                case INITING: 
                case CONNECTING: 
                case SCANNING: {
                    ret = Phone.DataState.CONNECTING;
                }
            }
        }
        return ret;
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState ret = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentGprsState() == 0) {
            switch (this.mDataConnection.getActivity()) {
                case DATAIN: {
                    ret = Phone.DataActivityState.DATAIN;
                    break;
                }
                case DATAOUT: {
                    ret = Phone.DataActivityState.DATAOUT;
                    break;
                }
                case DATAINANDOUT: {
                    ret = Phone.DataActivityState.DATAINANDOUT;
                }
            }
        }
        return ret;
    }

    public void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    public void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    public void notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    public void notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
    }

    public void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    public void notifySuppServiceFailed(Phone.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    public void notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    public void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    public void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    public void notifyDataConnectionFailed(String reason) {
        this.mNotifier.notifyDataConnectionFailed(this, reason);
    }

    public void updateMessageWaitingIndicator(boolean mwi) {
        this.mSIMRecords.setVoiceMessageWaiting(1, mwi ? -1 : 0);
    }

    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    @Override
    public void setSystemProperty(String property, String value) {
        super.setSystemProperty(property, value);
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCM.setSuppServiceNotifications(true, null);
        }
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCM.setSuppServiceNotifications(false, null);
        }
    }

    @Override
    public void acceptCall() throws CallStateException {
        this.mCT.acceptCall();
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public void conference() throws CallStateException {
        this.mCT.conference();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void explicitCallTransfer() throws CallStateException {
        this.mCT.explicitCallTransfer();
    }

    @Override
    public GsmCall getForegroundCall() {
        return this.mCT.foregroundCall;
    }

    @Override
    public GsmCall getBackgroundCall() {
        return this.mCT.backgroundCall;
    }

    @Override
    public GsmCall getRingingCall() {
        return this.mCT.ringingCall;
    }

    public boolean handleCallDeflectionIncallSupplementaryService(String dialString) throws CallStateException {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Log.d(LOG_TAG, "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Log.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(Phone.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Log.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
        }
        return true;
    }

    public boolean handleCallWaitingIncallSupplementaryService(String dialString) throws CallStateException {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        GsmCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                char ch = dialString.charAt(1);
                int callIndex = ch - 48;
                if (callIndex >= 1 && callIndex <= 7) {
                    Log.d(LOG_TAG, "MmiCode 1: hangupConnectionByIndex " + callIndex);
                    this.mCT.hangupConnectionByIndex(call, callIndex);
                }
            } else if (call.getState() != Call.State.IDLE) {
                Log.d(LOG_TAG, "MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                Log.d(LOG_TAG, "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Log.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
        }
        return true;
    }

    public boolean handleCallHoldIncallSupplementaryService(String dialString) throws CallStateException {
        block10: {
            int len = dialString.length();
            if (len > 2) {
                return false;
            }
            GsmCall call = this.getForegroundCall();
            if (len > 1) {
                try {
                    char ch = dialString.charAt(1);
                    int callIndex = ch - 48;
                    GsmConnection conn = this.mCT.getConnectionByIndex(call, callIndex);
                    if (conn != null && callIndex >= 1 && callIndex <= 7) {
                        Log.d(LOG_TAG, "MmiCode 2: separate call " + callIndex);
                        this.mCT.separate(conn);
                        break block10;
                    }
                    Log.d(LOG_TAG, "separate: invalid call index " + callIndex);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
                catch (CallStateException e) {
                    Log.d(LOG_TAG, "separate failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
            } else {
                try {
                    if (this.getRingingCall().getState() != Call.State.IDLE) {
                        Log.d(LOG_TAG, "MmiCode 2: accept ringing call");
                        this.mCT.acceptCall();
                    } else {
                        Log.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
                        this.mCT.switchWaitingOrHoldingAndActive();
                    }
                }
                catch (CallStateException e) {
                    Log.d(LOG_TAG, "switch failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SWITCH);
                }
            }
        }
        return true;
    }

    public boolean handleMultipartyIncallSupplementaryService(String dialString) throws CallStateException {
        if (dialString.length() > 1) {
            return false;
        }
        Log.d(LOG_TAG, "MmiCode 3: merge calls");
        try {
            this.conference();
        }
        catch (CallStateException e) {
            Log.d(LOG_TAG, "conference failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.CONFERENCE);
        }
        return true;
    }

    public boolean handleEctIncallSupplementaryService(String dialString) throws CallStateException {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Log.d(LOG_TAG, "MmiCode 4: explicit call transfer");
        try {
            this.explicitCallTransfer();
        }
        catch (CallStateException e) {
            Log.d(LOG_TAG, "transfer failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.TRANSFER);
        }
        return true;
    }

    public boolean handleCcbsIncallSupplementaryService(String dialString) throws CallStateException {
        if (dialString.length() > 1) {
            return false;
        }
        Log.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(Phone.SuppService.UNKNOWN);
        return true;
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) throws CallStateException {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    public boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public Connection dial(String dialString) throws CallStateException {
        return this.dial(dialString, null);
    }

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.handleInCallMmiCommands(newDialString)) {
            return null;
        }
        String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(networkPortion, this);
        Log.d(LOG_TAG, "dialing w/ mmi '" + mmi + "'...");
        if (mmi == null) {
            return this.mCT.dial(newDialString, uusInfo);
        }
        if (mmi.isTemporaryModeCLIR()) {
            return this.mCT.dial(mmi.dialingNumber, mmi.getCLIRMode(), uusInfo);
        }
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.processCode();
        return null;
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(dialString, this);
        if (mmi != null && mmi.isPinCommand()) {
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return true;
        }
        return false;
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        GsmMmiCode mmi = GsmMmiCode.newFromUssdUserInput(ussdMessge, this);
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.state == Phone.State.OFFHOOK) {
            this.mCM.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Log.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCM.startDtmf(c, null);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCM.stopDtmf(null);
    }

    public void sendBurstDtmf(String dtmfString) {
        Log.e(LOG_TAG, "[GSMPhone] sendBurstDtmf() is a CDMA method");
    }

    @Override
    public void setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    public void storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_NUMBER, number);
        editor.apply();
        this.setVmSimImsi(this.getSubscriberId());
    }

    @Override
    public String getVoiceMailNumber() {
        String number = this.mSIMRecords.getVoiceMailNumber();
        if (TextUtils.isEmpty(number)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            number = sp.getString(VM_NUMBER, null);
        }
        return number;
    }

    public String getVmSimImsi() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString(VM_SIM_IMSI, null);
    }

    public void setVmSimImsi(String imsi) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_SIM_IMSI, imsi);
        editor.apply();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        String ret = this.mSIMRecords.getVoiceMailAlphaTag();
        if (ret == null || ret.length() == 0) {
            return ((Object)this.mContext.getText(0x1040004)).toString();
        }
        return ret;
    }

    @Override
    public String getDeviceId() {
        return this.mImei;
    }

    @Override
    public String getDeviceSvn() {
        return this.mImeiSv;
    }

    @Override
    public String getEsn() {
        Log.e(LOG_TAG, "[GSMPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public String getMeid() {
        Log.e(LOG_TAG, "[GSMPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public String getSubscriberId() {
        return this.mSIMRecords.imsi;
    }

    @Override
    public String getIccSerialNumber() {
        return this.mSIMRecords.iccid;
    }

    @Override
    public String getLine1Number() {
        return this.mSIMRecords.getMsisdnNumber();
    }

    @Override
    public String getLine1AlphaTag() {
        return this.mSIMRecords.getMsisdnAlphaTag();
    }

    @Override
    public void setLine1Number(String alphaTag, String number, Message onComplete) {
        this.mSIMRecords.setMsisdnNumber(alphaTag, number, onComplete);
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        this.mSIMRecords.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
    }

    public boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Log.d(LOG_TAG, "requesting call forwarding query.");
            Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(13, onComplete) : onComplete;
            this.mCM.queryCallForwardStatus(commandInterfaceCFReason, 0, null, resp);
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, onComplete) : onComplete;
            this.mCM.setCallForward(commandInterfaceCFAction, commandInterfaceCFReason, 1, dialingNumber, timerSeconds, resp);
        }
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        this.mCM.getCLIR(onComplete);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        this.mCM.setCLIR(commandInterfaceCLIRMode, this.obtainMessage(18, commandInterfaceCLIRMode, 0, onComplete));
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        this.mCM.queryCallWaiting(1, onComplete);
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        this.mCM.setCallWaiting(enable, 1, onComplete);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mSIMRecords.getRecordsLoaded();
    }

    @Override
    public IccCard getIccCard() {
        return this.mSimCard;
    }

    @Override
    public void getAvailableNetworks(Message response) {
        this.mCM.getAvailableNetworks(response);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage(null);
        nsm.message = response;
        nsm.operatorNumeric = "";
        nsm.operatorAlphaLong = "";
        Message msg = this.obtainMessage(17, nsm);
        Log.d(LOG_TAG, "wrapping and sending message to connect automatically");
        this.mCM.setNetworkSelectionModeAutomatic(msg);
    }

    @Override
    public void selectNetworkManually(NetworkInfo network, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage(null);
        nsm.message = response;
        nsm.operatorNumeric = network.operatorNumeric;
        nsm.operatorAlphaLong = network.operatorAlphaLong;
        Message msg = this.obtainMessage(16, nsm);
        this.mCM.setNetworkSelectionModeManual(network.operatorNumeric, msg);
    }

    @Override
    public void getNeighboringCids(Message response) {
        this.mCM.getNeighboringCids(response);
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getDataCallList(Message response) {
        this.mCM.getDataCallList(response);
    }

    @Override
    public List<DataConnection> getCurrentDataConnectionList() {
        return this.mDataConnection.getAllDataConnections();
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDataConnection.getDataOnRoamingEnabled();
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
        this.mDataConnection.setDataOnRoamingEnabled(enable);
    }

    @Override
    public boolean enableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(true);
    }

    @Override
    public boolean disableDataConnectivity() {
        return this.mDataConnection.setDataEnabled(false);
    }

    @Override
    public boolean isDataConnectivityPossible() {
        boolean noData = this.mDataConnection.getDataEnabled() && this.getDataConnectionState() == Phone.DataState.DISCONNECTED;
        return !noData && this.getIccCard().getState() == IccCard.State.READY && this.getServiceState().getState() == 0 && (this.mDataConnection.getDataOnRoamingEnabled() || !this.getServiceState().getRoaming());
    }

    public void onMMIDone(GsmMmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest()) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    public void onNetworkInitiatedUssd(GsmMmiCode mmi) {
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    public void onIncomingUSSD(int ussdMode, String ussdMessage) {
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        GsmMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            GsmMmiCode mmi = GsmMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this);
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    public void syncClirSetting() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        int clirSetting = sp.getInt("clir_key", -1);
        if (clirSetting >= 0) {
            this.mCM.setCLIR(clirSetting, null);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mCM.getBasebandVersion(this.obtainMessage(6));
                this.mCM.getIMEI(this.obtainMessage(9));
                this.mCM.getIMEISV(this.obtainMessage(10));
                break;
            }
            case 5: {
                break;
            }
            case 19: {
                this.syncClirSetting();
                break;
            }
            case 3: {
                this.updateCurrentCarrierInProvider();
                String imsi = this.getVmSimImsi();
                if (imsi == null || this.getSubscriberId().equals(imsi)) break;
                this.storeVoiceMailNumber(null);
                this.setVmSimImsi(null);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Log.d(LOG_TAG, "Baseband version: " + ar.result);
                this.setSystemProperty("gsm.version.baseband", (String)ar.result);
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImei = (String)ar.result;
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImeiSv = (String)ar.result;
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String[] ussdResult = (String[])ar.result;
                if (ussdResult.length <= 1) break;
                try {
                    this.onIncomingUSSD(Integer.parseInt(ussdResult[0]), ussdResult[1]);
                }
                catch (NumberFormatException e) {
                    Log.w(LOG_TAG, "error parsing USSD");
                }
                break;
            }
            case 8: {
                int s = this.mPendingMMIs.size();
                for (int i = 0; i < s; ++i) {
                    if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
                    this.mPendingMMIs.get(i).onUssdFinishedError();
                }
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                SuppServiceNotification not = (SuppServiceNotification)ar.result;
                this.mSsnRegistrants.notifyRegistrants(ar);
                break;
            }
            case 12: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mSIMRecords.setVoiceCallForwardingFlag(1, msg.arg1 == 1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (IccVmNotSupportedException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 13: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleCfuQueryResult((CallForwardInfo[])ar.result);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 16: 
            case 17: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                break;
            }
            case 18: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public boolean updateCurrentCarrierInProvider() {
        if (this.mSIMRecords != null) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", this.mSIMRecords.getSIMOperatorNumeric());
                this.mContext.getContentResolver().insert(uri, map);
                return true;
            }
            catch (SQLException e) {
                Log.e(LOG_TAG, "Can't store current operator", e);
            }
        }
        return false;
    }

    public void handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            Log.d(LOG_TAG, "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            Log.d(LOG_TAG, "sending original message to recipient");
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("network_selection_key", nsm.operatorNumeric);
        editor.putString("network_selection_name_key", nsm.operatorAlphaLong);
        if (!editor.commit()) {
            Log.e(LOG_TAG, "failed to commit network selection preference");
        }
    }

    public void saveClirSetting(int commandInterfaceCLIRMode) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("clir_key", commandInterfaceCLIRMode);
        if (!editor.commit()) {
            Log.e(LOG_TAG, "failed to commit CLIR preference");
        }
    }

    public void handleCfuQueryResult(CallForwardInfo[] infos) {
        if (infos == null || infos.length == 0) {
            this.mSIMRecords.setVoiceCallForwardingFlag(1, false);
        } else {
            int s = infos.length;
            for (int i = 0; i < s; ++i) {
                if ((infos[i].serviceClass & 1) == 0) continue;
                this.mSIMRecords.setVoiceCallForwardingFlag(1, infos[i].status == 1);
                break;
            }
        }
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mSimSmsIntManager;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mSimPhoneBookIntManager;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return this.mIccFileHandler;
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        Log.e(LOG_TAG, "[GSMPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        Log.e(LOG_TAG, "[GSMPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Log.e(LOG_TAG, "[GSMPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    public static class NetworkSelectMessage {
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;

        public NetworkSelectMessage() {
        }

        public /* synthetic */ NetworkSelectMessage(1 x0) {
            this();
        }
    }
}

