/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.gsm.GSMPhone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GsmMmiCode
extends Handler
implements MmiCode {
    public static final String LOG_TAG = "GSM";
    public static final String ACTION_ACTIVATE = "*";
    public static final String ACTION_DEACTIVATE = "#";
    public static final String ACTION_INTERROGATE = "*#";
    public static final String ACTION_REGISTER = "**";
    public static final String ACTION_ERASURE = "##";
    public static final String SC_CLIP = "30";
    public static final String SC_CLIR = "31";
    public static final String SC_CFU = "21";
    public static final String SC_CFB = "67";
    public static final String SC_CFNRy = "61";
    public static final String SC_CFNR = "62";
    public static final String SC_CF_All = "002";
    public static final String SC_CF_All_Conditional = "004";
    public static final String SC_WAIT = "43";
    public static final String SC_BAOC = "33";
    public static final String SC_BAOIC = "331";
    public static final String SC_BAOICxH = "332";
    public static final String SC_BAIC = "35";
    public static final String SC_BAICr = "351";
    public static final String SC_BA_ALL = "330";
    public static final String SC_BA_MO = "333";
    public static final String SC_BA_MT = "353";
    public static final String SC_PWD = "03";
    public static final String SC_PIN = "04";
    public static final String SC_PIN2 = "042";
    public static final String SC_PUK = "05";
    public static final String SC_PUK2 = "052";
    public static final int EVENT_SET_COMPLETE = 1;
    public static final int EVENT_GET_CLIR_COMPLETE = 2;
    public static final int EVENT_QUERY_CF_COMPLETE = 3;
    public static final int EVENT_USSD_COMPLETE = 4;
    public static final int EVENT_QUERY_COMPLETE = 5;
    public static final int EVENT_SET_CFF_COMPLETE = 6;
    public static final int EVENT_USSD_CANCEL_COMPLETE = 7;
    public GSMPhone phone;
    public Context context;
    public String action;
    public String sc;
    public String sia;
    public String sib;
    public String sic;
    public String poundString;
    public String dialingNumber;
    public String pwd;
    public boolean isPendingUSSD;
    public boolean isUssdRequest;
    public MmiCode.State state = MmiCode.State.PENDING;
    public CharSequence message;
    public static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    public static final int MATCH_GROUP_POUND_STRING = 1;
    public static final int MATCH_GROUP_ACTION = 2;
    public static final int MATCH_GROUP_SERVICE_CODE = 3;
    public static final int MATCH_GROUP_SIA = 5;
    public static final int MATCH_GROUP_SIB = 7;
    public static final int MATCH_GROUP_SIC = 9;
    public static final int MATCH_GROUP_PWD_CONFIRM = 11;
    public static final int MATCH_GROUP_DIALING_NUMBER = 12;
    public static String[] sTwoDigitNumberPattern;

    public static GsmMmiCode newFromDialString(String dialString, GSMPhone phone) {
        GsmMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new GsmMmiCode(phone);
            ret.poundString = GsmMmiCode.makeEmptyNull(m.group(1));
            ret.action = GsmMmiCode.makeEmptyNull(m.group(2));
            ret.sc = GsmMmiCode.makeEmptyNull(m.group(3));
            ret.sia = GsmMmiCode.makeEmptyNull(m.group(5));
            ret.sib = GsmMmiCode.makeEmptyNull(m.group(7));
            ret.sic = GsmMmiCode.makeEmptyNull(m.group(9));
            ret.pwd = GsmMmiCode.makeEmptyNull(m.group(11));
            ret.dialingNumber = GsmMmiCode.makeEmptyNull(m.group(12));
        } else if (dialString.endsWith(ACTION_DEACTIVATE)) {
            ret = new GsmMmiCode(phone);
            ret.poundString = dialString;
        } else if (GsmMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (GsmMmiCode.isShortCode(dialString, phone)) {
            ret = new GsmMmiCode(phone);
            ret.dialingNumber = dialString;
        }
        return ret;
    }

    public static GsmMmiCode newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, GSMPhone phone) {
        GsmMmiCode ret = new GsmMmiCode(phone);
        ret.message = ussdMessage;
        ret.isUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.isPendingUSSD = true;
            ret.state = MmiCode.State.PENDING;
        } else {
            ret.state = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    public static GsmMmiCode newFromUssdUserInput(String ussdMessge, GSMPhone phone) {
        GsmMmiCode ret = new GsmMmiCode(phone);
        ret.message = ussdMessge;
        ret.state = MmiCode.State.PENDING;
        ret.isPendingUSSD = true;
        return ret;
    }

    public static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static int scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals(SC_CF_All)) {
            return 4;
        }
        if (sc.equals(SC_CFU)) {
            return 0;
        }
        if (sc.equals(SC_CFB)) {
            return 1;
        }
        if (sc.equals(SC_CFNR)) {
            return 3;
        }
        if (sc.equals(SC_CFNRy)) {
            return 2;
        }
        if (sc.equals(SC_CF_All_Conditional)) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    public static int siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    public static int siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    public static boolean isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals(SC_CFU) || sc.equals(SC_CFB) || sc.equals(SC_CFNRy) || sc.equals(SC_CFNR) || sc.equals(SC_CF_All) || sc.equals(SC_CF_All_Conditional));
    }

    public static boolean isServiceCodeCallBarring(String sc) {
        return sc != null && (sc.equals(SC_BAOC) || sc.equals(SC_BAOIC) || sc.equals(SC_BAOICxH) || sc.equals(SC_BAIC) || sc.equals(SC_BAICr) || sc.equals(SC_BA_ALL) || sc.equals(SC_BA_MO) || sc.equals(SC_BA_MT));
    }

    public static String scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals(SC_BAOC)) {
            return "AO";
        }
        if (sc.equals(SC_BAOIC)) {
            return "OI";
        }
        if (sc.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (sc.equals(SC_BAIC)) {
            return "AI";
        }
        if (sc.equals(SC_BAICr)) {
            return "IR";
        }
        if (sc.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (sc.equals(SC_BA_MO)) {
            return "AG";
        }
        if (sc.equals(SC_BA_MT)) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    public GsmMmiCode(GSMPhone phone) {
        super(phone.getHandler().getLooper());
        this.phone = phone;
        this.context = phone.getContext();
    }

    public MmiCode.State getState() {
        return this.state;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public void cancel() {
        if (this.state == MmiCode.State.COMPLETE || this.state == MmiCode.State.FAILED) {
            return;
        }
        this.state = MmiCode.State.CANCELLED;
        if (this.isPendingUSSD) {
            this.phone.mCM.cancelPendingUssd(this.obtainMessage(7, this));
        } else {
            this.phone.onMMIDone(this);
        }
    }

    public boolean isCancelable() {
        return this.isPendingUSSD;
    }

    public boolean isMMI() {
        return this.poundString != null;
    }

    public boolean isShortCode() {
        return this.poundString == null && this.dialingNumber != null && this.dialingNumber.length() <= 2;
    }

    public static boolean isTwoDigitShortCode(Context context, String dialString) {
        Log.d(LOG_TAG, "isTwoDigitShortCode");
        if (dialString == null || dialString.length() != 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17235994);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Log.d(LOG_TAG, "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Log.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        Log.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    public static boolean isShortCode(String dialString, GSMPhone phone) {
        return dialString != null && dialString.length() <= 2 && !PhoneNumberUtils.isEmergencyNumber(dialString) && (phone.isInCall() || (dialString.length() != 2 || dialString.charAt(0) != '1') && !dialString.equals("0") && !dialString.equals("00"));
    }

    public boolean isPinCommand() {
        return this.sc != null && (this.sc.equals(SC_PIN) || this.sc.equals(SC_PIN2) || this.sc.equals(SC_PUK) || this.sc.equals(SC_PUK2));
    }

    public boolean isTemporaryModeCLIR() {
        return this.sc != null && this.sc.equals(SC_CLIR) && this.dialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    public int getCLIRMode() {
        if (this.sc != null && this.sc.equals(SC_CLIR)) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    public boolean isActivate() {
        return this.action != null && this.action.equals(ACTION_ACTIVATE);
    }

    public boolean isDeactivate() {
        return this.action != null && this.action.equals(ACTION_DEACTIVATE);
    }

    public boolean isInterrogate() {
        return this.action != null && this.action.equals(ACTION_INTERROGATE);
    }

    public boolean isRegister() {
        return this.action != null && this.action.equals(ACTION_REGISTER);
    }

    public boolean isErasure() {
        return this.action != null && this.action.equals(ACTION_ERASURE);
    }

    public boolean isPendingUSSD() {
        return this.isPendingUSSD;
    }

    public boolean isUssdRequest() {
        return this.isUssdRequest;
    }

    public void processCode() {
        block47: {
            try {
                if (this.isShortCode()) {
                    Log.d(LOG_TAG, "isShortCode");
                    this.sendUssd(this.dialingNumber);
                    break block47;
                }
                if (this.dialingNumber != null) {
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.sc != null && this.sc.equals(SC_CLIP)) {
                    Log.d(LOG_TAG, "is CLIP");
                    if (this.isInterrogate()) {
                        this.phone.mCM.queryCLIP(this.obtainMessage(5, this));
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.sc != null && this.sc.equals(SC_CLIR)) {
                    Log.d(LOG_TAG, "is CLIR");
                    if (this.isActivate()) {
                        this.phone.mCM.setCLIR(1, this.obtainMessage(1, this));
                        break block47;
                    }
                    if (this.isDeactivate()) {
                        this.phone.mCM.setCLIR(2, this.obtainMessage(1, this));
                        break block47;
                    }
                    if (this.isInterrogate()) {
                        this.phone.mCM.getCLIR(this.obtainMessage(2, this));
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (GsmMmiCode.isServiceCodeCallForwarding(this.sc)) {
                    Log.d(LOG_TAG, "is CF");
                    String dialingNumber = this.sia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.sib);
                    int reason = GsmMmiCode.scToCallForwardReason(this.sc);
                    int time = GsmMmiCode.siToTime(this.sic);
                    if (this.isInterrogate()) {
                        this.phone.mCM.queryCallForwardStatus(reason, serviceClass, dialingNumber, this.obtainMessage(3, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            cfAction = 1;
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditionalVoice = !(reason != 0 && reason != 4 || (serviceClass & 1) == 0 && serviceClass != 0) ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Log.d(LOG_TAG, "is CF setCallForward");
                        this.phone.mCM.setCallForward(cfAction, reason, serviceClass, dialingNumber, time, this.obtainMessage(6, isSettingUnconditionalVoice, isEnableDesired, this));
                    }
                    break block47;
                }
                if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                    String password = this.sia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.sib);
                    String facility = GsmMmiCode.scToBarringFacility(this.sc);
                    if (this.isInterrogate()) {
                        this.phone.mCM.queryFacilityLock(facility, password, serviceClass, this.obtainMessage(5, this));
                        break block47;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.phone.mCM.setFacilityLock(facility, this.isActivate(), password, serviceClass, this.obtainMessage(1, this));
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.sc != null && this.sc.equals(SC_PWD)) {
                    String oldPwd = this.sib;
                    String newPwd = this.sic;
                    if (this.isActivate() || this.isRegister()) {
                        this.action = ACTION_REGISTER;
                        String facility = this.sia == null ? "AB" : GsmMmiCode.scToBarringFacility(this.sia);
                        if (newPwd.equals(this.pwd)) {
                            this.phone.mCM.changeBarringPassword(facility, oldPwd, newPwd, this.obtainMessage(1, this));
                        } else {
                            this.handlePasswordError(17039550);
                        }
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.sc != null && this.sc.equals(SC_WAIT)) {
                    int serviceClass = GsmMmiCode.siToServiceClass(this.sia);
                    if (this.isActivate() || this.isDeactivate()) {
                        this.phone.mCM.setCallWaiting(this.isActivate(), serviceClass, this.obtainMessage(1, this));
                        break block47;
                    }
                    if (this.isInterrogate()) {
                        this.phone.mCM.queryCallWaiting(serviceClass, this.obtainMessage(5, this));
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.isPinCommand()) {
                    String oldPinOrPuk = this.sia;
                    String newPin = this.sib;
                    int pinLen = newPin.length();
                    if (this.isRegister()) {
                        if (!newPin.equals(this.sic)) {
                            this.handlePasswordError(17039554);
                        } else if (pinLen < 4 || pinLen > 8) {
                            this.handlePasswordError(17039555);
                        } else if (this.sc.equals(SC_PIN) && this.phone.mSimCard.getState() == IccCard.State.PUK_REQUIRED) {
                            this.handlePasswordError(17039556);
                        } else if (this.sc.equals(SC_PIN)) {
                            this.phone.mCM.changeIccPin(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        } else if (this.sc.equals(SC_PIN2)) {
                            this.phone.mCM.changeIccPin2(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        } else if (this.sc.equals(SC_PUK)) {
                            this.phone.mCM.supplyIccPuk(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        } else if (this.sc.equals(SC_PUK2)) {
                            this.phone.mCM.supplyIccPuk2(oldPinOrPuk, newPin, this.obtainMessage(1, this));
                        }
                        break block47;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.poundString != null) {
                    this.sendUssd(this.poundString);
                    break block47;
                }
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.state = MmiCode.State.FAILED;
                this.message = this.context.getText(17039543);
                this.phone.onMMIDone(this);
            }
        }
    }

    public void handlePasswordError(int res) {
        this.state = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.context.getText(res));
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public void onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.state == MmiCode.State.PENDING) {
            this.message = ussdMessage == null ? this.context.getText(17039551) : ussdMessage;
            this.isUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.state = MmiCode.State.COMPLETE;
            }
            this.phone.onMMIDone(this);
        }
    }

    public void onUssdFinishedError() {
        if (this.state == MmiCode.State.PENDING) {
            this.state = MmiCode.State.FAILED;
            this.message = this.context.getText(17039543);
            this.phone.onMMIDone(this);
        }
    }

    public void sendUssd(String ussdMessage) {
        this.isPendingUSSD = true;
        this.phone.mCM.sendUSSD(ussdMessage, this.obtainMessage(4, this));
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled = msg.arg2 == 1;
                    this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, cffEnabled);
                }
                this.onSetComplete(ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onGetClirComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 5: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.state = MmiCode.State.FAILED;
                this.message = this.getErrorMessage(ar);
                this.phone.onMMIDone(this);
                break;
            }
            case 7: {
                this.phone.onMMIDone(this);
            }
        }
    }

    public CharSequence getErrorMessage(AsyncResult ar) {
        CommandException.Error err;
        if (ar.exception instanceof CommandException && (err = ((CommandException)ar.exception).getCommandError()) == CommandException.Error.FDN_CHECK_FAILURE) {
            Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
            return this.context.getText(17039544);
        }
        return this.context.getText(17039543);
    }

    public CharSequence getScString() {
        if (this.sc != null) {
            if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                return this.context.getText(17039562);
            }
            if (GsmMmiCode.isServiceCodeCallForwarding(this.sc)) {
                return this.context.getText(17039560);
            }
            if (this.sc.equals(SC_CLIP)) {
                return this.context.getText(17039558);
            }
            if (this.sc.equals(SC_CLIR)) {
                return this.context.getText(17039559);
            }
            if (this.sc.equals(SC_PWD)) {
                return this.context.getText(17039563);
            }
            if (this.sc.equals(SC_WAIT)) {
                return this.context.getText(17039561);
            }
            if (this.isPinCommand()) {
                return this.context.getText(17039564);
            }
        }
        return "";
    }

    public void onSetComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPinCommand()) {
                        if (this.sc.equals(SC_PUK) || this.sc.equals(SC_PUK2)) {
                            sb.append(this.context.getText(17039553));
                        } else {
                            sb.append(this.context.getText(17039552));
                        }
                    } else {
                        sb.append(this.context.getText(17039550));
                    }
                } else if (err == CommandException.Error.SIM_PUK2) {
                    sb.append(this.context.getText(17039552));
                    sb.append("\n");
                    sb.append(this.context.getText(17039557));
                } else if (err == CommandException.Error.FDN_CHECK_FAILURE) {
                    Log.i(LOG_TAG, "FDN_CHECK_FAILURE");
                    sb.append(this.context.getText(17039544));
                } else {
                    sb.append(this.context.getText(17039543));
                }
            } else {
                sb.append(this.context.getText(17039543));
            }
        } else if (this.isActivate()) {
            this.state = MmiCode.State.COMPLETE;
            sb.append(this.context.getText(17039545));
            if (this.sc.equals(SC_CLIR)) {
                this.phone.saveClirSetting(1);
            }
        } else if (this.isDeactivate()) {
            this.state = MmiCode.State.COMPLETE;
            sb.append(this.context.getText(17039547));
            if (this.sc.equals(SC_CLIR)) {
                this.phone.saveClirSetting(2);
            }
        } else if (this.isRegister()) {
            this.state = MmiCode.State.COMPLETE;
            sb.append(this.context.getText(17039548));
        } else if (this.isErasure()) {
            this.state = MmiCode.State.COMPLETE;
            sb.append(this.context.getText(17039549));
        } else {
            this.state = MmiCode.State.FAILED;
            sb.append(this.context.getText(17039543));
        }
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public void onGetClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] clirArgs = (int[])ar.result;
            switch (clirArgs[1]) {
                case 0: {
                    sb.append(this.context.getText(17039575));
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.context.getText(17039576));
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 2: {
                    sb.append(this.context.getText(17039543));
                    this.state = MmiCode.State.FAILED;
                    break;
                }
                case 3: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.context.getText(17039571));
                            break;
                        }
                        case 1: {
                            sb.append(this.context.getText(17039571));
                            break;
                        }
                        case 2: {
                            sb.append(this.context.getText(17039572));
                        }
                    }
                    this.state = MmiCode.State.COMPLETE;
                    break;
                }
                case 4: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.context.getText(17039574));
                            break;
                        }
                        case 1: {
                            sb.append(this.context.getText(17039573));
                            break;
                        }
                        case 2: {
                            sb.append(this.context.getText(17039574));
                        }
                    }
                    this.state = MmiCode.State.COMPLETE;
                }
            }
        }
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public CharSequence serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.context.getText(17039586);
            }
            case 2: {
                return this.context.getText(17039587);
            }
            case 4: {
                return this.context.getText(17039588);
            }
            case 8: {
                return this.context.getText(17039589);
            }
            case 16: {
                return this.context.getText(17039591);
            }
            case 32: {
                return this.context.getText(17039590);
            }
            case 64: {
                return this.context.getText(17039592);
            }
            case 128: {
                return this.context.getText(17039593);
            }
        }
        return null;
    }

    public CharSequence makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.context.getText(17039610) : this.context.getText(17039609)) : (info.status == 0 && GsmMmiCode.isEmptyOrNull(info.number) ? this.context.getText(17039608) : (needTimeTemplate ? this.context.getText(17039612) : this.context.getText(17039611)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa);
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled = info.status == 1;
            this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, cffEnabled);
        }
        return TextUtils.replace(template, sources, destinations);
    }

    public void onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.context.getText(17039547));
                this.phone.mSIMRecords.setVoiceCallForwardingFlag(1, false);
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.state = MmiCode.State.COMPLETE;
        }
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public void onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.state = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.context.getText(17039547));
                } else if (this.sc.equals(SC_WAIT)) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (GsmMmiCode.isServiceCodeCallBarring(this.sc)) {
                    sb.append(this.createQueryCallBarringResultMessage(ints[0]));
                } else if (ints[0] == 1) {
                    sb.append(this.context.getText(17039545));
                } else {
                    sb.append(this.context.getText(17039543));
                }
            } else {
                sb.append(this.context.getText(17039543));
            }
            this.state = MmiCode.State.COMPLETE;
        }
        this.message = sb;
        this.phone.onMMIDone(this);
    }

    public CharSequence createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.context.getText(17039546));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    public CharSequence createQueryCallBarringResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.context.getText(17039546));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }
}

