/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm.stk;

import com.android.internal.telephony.EncodeException;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.stk.ComprehensionTlvTag;
import com.android.internal.telephony.gsm.stk.ResponseData;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class GetInkeyInputResponseData
extends ResponseData {
    public boolean mIsUcs2;
    public boolean mIsPacked;
    public boolean mIsYesNo;
    public boolean mYesNoResponse;
    public String mInData;
    public static final byte GET_INKEY_YES = 1;
    public static final byte GET_INKEY_NO = 0;

    public GetInkeyInputResponseData(String inData, boolean ucs2, boolean packed) {
        this.mIsUcs2 = ucs2;
        this.mIsPacked = packed;
        this.mInData = inData;
        this.mIsYesNo = false;
    }

    public GetInkeyInputResponseData(boolean yesNoResponse) {
        this.mIsUcs2 = false;
        this.mIsPacked = false;
        this.mInData = "";
        this.mIsYesNo = true;
        this.mYesNoResponse = yesNoResponse;
    }

    public void format(ByteArrayOutputStream buf) {
        byte[] data;
        block15: {
            if (buf == null) {
                return;
            }
            int tag = 0x80 | ComprehensionTlvTag.TEXT_STRING.value();
            buf.write(tag);
            if (this.mIsYesNo) {
                data = new byte[]{this.mYesNoResponse ? (byte)1 : 0};
            } else if (this.mInData != null && this.mInData.length() > 0) {
                try {
                    if (this.mIsUcs2) {
                        data = this.mInData.getBytes("UTF-16");
                        break block15;
                    }
                    if (this.mIsPacked) {
                        int size = this.mInData.length();
                        byte[] tempData = GsmAlphabet.stringToGsm7BitPacked(this.mInData, 0, 0);
                        data = new byte[size];
                        System.arraycopy(tempData, 1, data, 0, size);
                        break block15;
                    }
                    data = GsmAlphabet.stringToGsm8BitPacked(this.mInData);
                }
                catch (UnsupportedEncodingException e) {
                    data = new byte[]{};
                }
                catch (EncodeException e) {
                    data = new byte[]{};
                }
            } else {
                data = new byte[]{};
            }
        }
        buf.write(data.length + 1);
        if (this.mIsUcs2) {
            buf.write(8);
        } else if (this.mIsPacked) {
            buf.write(0);
        } else {
            buf.write(4);
        }
        for (byte b : data) {
            buf.write(b);
        }
    }
}

